/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;

public class PasteConfigurationUtils {
    private PasteConfigurationUtils() {
    }

    public static IStatus hasConsistentPasteEObjectConfiguration(PasteEObjectConfiguration pasteConfiguration) {
        Assert.isNotNull((Object)pasteConfiguration);
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        EStructuralFeature feature = pasteConfiguration.getPasteElementContainementFeature();
        if (feature == null) {
            return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.PasteConfigurationUtils_ContainmentFeatureIsNull);
        }
        if (feature instanceof EReference) {
            if (!((EReference)feature).isContainment()) {
                return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.PasteConfigurationUtils_ContainmentFeatureIsNotAReferenceContainment);
            }
            String elementId = pasteConfiguration.getPastedElementId();
            if (elementId != null && !elementId.equals("")) {
                IElementType elementType = ElementTypeRegistry.getInstance().getType(elementId);
                if (elementType != null) {
                    EClass containmentFeatureEClass;
                    boolean knownFeature;
                    EClass elementTypeMetaclass = elementType.getEClass();
                    boolean bl = knownFeature = elementTypeMetaclass == (containmentFeatureEClass = (EClass)feature.getEType()) || containmentFeatureEClass.isSuperTypeOf(elementTypeMetaclass);
                    if (knownFeature) {
                        return new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.PasteConfigurationUtils_PasteConfigurationIsConsistent);
                    }
                    return new Status(4, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.PasteConfigurationUtils_CreatesElementsAreNotCompatibleWithContainmentFeature, (Object)elementId, (Object)containmentFeatureEClass.getName()));
                }
                return new Status(4, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.PasteConfigurationUtils_ElementTypeCantBeFound, (Object)elementId));
            }
            return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.PasteConfigurationUtils_ElementIdNotDefined);
        }
        return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.PasteConfigurationUtils_ContainementFeatureIsNotAReference);
    }
}

