/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.TableDisplayStyle;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class HideShowCategoriesTableListener
implements ResourceSetListener {
    private INattableModelManager tableManager;

    public HideShowCategoriesTableListener(INattableModelManager tableManager) {
        this.tableManager = tableManager;
    }

    protected void manageHideShowCategories(Notification notification) {
        Object newValue;
        Object oldValue;
        int eventType = notification.getEventType();
        Object notifier = notification.getNotifier();
        Object toShow = null;
        Object toHide = null;
        if (notifier instanceof Table) {
            if (eventType == 4) {
                oldValue = notification.getOldValue();
                Assert.isTrue((notification.getNewValue() == null ? 1 : 0) != 0);
                toShow = ((IntListValueStyle)oldValue).getIntListValue();
            } else if (eventType == 3) {
                newValue = notification.getNewValue();
                Assert.isTrue((notification.getOldValue() == null ? 1 : 0) != 0);
                toHide = ((IntListValueStyle)newValue).getIntListValue();
            }
        }
        if (notifier instanceof IntListValueStyle) {
            if (4 == eventType) {
                oldValue = notification.getOldValue();
                Assert.isTrue((boolean)(oldValue instanceof Integer));
                toShow = Collections.singletonList((Integer)oldValue);
            }
            if (3 == eventType) {
                newValue = notification.getNewValue();
                Assert.isTrue((boolean)(newValue instanceof Integer));
                toHide = Collections.singletonList((Integer)newValue);
            }
            if (5 == eventType) {
                newValue = notification.getNewValue();
                Assert.isTrue((boolean)(newValue instanceof Collection));
                toHide = new ArrayList();
                for (Object tmp : (Collection)newValue) {
                    Assert.isTrue((boolean)(tmp instanceof Integer));
                    toHide.add((Integer)tmp);
                }
            }
            if (6 == eventType) {
                oldValue = notification.getOldValue();
                Assert.isTrue((boolean)(oldValue instanceof Collection));
                toShow = new ArrayList();
                for (Object tmp : (Collection)oldValue) {
                    Assert.isTrue((boolean)(tmp instanceof Integer));
                    toShow.add((Integer)tmp);
                }
            }
        }
        if (toShow != null || toHide != null) {
            ((ITreeNattableModelManager)this.tableManager).hideShowCategories((List<Integer>)toHide, (List<Integer>)toShow);
        }
    }

    protected void manageChangeOnDisplayStyle(Notification notification) {
        NatTable natTable;
        boolean multiToSingle = false;
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        if (notifier instanceof TableDisplayStyle && feature == NattablestylePackage.eINSTANCE.getTableDisplayStyle_DisplayStyle()) {
            Object newValue = notification.getNewValue();
            if (newValue == DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN) {
                multiToSingle = false;
            } else if (newValue == DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN) {
                multiToSingle = true;
            } else {
                return;
            }
        }
        if (notifier instanceof Table && feature == NattablestylePackage.eINSTANCE.getStyledElement_Styles()) {
            Object tmp = notification.getNewValue();
            if (!(tmp instanceof TableDisplayStyle)) {
                return;
            }
            TableDisplayStyle newValue = (TableDisplayStyle)tmp;
            if (newValue.getDisplayStyle() == DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN) {
                multiToSingle = false;
            } else if (newValue.getDisplayStyle() == DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN) {
                multiToSingle = true;
            } else {
                return;
            }
        }
        if (multiToSingle) {
            natTable = (NatTable)this.tableManager.getAdapter(NatTable.class);
            natTable.refresh();
            ((ITreeNattableModelManager)this.tableManager).hideShowColumnCategoriesInRowHeader(null, null);
        } else {
            natTable = (NatTable)this.tableManager.getAdapter(NatTable.class);
            natTable.refresh();
            ((ITreeNattableModelManager)this.tableManager).hideShowColumnCategoriesInRowHeader(StyleUtils.getHiddenDepths(this.tableManager), null);
        }
    }

    public void resourceSetChanged(ResourceSetChangeEvent arg0) {
        if (this.tableManager == null || this.tableManager.getTable() == null || this.tableManager.getTable().getTableConfiguration() == null) {
            return;
        }
        for (Notification current : arg0.getNotifications()) {
            if (HideShowCategoriesTableListener.isNotificationOnHideShowCategories(current)) {
                this.manageHideShowCategories(current);
            }
            if (!HideShowCategoriesTableListener.isNotificationOnSingleOrMultiColumnInRowHeader(current)) continue;
            this.manageChangeOnDisplayStyle(current);
        }
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent arg0) throws RollbackException {
        return null;
    }

    public NotificationFilter getFilter() {
        return new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                if (notification.isTouch() || notification.getNotifier() == null || notification.getFeature() == null) {
                    return false;
                }
                Object notifier = notification.getNotifier();
                if (notifier instanceof EObject && EcoreUtil.getRootContainer((EObject)((EObject)notifier).eClass()) == NattablePackage.eINSTANCE) {
                    try {
                        if (TableHelper.findTable((EObject)notifier) != HideShowCategoriesTableListener.this.tableManager.getTable()) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                    return HideShowCategoriesTableListener.isNotificationOnHideShowCategories(notification) || HideShowCategoriesTableListener.isNotificationOnSingleOrMultiColumnInRowHeader(notification);
                }
                return false;
            }
        };
    }

    private static final boolean isNotificationOnSingleOrMultiColumnInRowHeader(Notification notification) {
        Object feature = notification.getFeature();
        Object notifier = notification.getNotifier();
        if (notifier instanceof TableDisplayStyle && feature == NattablestylePackage.eINSTANCE.getTableDisplayStyle_DisplayStyle()) {
            return true;
        }
        if (notifier instanceof Table && feature == NattablestylePackage.eINSTANCE.getStyledElement_Styles()) {
            Object value = null;
            if (3 == notification.getEventType()) {
                value = notification.getNewValue();
            }
            if (value instanceof TableDisplayStyle) {
                return true;
            }
        }
        return false;
    }

    private static final boolean isNotificationOnHideShowCategories(Notification notification) {
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        if (notifier instanceof Table && feature == NattablestylePackage.eINSTANCE.getStyledElement_Styles()) {
            Object style = notification.getOldValue();
            if (style == null) {
                style = notification.getNewValue();
            }
            return style instanceof IntListValueStyle && ((IntListValueStyle)style).getName().equals("hiddenCategoriesByDepth");
        }
        return notifier instanceof IntListValueStyle && ((IntListValueStyle)notifier).getName().equals("hiddenCategoriesByDepth") && feature == NattablestylePackage.eINSTANCE.getIntListValueStyle_IntListValue();
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }
}

