/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor;

import org.eclipse.papyrus.infra.nattable.celleditor.MultiLineTextCellEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class MultiLineTextCellEditorEx
extends MultiLineTextCellEditor {
    private boolean initialValueForFilteringKeyPress;

    public MultiLineTextCellEditorEx() {
        this.commitOnEnter = true;
    }

    public MultiLineTextCellEditorEx(boolean lineWrap) {
        super(lineWrap);
        this.commitOnEnter = true;
    }

    @Override
    public Text createEditorControl(Composite parent) {
        IBindingService service = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        this.initialValueForFilteringKeyPress = service.isKeyFilterEnabled();
        if (this.initialValueForFilteringKeyPress) {
            service.setKeyFilterEnabled(false);
        }
        final Text text = super.createEditorControl(parent);
        text.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle bounds = text.getBounds();
                int nbLines = text.getLineCount();
                text.removeControlListener((ControlListener)this);
                if (nbLines > 1) {
                    text.setBounds(bounds.x, bounds.y, bounds.width, MultiLineTextCellEditorEx.this.getBestHeight(text));
                }
                text.removeControlListener((ControlListener)this);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return text;
    }

    @Override
    public void close() {
        if (this.initialValueForFilteringKeyPress) {
            IBindingService service = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            service.setKeyFilterEnabled(this.initialValueForFilteringKeyPress);
        }
        super.close();
    }

    @Override
    protected void keyPressed(Composite parent, Text text, KeyEvent event) {
        if (event.stateMask == 65536 && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
            text.insert(text.getLineDelimiter());
            Rectangle bounds = text.getBounds();
            text.setBounds(bounds.x, bounds.y, bounds.width, this.getBestHeight(text));
        } else {
            super.keyPressed(parent, text, event);
        }
    }

    protected final int getBestHeight(Text text) {
        return (text.getLineCount() + 1) * text.getLineHeight();
    }
}

