/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.gmfdiag.export.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class DialogDisplayUtils {
    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = DialogDisplayUtils.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = DialogDisplayUtils.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (Activator.getDefault() == null) {
            return null;
        }
        IWorkbench workBench = Activator.getDefault().getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static void displayDialog(final String title, final String message, int level) {
        if (level == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)DialogDisplayUtils.getActiveWorkbenchShell(), (String)(title == null ? "Information" : title), (String)(message == null ? "" : message));
                }
            });
        } else if (level == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)DialogDisplayUtils.getActiveWorkbenchShell(), (String)(title == null ? "Warning" : title), (String)(message == null ? "" : message));
                }
            });
        } else if (level == 4) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)DialogDisplayUtils.getActiveWorkbenchShell(), (String)(title == null ? "Error" : title), (String)(message == null ? "" : message));
                }
            });
        }
    }
}

