/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.io.File;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.Geometry;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

class Screenshot {
    private static final Display DISPLAY;
    private static final File LOCATION;

    static {
        File file;
        Display display = null;
        try {
            display = Display.getDefault();
        }
        catch (Throwable throwable) {}
        DISPLAY = display;
        File folderLocation = null;
        String location = PropertiesUtil.getProperty((String)"org.eclipse.oomph.ui.screenshot");
        if (location != null && (file = new File(location)).isDirectory()) {
            folderLocation = file;
        }
        LOCATION = folderLocation;
    }

    Screenshot() {
        if (DISPLAY != null && LOCATION != null) {
            DISPLAY.asyncExec(new Runnable(){

                public void run() {
                    DisplayMenuListener displayMenuListener = new DisplayMenuListener();
                    DisplayMouseDownListener displayMouseUpListener = new DisplayMouseDownListener();
                    DISPLAY.addFilter(3, (Listener)displayMouseUpListener);
                    DISPLAY.addFilter(1, (Listener)new DisplayKeyDownListener(displayMenuListener, displayMouseUpListener));
                    DISPLAY.addFilter(22, (Listener)displayMenuListener);
                    DISPLAY.addFilter(23, (Listener)displayMenuListener);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Capture {
        private final File folder;
        private final List<Menu> menus;
        private final ToolBar toolBar;
        private final List<Rectangle> itemBounds = new ArrayList<Rectangle>();

        public Capture(File folder, List<Menu> menus, ToolBar toolBar) {
            this.folder = folder;
            this.menus = menus;
            this.toolBar = toolBar;
            folder.mkdirs();
        }

        public void capture() {
            Control focusControl = DISPLAY.getFocusControl();
            if (focusControl != null) {
                Control effectiveControl = this.toolBar == null ? focusControl : this.toolBar;
                this.capture(0, "FocusControl", effectiveControl);
                this.captureMenus(effectiveControl);
            }
        }

        private void captureMenus(Control control) {
            if (!this.menus.isEmpty()) {
                Rectangle bounds;
                Decorations parent;
                int count = 0;
                ArrayList<Rectangle> allBounds = new ArrayList<Rectangle>();
                for (Menu menu : this.menus) {
                    parent = menu.getParent();
                    bounds = (Rectangle)ReflectUtil.invokeMethod((String)"getBounds", (Object)menu);
                    --bounds.x;
                    --bounds.y;
                    bounds.width += 2;
                    bounds.height += 2;
                    this.captureDrawable((Drawable)parent, bounds, "Menu" + this.toString(++count) + ".png");
                    allBounds.add(bounds);
                }
                Shell shell = control.getShell();
                Menu menuBar = shell.getMenuBar();
                if (menuBar != null) {
                    parent = menuBar.getParent();
                    bounds = (Rectangle)ReflectUtil.invokeMethod((String)"getBounds", (Object)menuBar);
                    this.captureDrawable((Drawable)parent, bounds, "MenuBar.png");
                    MenuItem[] menuItemArray = menuBar.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem menuItem = menuItemArray[n2];
                        Rectangle menuItemBounds = (Rectangle)ReflectUtil.invokeMethod((String)"getBounds", (Object)menuItem);
                        Geometry.moveRectangle((Rectangle)menuItemBounds, (Point)new Point(bounds.x, bounds.y));
                        this.itemBounds.add(menuItemBounds);
                        ++n2;
                    }
                }
                if (!allBounds.isEmpty()) {
                    this.captureDrawable((Drawable)DISPLAY, allBounds, "Menu" + this.toString(++count) + ".png");
                    for (Rectangle itemBound : this.itemBounds) {
                        Rectangle copy = Geometry.copy((Rectangle)itemBound);
                        Geometry.expand((Rectangle)copy, (int)0, (int)0, (int)0, (int)2);
                        if (!copy.intersects((Rectangle)allBounds.get(0))) continue;
                        allBounds.add(0, itemBound);
                        this.captureDrawable((Drawable)DISPLAY, allBounds, "Menu" + this.toString(++count) + ".png");
                        break;
                    }
                }
            }
        }

        private void capture(int count, String fileName, Control control) {
            Composite parent;
            Point size = control.getSize();
            Point preferredSize = control.computeSize(-1, -1);
            if (preferredSize.x < size.x && preferredSize.y < size.y) {
                this.captureDrawable((Drawable)control, new Rectangle(0, 0, preferredSize.x, preferredSize.y), String.valueOf(fileName) + this.toString(++count) + ".png");
            }
            this.captureDrawable((Drawable)control, new Rectangle(0, 0, size.x, size.y), String.valueOf(fileName) + this.toString(++count) + ".png");
            if (control instanceof ToolBar) {
                int toolItemCount = 0;
                ToolBar toolBar = (ToolBar)control;
                ToolItem[] toolItemArray = toolBar.getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem toolItem = toolItemArray[n2];
                    Rectangle bounds = toolItem.getBounds();
                    this.captureDrawable((Drawable)toolBar, bounds, "ToolItem" + this.toString(++toolItemCount) + ".png");
                    Point displayPoint = toolBar.toDisplay(bounds.x, bounds.y);
                    bounds.x = displayPoint.x;
                    bounds.y = displayPoint.y;
                    this.itemBounds.add(bounds);
                    ++n2;
                }
            }
            if ((parent = control.getParent()) != null) {
                this.capture(count, parent);
            }
        }

        private void capture(int count, Composite composite) {
            Point size = composite.getSize();
            if (composite instanceof Shell) {
                Shell shell = (Shell)composite;
                Rectangle bounds = shell.getBounds();
                Composite parent = shell.getParent();
                if (parent == null) {
                    bounds.x -= 16;
                    bounds.y -= 16;
                    bounds.width += 32;
                    bounds.height += 32;
                }
                this.captureDrawable((Drawable)composite, bounds, "Parent" + this.toString(count) + ".png");
                if (parent != null) {
                    IWorkbenchPartReference activePartReference;
                    IWorkbenchWindow workbenchWindow;
                    IWorkbenchPage activePage;
                    Point clientOffset = ((Shell)parent).toControl(shell.toDisplay(0, 0));
                    Point targetPoint = shell.toDisplay(clientOffset);
                    bounds.x -= 16;
                    bounds.y -= 16;
                    bounds.width += 32;
                    bounds.height += 32;
                    this.captureDrawable((Drawable)composite, bounds, "Parent" + this.toString(count) + ".png");
                    if (parent.getData() instanceof IWorkbenchWindow && (activePage = (workbenchWindow = (IWorkbenchWindow)parent.getData()).getActivePage()) != null && (activePartReference = activePage.getActivePartReference()) != null) {
                        Object part = this.get(activePartReference, "part", Object.class);
                        Composite activePartComposite = this.get(part, "widget", Composite.class);
                        Control control = this.findControl(activePartComposite, targetPoint);
                        if (control != activePartComposite) {
                            this.capture(count, "Parent", (Control)activePartComposite);
                        } else {
                            this.capture(count + 1, activePartComposite);
                        }
                        return;
                    }
                }
            } else {
                this.captureDrawable((Drawable)composite, new Rectangle(0, 0, size.x, size.y), "Parent" + this.toString(count) + ".png");
            }
            Composite parent = composite.getParent();
            while (parent != null) {
                if (!parent.getSize().equals((Object)size)) {
                    this.capture(count + 1, parent);
                    break;
                }
                parent = parent.getParent();
            }
        }

        private void captureDrawable(Drawable drawable, Rectangle bounds, String fileName) {
            GC gc = new GC((Drawable)DISPLAY);
            Image image = this.newImage(bounds);
            Point displayPoint = this.toDisplay(drawable, new Point(bounds.x, bounds.y));
            gc.copyArea(image, displayPoint.x, displayPoint.y);
            this.drawCaret(drawable, gc, image);
            GC imageGC = new GC((Drawable)image);
            this.drawCursor(drawable, imageGC, bounds);
            imageGC.dispose();
            gc.dispose();
            this.save(image, fileName);
            image.dispose();
        }

        private void captureDrawable(Drawable drawable, List<Rectangle> allBounds, String fileName) {
            Rectangle imageBounds = null;
            for (Rectangle rectangle : allBounds) {
                if (imageBounds == null) {
                    imageBounds = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    continue;
                }
                imageBounds.add(rectangle);
            }
            GC gc = new GC((Drawable)DISPLAY);
            LinkedHashMap<Image, Point> images = new LinkedHashMap<Image, Point>();
            for (Rectangle bounds : allBounds) {
                Image image = this.newImage(bounds);
                Point imagePoint = new Point(bounds.x, bounds.y);
                Point displayPoint = this.toDisplay(drawable, imagePoint);
                gc.copyArea(image, displayPoint.x, displayPoint.y);
                this.drawCaret(drawable, gc, image);
                GC imageGC = new GC((Drawable)image);
                this.drawCursor(drawable, imageGC, bounds);
                imageGC.dispose();
                images.put(image, imagePoint);
            }
            Image image = this.newImage(imageBounds, true);
            GC imageGC = new GC((Drawable)image);
            for (Map.Entry entry : images.entrySet()) {
                Image childImage = (Image)entry.getKey();
                Point point = (Point)entry.getValue();
                Point targetPoint = new Point(point.x - imageBounds.x, point.y - imageBounds.y);
                imageGC.drawImage(childImage, targetPoint.x, targetPoint.y);
                childImage.dispose();
            }
            imageGC.dispose();
            gc.dispose();
            this.save(image, fileName);
            image.dispose();
        }

        private Point toDisplay(Drawable drawable, Point point) {
            return drawable instanceof Control && !(drawable instanceof Shell) ? ((Control)drawable).toDisplay(point) : point;
        }

        private Control findControl(Composite composite, Point targetPoint) {
            Control[] children;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Rectangle bounds = child.getBounds();
                Point displayPoint = child.toDisplay(bounds.x, bounds.y);
                bounds.x = displayPoint.x;
                bounds.y = displayPoint.y;
                if (bounds.contains(targetPoint)) {
                    return child instanceof Composite ? this.findControl((Composite)child, targetPoint) : child;
                }
                ++n2;
            }
            return composite;
        }

        private void drawCursor(Drawable drawable, GC gc, Rectangle bounds) {
            Control cursorControl = DISPLAY.getCursorControl();
            Cursor cursor = cursorControl instanceof Text ? DISPLAY.getSystemCursor(19) : (cursorControl == null ? null : cursorControl.getCursor());
            MouseCursor mouseCursor = MouseCursor.getMouseCursor(cursor);
            Point cursorLocation = DISPLAY.getCursorLocation();
            if (drawable instanceof Control) {
                cursorLocation = ((Control)drawable).toControl(cursorLocation);
                if (drawable instanceof Shell) {
                    Shell shell = (Shell)drawable;
                    Point clientOffset = shell.toControl(bounds.x, bounds.y);
                    cursorLocation.x -= clientOffset.x;
                    cursorLocation.y -= clientOffset.y;
                }
            } else if (drawable instanceof Display) {
                cursorLocation.x -= bounds.x;
                cursorLocation.y -= bounds.y;
            }
            mouseCursor.drawMouseCursor(gc, cursorLocation);
        }

        private void drawCaret(Drawable drawable, GC gc, Image image) {
            try {
                Caret caret = this.invoke(drawable, "getCaret", Caret.class);
                if (caret != null && caret.getVisible()) {
                    GC imageGC = new GC((Drawable)image);
                    imageGC.setBackground(gc.getForeground());
                    Rectangle caretBounds = caret.getBounds();
                    imageGC.fillRectangle(caretBounds);
                    imageGC.dispose();
                }
            }
            catch (Exception exception) {}
        }

        private void save(Image image, String fileName) {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            loader.save(new File(this.folder, fileName).toString(), 5);
        }

        private Image newImage(Rectangle bounds) {
            return this.newImage(bounds, false);
        }

        private Image newImage(Rectangle bounds, boolean transparent) {
            Image image = new Image((Device)DISPLAY, bounds.width, bounds.height);
            if (transparent) {
                ImageData imageData = image.getImageData();
                imageData.transparentPixel = imageData.getPixel(0, 0);
                Image transparentImage = new Image((Device)DISPLAY, imageData);
                image.dispose();
                return transparentImage;
            }
            return image;
        }

        private <T> T invoke(Object object, String methodName, Class<T> returnType) {
            try {
                return returnType.cast(object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]));
            }
            catch (Exception exception) {
                return null;
            }
        }

        private <T> T get(Object object, String fieldName, Class<T> returnType) {
            try {
                Class<?> aClass = object.getClass();
                while (aClass != null) {
                    try {
                        Field field = aClass.getDeclaredField(fieldName);
                        field.setAccessible(true);
                        return returnType.cast(field.get(object));
                    }
                    catch (Exception exception) {
                        aClass = aClass.getSuperclass();
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            throw new RuntimeException("No such field");
        }

        private String toString(int count) {
            String result = Integer.toString(count);
            while (result.length() < 2) {
                result = "0" + result;
            }
            return result;
        }

        private static class MouseCursor {
            private static final Map<Cursor, MouseCursor> CURSORS = new HashMap<Cursor, MouseCursor>();
            private Image image;
            private Point hotspot;

            private MouseCursor() {
            }

            public static MouseCursor getMouseCursor(Cursor cursor) {
                MouseCursor mouseCursor = CURSORS.get(cursor);
                if (mouseCursor == null) {
                    if (cursor == DISPLAY.getSystemCursor(19)) {
                        mouseCursor = new MouseCursor();
                        mouseCursor.image = MouseCursor.getCursorImage("IBeam");
                        Rectangle bounds = mouseCursor.image.getBounds();
                        mouseCursor.hotspot = new Point(1, (bounds.height - 1) / 2);
                    } else {
                        mouseCursor = new MouseCursor();
                        mouseCursor.image = MouseCursor.getCursorImage("Default");
                        mouseCursor.hotspot = new Point(0, 0);
                    }
                }
                return mouseCursor;
            }

            public void drawMouseCursor(GC gc, Point location) {
                gc.drawImage(this.image, location.x - this.hotspot.x, location.y - this.hotspot.y);
            }

            private static Image getCursorImage(String type) {
                return UIPlugin.INSTANCE.getSWTImage(String.valueOf(type.toLowerCase()) + "-cursor.png");
            }
        }
    }

    private static final class DisplayKeyDownListener
    implements Listener {
        private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        private final DisplayMenuListener displayMenuListener;
        private final DisplayMouseDownListener displayMouseUpListener;
        private long lastControl;
        private long lastShift;

        public DisplayKeyDownListener(DisplayMenuListener displayMenuListener, DisplayMouseDownListener displayMouseUpListener) {
            this.displayMenuListener = displayMenuListener;
            this.displayMouseUpListener = displayMouseUpListener;
        }

        public void handleEvent(Event event) {
            long now = System.currentTimeMillis();
            if ((event.stateMask & SWT.MODIFIER_MASK) == 0 && event.keyCode == 262144) {
                if (now - this.lastControl < 500L) {
                    UIPlugin.INSTANCE.log("immediate-capture", 1);
                    new Capture(new File(LOCATION, DATE_FORMAT.format(new Date(System.currentTimeMillis()))), this.displayMenuListener.menus, this.displayMouseUpListener.toolBar).capture();
                    this.displayMouseUpListener.toolBar = null;
                } else {
                    this.lastControl = now;
                }
            } else if ((event.stateMask & SWT.MODIFIER_MASK) == 0 && event.keyCode == 131072) {
                if (now - this.lastShift < 500L) {
                    UIPlugin.INSTANCE.log("delay-capture", 1);
                    DISPLAY.timerExec(5000, new Runnable(){

                        public void run() {
                            UIPlugin.INSTANCE.log("capturing-now", 1);
                            new Capture(new File(LOCATION, DATE_FORMAT.format(new Date(System.currentTimeMillis()))), DisplayKeyDownListener.this.displayMenuListener.menus, DisplayKeyDownListener.this.displayMouseUpListener.toolBar).capture();
                            DisplayKeyDownListener.this.displayMouseUpListener.toolBar = null;
                        }
                    });
                } else {
                    this.lastShift = now;
                }
            } else {
                this.lastControl = 0L;
                this.lastShift = 0L;
            }
        }
    }

    private static final class DisplayMenuListener
    implements Listener {
        private List<Menu> menus = new ArrayList<Menu>();

        private DisplayMenuListener() {
        }

        public void handleEvent(Event event) {
            if (event.widget instanceof Menu) {
                Menu menu = (Menu)event.widget;
                if (event.type == 22) {
                    this.menus.add(menu);
                } else {
                    this.menus.remove(menu);
                }
            }
        }
    }

    private static final class DisplayMouseDownListener
    implements Listener {
        private ToolBar toolBar;

        private DisplayMouseDownListener() {
        }

        public void handleEvent(Event event) {
            this.toolBar = event.widget instanceof ToolBar ? (ToolBar)event.widget : null;
        }
    }
}

