/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager;

import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterable<E>
implements Iterable<E> {
    private final Iterable<? extends E>[] iterables;

    public CompositeIterable(Iterable<? extends E> ... iterables) {
        this.iterables = iterables;
    }

    public CompositeIterable(Collection<? extends Iterable<? extends E>> iterables) {
        this.iterables = iterables.toArray(new Iterable[0]);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int nextSet = 0;
            private Iterator<? extends E> iter = this.nextIter();

            @Override
            public boolean hasNext() {
                return this.iter != null && this.iter.hasNext();
            }

            private Iterator<? extends E> nextIter() {
                Iterator result = null;
                while (!(this.nextSet >= CompositeIterable.this.iterables.length || result != null && result.hasNext())) {
                    result = CompositeIterable.this.iterables[this.nextSet++].iterator();
                }
                return result;
            }

            @Override
            public E next() {
                Object result = this.iter.next();
                if (!this.iter.hasNext()) {
                    this.iter = this.nextIter();
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read-only iterator on composite set");
            }
        };
    }

    protected Iterable<? extends E>[] getIterables() {
        return this.iterables;
    }
}

