/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.jplis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.eclipse.objectteams.otre.BaseCallRedirection;
import org.eclipse.objectteams.otre.BaseMethodTransformation;
import org.eclipse.objectteams.otre.Decapsulation;
import org.eclipse.objectteams.otre.LiftingParticipantTransformation;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.RepositoryAccess;
import org.eclipse.objectteams.otre.StaticSliceBaseTransformation;
import org.eclipse.objectteams.otre.SubBoundBaseMethodRedefinition;
import org.eclipse.objectteams.otre.TeamInterfaceImplementation;
import org.eclipse.objectteams.otre.ThreadActivation;
import org.eclipse.objectteams.otre.bcel.DietClassLoaderRepository;
import org.eclipse.objectteams.otre.jplis.JPLISEnhancer;
import org.eclipse.objectteams.otre.util.AttributeReadingGuard;
import org.eclipse.objectteams.otre.util.CallinBindingManager;

public class ObjectTeamsTransformer
implements ClassFileTransformer {
    static boolean SUPPRESS_CFE_STDERR = System.getProperty("otre.suppress.classformaterror.stderr", null) != null;
    static Class<?>[] transformerClasses = new Class[]{BaseCallRedirection.class, BaseMethodTransformation.class, Decapsulation.class, LiftingParticipantTransformation.class, StaticSliceBaseTransformation.class, SubBoundBaseMethodRedefinition.class, TeamInterfaceImplementation.class, ThreadActivation.class};
    static boolean warmedUp = false;
    private ObjectTeamsTransformation firstTransformation;
    static boolean dumping = false;

    static {
        if (System.getProperty("ot.dump") != null) {
            dumping = true;
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        return this.transform((Object)loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    public byte[] transform(Object loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (warmedUp || loader == null) {
            return this.internalTransform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }
        Object object = loader;
        synchronized (object) {
            byte[] byArray;
            try {
                byArray = this.internalTransform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                warmedUp = true;
            }
            catch (Throwable throwable) {
                warmedUp = true;
                throw throwable;
            }
            return byArray;
        }
    }

    public byte[] internalTransform(Object loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        switch (className.charAt(0)) {
            case 'o': {
                if (!className.startsWith("org/eclipse/objectteams/otre") && !className.startsWith("org/apache/bcel")) break;
                return null;
            }
            case 's': {
                if (!className.startsWith("sun/misc")) break;
                return null;
            }
            case 'j': {
                if (className.equals("java/util/LinkedHashMap$KeyIterator")) {
                    return null;
                }
                if (!className.equals("java/util/function/Function")) break;
                return null;
            }
        }
        if (classBeingRedefined != null && !ObjectTeamsTransformation.debugging) {
            System.out.println("Redefinition!");
            return null;
        }
        BaseCallRedirection baseCallRedirection = new BaseCallRedirection(loader);
        BaseMethodTransformation baseMethodTransformation = new BaseMethodTransformation(loader);
        Decapsulation decapsulation = new Decapsulation(loader);
        LiftingParticipantTransformation liftingParticipantTransformation = new LiftingParticipantTransformation(loader);
        StaticSliceBaseTransformation staticSliceBaseTransformation = new StaticSliceBaseTransformation(loader);
        SubBoundBaseMethodRedefinition subBoundBaseMethodRedefinition = new SubBoundBaseMethodRedefinition(loader);
        TeamInterfaceImplementation teamInterfaceImplementation = new TeamInterfaceImplementation(loader);
        ThreadActivation threadActivation = new ThreadActivation();
        DietClassLoaderRepository prevRepository = RepositoryAccess.setClassLoader(loader);
        try {
            List<String> basesOfTeam;
            JavaClass java_class;
            ByteArrayInputStream is = new ByteArrayInputStream(classfileBuffer);
            try {
                try {
                    java_class = new ClassParser((InputStream)is, className).parse();
                }
                catch (ClassFormatException e) {
                    if (!SUPPRESS_CFE_STDERR) {
                        System.err.println(String.valueOf(e.getMessage()) + ", offending className: " + className);
                    }
                    throw new IllegalClassFormatException("BCEL cannot parse class " + className + ": " + e.getMessage());
                }
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ClassGen cg = new ClassGen(java_class);
            JPLISEnhancer jpe = new JPLISEnhancer(cg, loader);
            Collection<String> adaptedBases = this.setFirstTransformation(subBoundBaseMethodRedefinition);
            if (ObjectTeamsTransformation.peekIsteam(cg) && !AttributeReadingGuard.getInstanceForLoader(loader).iAmTheFirst(cg.getClassName()) && (basesOfTeam = CallinBindingManager.getBasesPerTeam(cg.getClassName())) != null) {
                adaptedBases.addAll(basesOfTeam);
            }
            subBoundBaseMethodRedefinition.doTransformInterface(jpe, cg);
            baseCallRedirection.doTransformInterface(jpe, cg);
            decapsulation.doTransformInterface(jpe, cg);
            try {
                baseMethodTransformation.useReflection = loader == null;
                baseMethodTransformation.doTransformInterface(jpe, cg);
            }
            catch (Throwable t) {
                System.err.println("Error transforming class: " + cg.getClassName());
                t.printStackTrace();
            }
            staticSliceBaseTransformation.doTransformInterface(jpe, cg);
            teamInterfaceImplementation.doTransformInterface(jpe, cg);
            threadActivation.doTransformInterface(jpe, cg);
            baseMethodTransformation.doTransformCode(cg);
            liftingParticipantTransformation.doTransformCode(cg);
            staticSliceBaseTransformation.doTransformCode(cg);
            teamInterfaceImplementation.doTransformCode(cg);
            threadActivation.doTransformCode(cg);
            JavaClass new_java_class = cg.getJavaClass();
            if (dumping) {
                String binaryName = className.replace('.', '/');
                new_java_class.dump("jplis_dump/" + binaryName + ".class");
            }
            byte[] byArray = new_java_class.getBytes();
            return byArray;
        }
        catch (IOException e) {
            System.err.println("ClassFileTransformer could not parse class file buffer to JavaClass");
            e.printStackTrace();
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
        finally {
            RepositoryAccess.resetRepository(prevRepository);
        }
        return null;
    }

    public Collection<String> fetchAdaptedBases() {
        if (this.firstTransformation == null) {
            return null;
        }
        Collection<String> result = this.firstTransformation.fetchAdaptedBases();
        this.firstTransformation = null;
        return result;
    }

    public void readOTAttributes(InputStream file, String fileName, Object loader) throws ClassFormatError, IOException {
        ClassParser cp = new ClassParser(file, fileName);
        ClassGen cg = new ClassGen(cp.parse());
        JPLISEnhancer jpe = new JPLISEnhancer(cg, null);
        DietClassLoaderRepository prevRepository = RepositoryAccess.setClassLoader(loader);
        try {
            this.setFirstTransformation(new ObjectTeamsTransformation(loader){});
            this.firstTransformation.checkReadClassAttributes(jpe, cg, cg.getClassName(), cg.getConstantPool());
        }
        finally {
            RepositoryAccess.resetRepository(prevRepository);
        }
    }

    private Collection<String> setFirstTransformation(ObjectTeamsTransformation t) {
        if (this.firstTransformation != null) {
            t.adaptedBases = this.firstTransformation.adaptedBases;
        }
        this.firstTransformation = t;
        return t.adaptedBases;
    }
}

