/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.util.HashMap;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IASTORE;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.ClassEnhancer;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.util.CallinBindingManager;

public class StaticSliceBaseTransformation
extends ObjectTeamsTransformation {
    static final String _OT_ACTIVE_TEAMS = "_OT$activeTeams";
    static final String _OT_ACTIVE_TEAM_IDS = "_OT$activeTeamIDs";
    private HashMap<String, String> rejectReasons = new HashMap();

    public StaticSliceBaseTransformation(Object loader) {
        super(loader);
    }

    public void doTransformCode(ClassGen cg) {
        if (cg.isInterface()) {
            return;
        }
        String class_name = cg.getClassName();
        if (!CallinBindingManager.isBoundBaseClass(class_name)) {
            return;
        }
        if (CallinBindingManager.hasBoundBaseParent(class_name) == CallinBindingManager.BoundSuperKind.CLASS) {
            return;
        }
        String reason = this.rejectReasons.get(class_name);
        if (reason != null && !"already has clinit? static void <clinit>()".equals(reason)) {
            new IllegalStateException(reason).printStackTrace();
        }
        ConstantPoolGen cpg = cg.getConstantPool();
        this.factory = new InstructionFactory(cpg);
        this.addStaticInitializations(cg, cpg);
    }

    public void doTransformInterface(ClassEnhancer ce, ClassGen cg) {
        try {
            String class_name = cg.getClassName();
            ConstantPoolGen cpg = cg.getConstantPool();
            this.checkReadClassAttributes(ce, cg, class_name, cpg);
            if (cg.isInterface()) {
                this.rejectReasons.put(class_name, "is interface");
                return;
            }
            if (!CallinBindingManager.isBoundBaseClass(class_name)) {
                this.rejectReasons.put(class_name, "not bound base class");
                if ("org.eclipse.objectteams.otdt.internal.core.compiler.ast.RoleFileCache".equals(class_name)) {
                    new IllegalStateException("RoleFileCache is not recognized as bound base").printStackTrace();
                }
                return;
            }
            if (CallinBindingManager.hasBoundBaseParent(class_name) == CallinBindingManager.BoundSuperKind.CLASS) {
                this.rejectReasons.put(class_name, "hasBoundBaseParent");
                return;
            }
            if (logging) {
                StaticSliceBaseTransformation.printLogMessage("StaticSliceBaseTransformer transforms " + class_name);
            }
            if (CallinBindingManager.isRole(class_name)) {
                this.addImplicitSubclassNotificationInfrastructure(ce, cg);
            }
            int accessFlags = 12;
            FieldGen activeTeamsField = new FieldGen(accessFlags, (Type)teamArray, _OT_ACTIVE_TEAMS, cpg);
            ce.addField(activeTeamsField.getField(), cg);
            FieldGen activeTeamIDsField = new FieldGen(accessFlags, (Type)intArray, _OT_ACTIVE_TEAM_IDS, cpg);
            ce.addField(activeTeamIDsField.getField(), cg);
            this.factory = new InstructionFactory(cpg);
            ce.addMethod(this.genAddTeam(class_name, cg.getMajor(), cpg).getMethod(), cg);
            ce.addMethod(this.genRemoveTeam(class_name, cg.getMajor(), cpg).getMethod(), cg);
            Method clinit = cg.containsMethod("<clinit>", "()V");
            if (clinit != null) {
                this.rejectReasons.put(class_name, "already has clinit? " + (clinit == null ? "no" : clinit.toString()));
                return;
            }
            InstructionList il = new InstructionList();
            MethodGen clinitMethod = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<clinit>", class_name, il, cpg);
            il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
            clinitMethod.setMaxStack();
            clinitMethod.setMaxLocals();
            ce.addMethod(clinitMethod.getMethod(), cg);
            il.dispose();
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
        catch (Error err) {
            err.printStackTrace();
            throw err;
        }
    }

    private MethodGen genAddTeam(String class_name, int major, ConstantPoolGen cpg) {
        InstructionList il = new InstructionList();
        MethodGen addTeamMethod = new MethodGen(41, (Type)Type.VOID, new Type[]{teamType, Type.INT}, new String[]{"team", "teamID"}, "_OT$addTeam", class_name, il, cpg);
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)178));
        il.append((Instruction)new ARRAYLENGTH());
        LocalVariableGen lg = addTeamMethod.addLocalVariable("l", (Type)Type.INT, null, null);
        int l = lg.getIndex();
        il.append((Instruction)new DUP());
        lg.setStart(il.append((Instruction)InstructionFactory.createStore((Type)Type.INT, (int)l)));
        BranchHandle emptyArray = il.append((BranchInstruction)new IFEQ(null));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)178));
        il.append((Instruction)new ICONST(0));
        il.append((Instruction)InstructionFactory.createArrayLoad((Type)teamType));
        il.append((Instruction)new ALOAD(0));
        BranchHandle noDuplication = il.append((BranchInstruction)new IF_ACMPNE(null));
        GOTO earlyExit = new GOTO(null);
        il.append((BranchInstruction)earlyExit);
        InstructionHandle skipReturn = il.append((Instruction)new NOP());
        emptyArray.setTarget(skipReturn);
        noDuplication.setTarget(skipReturn);
        lg = addTeamMethod.addLocalVariable("newTeams", (Type)teamArray, null, null);
        int newTeams = lg.getIndex();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)l));
        il.append((Instruction)new ICONST(1));
        il.append((Instruction)new IADD());
        il.append(this.factory.createNewArray((Type)teamType, (short)1));
        lg.setStart(il.append((Instruction)InstructionFactory.createStore((Type)teamArray, (int)newTeams)));
        lg = addTeamMethod.addLocalVariable("newTeamIDs", (Type)intArray, null, null);
        int newTeamIDs = lg.getIndex();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)l));
        il.append((Instruction)new ICONST(1));
        il.append((Instruction)new IADD());
        il.append(this.factory.createNewArray((Type)Type.INT, (short)1));
        lg.setStart(il.append((Instruction)InstructionFactory.createStore((Type)intArray, (int)newTeamIDs)));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)178));
        il.append((Instruction)new ICONST(0));
        il.append((Instruction)InstructionFactory.createLoad((Type)teamArray, (int)newTeams));
        il.append((Instruction)new ICONST(1));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)l));
        ObjectType object = new ObjectType("java.lang.Object");
        il.append((Instruction)this.factory.createInvoke("java.lang.System", "arraycopy", (Type)Type.VOID, new Type[]{object, Type.INT, object, Type.INT, Type.INT}, (short)184));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAM_IDS, (Type)intArray, (short)178));
        il.append((Instruction)new ICONST(0));
        il.append((Instruction)InstructionFactory.createLoad((Type)intArray, (int)newTeamIDs));
        il.append((Instruction)new ICONST(1));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)l));
        il.append((Instruction)this.factory.createInvoke("java.lang.System", "arraycopy", (Type)Type.VOID, new Type[]{object, Type.INT, object, Type.INT, Type.INT}, (short)184));
        il.append((Instruction)InstructionFactory.createLoad((Type)teamArray, (int)newTeams));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)179));
        il.append((Instruction)InstructionFactory.createLoad((Type)intArray, (int)newTeamIDs));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAM_IDS, (Type)intArray, (short)179));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)178));
        il.append((Instruction)new ICONST(0));
        il.append((Instruction)new ALOAD(0));
        il.append((Instruction)InstructionFactory.createArrayStore((Type)teamType));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAM_IDS, (Type)intArray, (short)178));
        il.append((Instruction)new ICONST(0));
        il.append((Instruction)new ILOAD(1));
        il.append((Instruction)InstructionFactory.createArrayStore((Type)Type.INT));
        if (CallinBindingManager.isRole(class_name)) {
            il.append((Instruction)new ALOAD(0));
            il.append((Instruction)new ILOAD(1));
            il.append((Instruction)this.factory.createInvoke(class_name, "_OT$activateNotify", (Type)Type.VOID, new Type[]{teamType, Type.INT}, (short)184));
        }
        InstructionHandle exit = il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        earlyExit.setTarget(exit);
        addTeamMethod.setMaxStack();
        addTeamMethod.setMaxLocals();
        addTeamMethod.removeNOPs();
        return addTeamMethod;
    }

    private MethodGen genRemoveTeam(String class_name, int major, ConstantPoolGen cpg) {
        InstructionList il = new InstructionList();
        MethodGen removeTeamMethod = new MethodGen(41, (Type)Type.VOID, new Type[]{teamType}, new String[]{"team"}, "_OT$removeTeam", class_name, il, cpg);
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)178));
        il.append((Instruction)new ARRAYLENGTH());
        LocalVariableGen lg = removeTeamMethod.addLocalVariable("l", (Type)Type.INT, null, null);
        int l = lg.getIndex();
        il.append((Instruction)new DUP());
        lg.setStart(il.append((Instruction)InstructionFactory.createStore((Type)Type.INT, (int)l)));
        BranchHandle emptyArray = il.append((BranchInstruction)new IFNE(null));
        GOTO earlyExit = new GOTO(null);
        il.append((BranchInstruction)earlyExit);
        emptyArray.setTarget(il.append((Instruction)new NOP()));
        lg = removeTeamMethod.addLocalVariable("found", (Type)Type.BOOLEAN, null, null);
        int found = lg.getIndex();
        il.append((Instruction)new ICONST(0));
        lg.setStart(il.append((Instruction)InstructionFactory.createStore((Type)Type.BOOLEAN, (int)found)));
        lg = removeTeamMethod.addLocalVariable("newTeams", (Type)teamArray, null, null);
        int newTeams = lg.getIndex();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)l));
        LocalVariableGen lgNewLen = removeTeamMethod.addLocalVariable("newLen", (Type)Type.INT, il.getEnd(), null);
        il.append((Instruction)new ICONST(1));
        il.append((Instruction)new ISUB());
        il.append((Instruction)new DUP());
        il.append((Instruction)InstructionFactory.createStore((Type)Type.INT, (int)lgNewLen.getIndex()));
        il.append(this.factory.createNewArray((Type)teamType, (short)1));
        lg.setStart(il.append((Instruction)InstructionFactory.createStore((Type)teamArray, (int)newTeams)));
        lg = removeTeamMethod.addLocalVariable("newTeamIDs", (Type)intArray, null, null);
        int newTeamIDs = lg.getIndex();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)lgNewLen.getIndex()));
        il.append(this.factory.createNewArray((Type)Type.INT, (short)1));
        lg.setStart(il.append((Instruction)InstructionFactory.createStore((Type)intArray, (int)newTeamIDs)));
        lg = removeTeamMethod.addLocalVariable("i", (Type)Type.INT, null, null);
        int loopCounter = lg.getIndex();
        il.append((Instruction)new ICONST(0));
        lg.setStart(il.append((Instruction)InstructionFactory.createStore((Type)Type.INT, (int)loopCounter)));
        GOTO try_leave_loop = new GOTO(null);
        il.append((BranchInstruction)try_leave_loop);
        InstructionHandle i_lower_l = il.append((Instruction)new NOP());
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.BOOLEAN, (int)found));
        IFNE already_found = new IFNE(null);
        il.append((BranchInstruction)already_found);
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)178));
        il.append((Instruction)new ILOAD(loopCounter));
        il.append((Instruction)InstructionFactory.createArrayLoad((Type)teamType));
        il.append((Instruction)new ALOAD(0));
        IF_ACMPNE teams_not_equal = new IF_ACMPNE(null);
        il.append((BranchInstruction)teams_not_equal);
        il.append((Instruction)new ICONST(1));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.BOOLEAN, (int)found));
        GOTO skip_outer_else_part = new GOTO(null);
        il.append((BranchInstruction)skip_outer_else_part);
        teams_not_equal.setTarget(il.append((Instruction)new NOP()));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)lgNewLen.getIndex()));
        il.append((Instruction)new ILOAD(loopCounter));
        IF_ICMPLE if_len_le_i = new IF_ICMPLE(null);
        il.append((BranchInstruction)if_len_le_i);
        il.append((Instruction)new ALOAD(newTeams));
        il.append((Instruction)new ILOAD(loopCounter));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)178));
        il.append((Instruction)new ILOAD(loopCounter));
        il.append((Instruction)InstructionFactory.createArrayLoad((Type)teamType));
        il.append((Instruction)new AASTORE());
        il.append((Instruction)new ALOAD(newTeamIDs));
        il.append((Instruction)new ILOAD(loopCounter));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAM_IDS, (Type)intArray, (short)178));
        il.append((Instruction)new ILOAD(loopCounter));
        il.append((Instruction)InstructionFactory.createArrayLoad((Type)Type.INT));
        il.append((Instruction)new IASTORE());
        GOTO end_of_loop = new GOTO(null);
        il.append((BranchInstruction)end_of_loop);
        already_found.setTarget(il.append((Instruction)new NOP()));
        il.append((Instruction)new ALOAD(newTeams));
        il.append((Instruction)new ILOAD(loopCounter));
        il.append((Instruction)new ICONST(1));
        il.append((Instruction)new ISUB());
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)178));
        il.append((Instruction)new ILOAD(loopCounter));
        il.append((Instruction)InstructionFactory.createArrayLoad((Type)teamType));
        il.append((Instruction)new AASTORE());
        il.append((Instruction)new ALOAD(newTeamIDs));
        il.append((Instruction)new ILOAD(loopCounter));
        il.append((Instruction)new ICONST(1));
        il.append((Instruction)new ISUB());
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAM_IDS, (Type)intArray, (short)178));
        il.append((Instruction)new ILOAD(loopCounter));
        il.append((Instruction)InstructionFactory.createArrayLoad((Type)Type.INT));
        il.append((Instruction)new IASTORE());
        skip_outer_else_part.setTarget(il.append((Instruction)new NOP()));
        if_len_le_i.setTarget(il.getEnd());
        end_of_loop.setTarget(il.append((Instruction)new IINC(loopCounter, 1)));
        try_leave_loop.setTarget(il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)loopCounter)));
        il.append((Instruction)new ILOAD(l));
        il.append((BranchInstruction)new IF_ICMPLT(i_lower_l));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.BOOLEAN, (int)found));
        BranchHandle notFound = il.append((BranchInstruction)new IFEQ(null));
        il.append((Instruction)InstructionFactory.createLoad((Type)teamArray, (int)newTeams));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)179));
        il.append((Instruction)InstructionFactory.createLoad((Type)intArray, (int)newTeamIDs));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAM_IDS, (Type)intArray, (short)179));
        if (CallinBindingManager.isRole(class_name)) {
            il.append((Instruction)new ALOAD(0));
            il.append((Instruction)this.factory.createInvoke(class_name, "_OT$deactivateNotify", (Type)Type.VOID, new Type[]{teamType}, (short)184));
        }
        InstructionHandle exit = il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        earlyExit.setTarget(exit);
        notFound.setTarget(exit);
        removeTeamMethod.setMaxStack();
        removeTeamMethod.setMaxLocals();
        removeTeamMethod.removeNOPs();
        return removeTeamMethod;
    }

    private void addImplicitSubclassNotificationInfrastructure(ClassEnhancer ce, ClassGen cg) {
        ConstantPoolGen cpg = cg.getConstantPool();
        this.factory = new InstructionFactory(cpg);
        String class_name = cg.getClassName();
        ObjectType linkedListType = new ObjectType("java.util.LinkedList");
        int accessFlags = 12;
        FieldGen teamRegistrationObserversField = new FieldGen(accessFlags, (Type)linkedListType, "_OT$teamRegistrationObservers", cpg);
        ce.addField(teamRegistrationObserversField.getField(), cg);
        InstructionList il = new InstructionList();
        MethodGen observerRegistrationMethod = new MethodGen(9, (Type)Type.VOID, new Type[]{classType}, new String[]{"implicitSubClass"}, "_OT$registerObserver", class_name, il, cpg);
        il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$teamRegistrationObservers", (Type)linkedListType, (short)178));
        il.append((Instruction)InstructionFactory.createLoad((Type)classType, (int)0));
        il.append((Instruction)this.factory.createInvoke("java.util.LinkedList", "add", (Type)Type.BOOLEAN, new Type[]{Type.OBJECT}, (short)182));
        il.append((Instruction)new POP());
        il.append((Instruction)new RETURN());
        observerRegistrationMethod.setMaxStack(2);
        observerRegistrationMethod.setMaxLocals();
        ce.addMethod(observerRegistrationMethod.getMethod(), cg);
        il = new InstructionList();
        MethodGen activateNotifyMethod = new MethodGen(9, (Type)Type.VOID, new Type[]{teamType, Type.INT}, new String[]{"team", "teamID"}, "_OT$activateNotify", class_name, il, cpg);
        this.createNotifyMethodImplementation(activateNotifyMethod, cpg, class_name);
        ce.addMethod(activateNotifyMethod.getMethod(), cg);
        il = new InstructionList();
        MethodGen deactivateNotifyMethod = new MethodGen(9, (Type)Type.VOID, new Type[]{teamType}, new String[]{"team"}, "_OT$deactivateNotify", class_name, il, cpg);
        this.createNotifyMethodImplementation(deactivateNotifyMethod, cpg, class_name);
        ce.addMethod(deactivateNotifyMethod.getMethod(), cg);
    }

    private void createNotifyMethodImplementation(MethodGen notifyMethod, ConstantPoolGen cpg, String class_name) {
        boolean isActivateMethod = notifyMethod.getName().equals("_OT$activateNotify");
        int iteratorIdx = isActivateMethod ? 2 : 1;
        int curClassIdx = isActivateMethod ? 3 : 2;
        int anotherIdx1 = isActivateMethod ? 4 : 3;
        int anotherIdx2 = isActivateMethod ? 5 : 4;
        String methodToInvoke = isActivateMethod ? "_OT$addTeam" : "_OT$removeTeam";
        InstructionList il = notifyMethod.getInstructionList();
        il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$teamRegistrationObservers", (Type)new ObjectType("java.util.LinkedList"), (short)178));
        BranchInstruction ifnonnull_3 = InstructionFactory.createBranchInstruction((short)199, null);
        il.append(ifnonnull_3);
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        InstructionHandle ih_7 = il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$teamRegistrationObservers", (Type)new ObjectType("java.util.LinkedList"), (short)178));
        il.append((Instruction)this.factory.createInvoke("java.util.LinkedList", "iterator", (Type)new ObjectType("java.util.Iterator"), Type.NO_ARGS, (short)182));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)iteratorIdx));
        InstructionHandle ih_14 = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)iteratorIdx));
        il.append((Instruction)this.factory.createInvoke("java.util.Iterator", "hasNext", (Type)Type.BOOLEAN, Type.NO_ARGS, (short)185));
        BranchInstruction ifeq_20 = InstructionFactory.createBranchInstruction((short)153, null);
        il.append(ifeq_20);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)iteratorIdx));
        il.append((Instruction)this.factory.createInvoke("java.util.Iterator", "next", (Type)Type.OBJECT, Type.NO_ARGS, (short)185));
        il.append((Instruction)this.factory.createCheckCast((ReferenceType)classType));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)curClassIdx));
        il.append(InstructionConstants.ACONST_NULL);
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)anotherIdx1));
        InstructionHandle ih_36 = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)curClassIdx));
        il.append((CompoundInstruction)new PUSH(cpg, methodToInvoke));
        il.append((CompoundInstruction)new PUSH(cpg, iteratorIdx));
        il.append(this.factory.createNewArray((Type)classType, (short)1));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((CompoundInstruction)new PUSH(cpg, 0));
        il.append((CompoundInstruction)new PUSH(cpg, "org.objectteams.ITeam"));
        il.append((Instruction)this.factory.createInvoke("java.lang.Class", "forName", (Type)classType, new Type[]{Type.STRING}, (short)184));
        il.append((Instruction)InstructionConstants.AASTORE);
        if (isActivateMethod) {
            il.append((Instruction)InstructionConstants.DUP);
            il.append((CompoundInstruction)new PUSH(cpg, 1));
            il.append((Instruction)this.factory.createFieldAccess("java.lang.Integer", "TYPE", (Type)classType, (short)178));
            il.append((Instruction)InstructionConstants.AASTORE);
        }
        il.append((Instruction)this.factory.createInvoke("java.lang.Class", "getMethod", (Type)new ObjectType("java.lang.reflect.Method"), new Type[]{Type.STRING, new ArrayType((Type)classType, 1)}, (short)182));
        InstructionHandle ih_76 = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)anotherIdx1));
        BranchInstruction goto_78 = InstructionFactory.createBranchInstruction((short)167, null);
        il.append(goto_78);
        InstructionHandle ih_81 = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)anotherIdx2));
        il.append((Instruction)this.factory.createFieldAccess("java.lang.System", "err", (Type)new ObjectType("java.io.PrintStream"), (short)178));
        il.append((CompoundInstruction)new PUSH(cpg, "activateNotifyMethod not found!"));
        il.append((Instruction)this.factory.createInvoke("java.io.PrintStream", "println", (Type)Type.VOID, new Type[]{Type.STRING}, (short)182));
        InstructionHandle ih_91 = il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)anotherIdx1));
        BranchInstruction ifnull_93 = InstructionFactory.createBranchInstruction((short)198, null);
        il.append(ifnull_93);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)anotherIdx1));
        il.append(InstructionConstants.ACONST_NULL);
        il.append((CompoundInstruction)new PUSH(cpg, iteratorIdx));
        il.append(this.factory.createNewArray((Type)Type.OBJECT, (short)1));
        il.append((Instruction)InstructionConstants.DUP);
        il.append((CompoundInstruction)new PUSH(cpg, 0));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)InstructionConstants.AASTORE);
        if (isActivateMethod) {
            il.append((Instruction)InstructionConstants.DUP);
            il.append((CompoundInstruction)new PUSH(cpg, 1));
            il.append((Instruction)this.factory.createNew("java.lang.Integer"));
            il.append((Instruction)InstructionConstants.DUP);
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)1));
            il.append((Instruction)this.factory.createInvoke("java.lang.Integer", "<init>", (Type)Type.VOID, new Type[]{Type.INT}, (short)183));
            il.append((Instruction)InstructionConstants.AASTORE);
        }
        il.append((Instruction)this.factory.createInvoke("java.lang.reflect.Method", "invoke", (Type)Type.OBJECT, new Type[]{Type.OBJECT, new ArrayType((Type)Type.OBJECT, 1)}, (short)182));
        InstructionHandle ih_121 = il.append((Instruction)InstructionConstants.POP);
        BranchInstruction goto_122 = InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)ih_14);
        BranchHandle ih_122 = il.append(goto_122);
        InstructionHandle ih_125 = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)anotherIdx2));
        il.append((Instruction)this.factory.createFieldAccess("java.lang.System", "err", (Type)new ObjectType("java.io.PrintStream"), (short)178));
        il.append((CompoundInstruction)new PUSH(cpg, "Can not call activateNotifyMethod!"));
        il.append((Instruction)this.factory.createInvoke("java.io.PrintStream", "println", (Type)Type.VOID, new Type[]{Type.STRING}, (short)182));
        BranchInstruction goto_135 = InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)ih_14);
        il.append(goto_135);
        InstructionHandle ih_138 = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)anotherIdx2));
        il.append((Instruction)this.factory.createFieldAccess("java.lang.System", "err", (Type)new ObjectType("java.io.PrintStream"), (short)178));
        il.append((CompoundInstruction)new PUSH(cpg, "InvocationTargetException"));
        il.append((Instruction)this.factory.createInvoke("java.io.PrintStream", "println", (Type)Type.VOID, new Type[]{Type.STRING}, (short)182));
        BranchInstruction goto_148 = InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)ih_14);
        il.append(goto_148);
        InstructionHandle ih_151 = il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        ifnonnull_3.setTarget(ih_7);
        ifeq_20.setTarget(ih_151);
        goto_78.setTarget(ih_91);
        ifnull_93.setTarget((InstructionHandle)ih_122);
        notifyMethod.addExceptionHandler(ih_36, ih_76, ih_81, new ObjectType("java.lang.NoSuchMethodException"));
        notifyMethod.addExceptionHandler(ih_91, ih_121, ih_125, new ObjectType("java.lang.IllegalAccessException"));
        notifyMethod.addExceptionHandler(ih_91, ih_121, ih_138, new ObjectType("java.lang.reflect.InvocationTargetException"));
        notifyMethod.setMaxStack();
        notifyMethod.setMaxLocals();
    }

    private void addStaticInitializations(ClassGen cg, ConstantPoolGen cpg) {
        Method clinitMethod = cg.containsMethod("<clinit>", "()V");
        MethodGen mg = StaticSliceBaseTransformation.newMethodGen(clinitMethod, cg.getClassName(), cpg);
        InstructionList il = mg.getInstructionList();
        il.insert(this.inizializeStaticFields(cg.getClassName()));
        mg.setMaxStack();
        mg.setMaxLocals();
        Method newClinit = mg.getMethod();
        cg.replaceMethod(clinitMethod, newClinit);
        il.dispose();
    }

    private InstructionList inizializeStaticFields(String class_name) {
        InstructionList il = new InstructionList();
        il.append((Instruction)new ICONST(0));
        il.append(this.factory.createNewArray((Type)teamType, (short)1));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAMS, (Type)teamArray, (short)179));
        il.append((Instruction)new ICONST(0));
        il.append(this.factory.createNewArray((Type)Type.INT, (short)1));
        il.append((Instruction)this.factory.createFieldAccess(class_name, _OT_ACTIVE_TEAM_IDS, (Type)intArray, (short)179));
        if (CallinBindingManager.isRole(class_name)) {
            ObjectType linkedListType = new ObjectType("java.util.LinkedList");
            il.append((Instruction)this.factory.createNew(linkedListType));
            il.append((Instruction)new DUP());
            il.append((Instruction)this.factory.createInvoke("java.util.LinkedList", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
            il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$teamRegistrationObservers", (Type)linkedListType, (short)179));
        }
        return il;
    }
}

