/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.ClassEnhancer;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.jplis.JPLISEnhancer;
import org.eclipse.objectteams.otre.util.CallinBindingManager;
import org.eclipse.objectteams.otre.util.MethodBinding;
import org.eclipse.objectteams.otre.util.SuperMethodDescriptor;
import org.objectteams.OTREInternalError;

public class BaseCallRedirection
extends ObjectTeamsTransformation {
    public BaseCallRedirection(Object loader) {
        super(loader);
    }

    public void doTransformInterface(ClassEnhancer ce, ClassGen cg) {
        this.factory = new InstructionFactory(cg);
        String class_name = cg.getClassName();
        ConstantPoolGen cpg = cg.getConstantPool();
        this.checkReadClassAttributes(ce, cg, class_name, cpg);
        if (!CallinBindingManager.isRole(class_name)) {
            return;
        }
        if (!cg.isInterface()) {
            Set<String> boundBaseMethods = CallinBindingManager.getBoundRoleMethods(class_name);
            this.addBaseCallSurrogatesForReplaceBindings(ce, boundBaseMethods, cg);
        }
        Method[] methods = cg.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            String method_name = m.getName();
            String method_signature = m.getSignature();
            if (BaseCallRedirection.candidateForImplicitActivation(m, cg, cpg)) {
                cg.replaceMethod(m, this.genImplicitActivation(m, class_name, cpg, true));
                JPLISEnhancer.requireClassFileVersionLessThan51(cg);
            }
            if (BaseCallRedirection.isCallin(m, cg)) {
                boolean roleMethodIsBound;
                String enhancedPrefix;
                if (logging) {
                    BaseCallRedirection.printLogMessage(String.valueOf(method_name) + " in " + class_name + " IS A CALLIN-METHOD!");
                }
                if (method_name.startsWith("_OT$")) {
                    method_name = BaseCallRedirection.revertToOriginalName(method_name);
                    if (logging) {
                        BaseCallRedirection.printLogMessage("Reverted tsuper name to " + method_name);
                    }
                }
                if (logging) {
                    BaseCallRedirection.printLogMessage("----->will add another method " + method_name + " with enhanced signature");
                }
                if (method_signature.startsWith(enhancedPrefix = "([Lorg/objectteams/Team;[IIII[Ljava/lang/Object;")) {
                    method_signature = "(" + method_signature.substring(enhancedPrefix.length());
                }
                if (!(roleMethodIsBound = CallinBindingManager.roleMethodHasBinding(class_name, method_name, method_signature)) && logging) {
                    BaseCallRedirection.printLogMessage("callin method " + method_name + method_signature + " was not bound in this class!!!");
                }
                MethodGen baseCallSurrogate = null;
                if (!IS_COMPILER_13X_PLUS) {
                    if (!(roleMethodIsBound || BaseCallRedirection.methodHasCallinFlags(m, cg, 1) || m.isStatic())) {
                        baseCallSurrogate = this.generateEmptyBaseCallSurrogate(cg, m);
                    }
                    if (baseCallSurrogate != null) {
                        ce.addMethod(baseCallSurrogate.getMethod(), cg);
                    }
                }
            }
            ++i;
        }
    }

    private MethodGen generateEmptyBaseCallSurrogate(ClassGen cg, Method m) {
        if (m.getName().startsWith("_OT$")) {
            return null;
        }
        ConstantPoolGen cpg = cg.getConstantPool();
        String class_name = cg.getClassName();
        MethodGen mg = BaseCallRedirection.newMethodGen(m, class_name, cpg);
        if (BaseCallRedirection.isTSuperWrapper(mg)) {
            return null;
        }
        Type[] enhancedArgumentTypes = mg.getArgumentTypes();
        if (IS_COMPILER_GREATER_123) {
            int len = enhancedArgumentTypes.length;
            Type[] newArgumentTypes = new Type[len + 1];
            System.arraycopy(enhancedArgumentTypes, 0, newArgumentTypes, 0, 6);
            newArgumentTypes[6] = Type.BOOLEAN;
            System.arraycopy(enhancedArgumentTypes, 6, newArgumentTypes, 7, len - 6);
            enhancedArgumentTypes = newArgumentTypes;
        }
        Type enhancedReturnType = mg.getReturnType();
        String[] argumentNames = new String[enhancedArgumentTypes.length];
        int i = 0;
        while (i < argumentNames.length) {
            argumentNames[i] = "arg" + i;
            ++i;
        }
        String[] enhancedArgumentNames = argumentNames;
        InstructionList il = new InstructionList();
        int accessFlags = 4;
        if (cg.isInterface()) {
            accessFlags = 1025;
        }
        MethodGen baseCallSurrogate = new MethodGen(accessFlags, enhancedReturnType, enhancedArgumentTypes, enhancedArgumentNames, BaseCallRedirection.getBaseCallSurrogateName(m.getName(), m.isStatic(), class_name), class_name, il, cpg);
        if (!cg.isInterface()) {
            if (logging) {
                BaseCallRedirection.printLogMessage("Exception has to be thrown!");
            }
            this.createThrowInternalError(cpg, il, new InstructionList((CompoundInstruction)new PUSH(cpg, "Binding-Error: base-call impossible!")));
            il.append(InstructionFactory.createNull((Type)enhancedReturnType));
            il.append((Instruction)InstructionFactory.createReturn((Type)enhancedReturnType));
            if (debugging) {
                baseCallSurrogate.addLineNumber(il.getStart(), 65534);
            }
        }
        il.setPositions();
        baseCallSurrogate.removeNOPs();
        baseCallSurrogate.setMaxStack();
        baseCallSurrogate.setMaxLocals();
        return baseCallSurrogate;
    }

    private static boolean isTSuperWrapper(MethodGen mg) {
        Type[] argTypes = mg.getArgumentTypes();
        if (argTypes.length == 0) {
            return false;
        }
        String lastArgument = argTypes[argTypes.length - 1].toString();
        return lastArgument.contains("__OT__");
    }

    private void addBaseCallSurrogatesForReplaceBindings(ClassEnhancer ce, Set<String> boundRoleMethods, ClassGen cg) {
        for (String nameAndSignature : boundRoleMethods) {
            int dotIndex = nameAndSignature.indexOf(46);
            String methodName = nameAndSignature.substring(0, dotIndex);
            String methodSignature = nameAndSignature.substring(dotIndex + 1);
            List<MethodBinding> mbs = CallinBindingManager.getBindingsForRoleMethod(cg.getClassName(), methodName, methodSignature);
            MethodBinding anyMethodBinding = mbs.get(0);
            if (!anyMethodBinding.isReplace()) continue;
            mbs.addAll(CallinBindingManager.getInheritedRoleMethodBindings(cg.getClassName(), methodName, methodSignature));
            if (anyMethodBinding.hasStaticRoleMethod()) continue;
            MethodGen baseCallSurrogate = this.genBaseCallSurrogate(cg, mbs);
            ce.addOrReplaceMethod(baseCallSurrogate.getMethod(), cg);
        }
    }

    MethodGen genBaseCallSurrogate(ClassGen cg, List<MethodBinding> mbs) {
        List<SuperMethodDescriptor> superAccesses;
        ConstantPoolGen cpg = cg.getConstantPool();
        String class_name = cg.getClassName();
        MethodBinding anyBindingForRoleMethod = mbs.get(0);
        String baseClassName = anyBindingForRoleMethod.getRootBoundBase();
        String roleMethodSignature = anyBindingForRoleMethod.getRoleMethodSignature();
        Type[] argTypesTail = Type.getArgumentTypes((String)roleMethodSignature);
        if (IS_COMPILER_GREATER_123) {
            int len = argTypesTail.length;
            Type[] typeArray = argTypesTail;
            argTypesTail = new Type[len + 1];
            System.arraycopy(typeArray, 0, argTypesTail, 1, len);
            argTypesTail[0] = Type.BOOLEAN;
        }
        Type[] enhancedArgumentTypes = BaseCallRedirection.enhanceArgumentTypes(argTypesTail);
        Type enhancedReturnType = BaseCallRedirection.generalizeReturnType(Type.getReturnType((String)roleMethodSignature));
        String methodName = anyBindingForRoleMethod.getRoleMethodName();
        InstructionList il = new InstructionList();
        int accessFlags = 4;
        MethodGen baseCallSurrogate = new MethodGen(accessFlags, enhancedReturnType, enhancedArgumentTypes, null, BaseCallRedirection.getBaseCallSurrogateName(methodName, false, BaseCallRedirection.genRoleInterfaceName(class_name)), class_name, il, cpg);
        ObjectType baseClass = new ObjectType(baseClassName);
        String outerClassName = BaseCallRedirection.getOuterClassName(class_name);
        ObjectType outerClass = new ObjectType(outerClassName);
        LocalVariableGen otResult = null;
        otResult = baseCallSurrogate.addLocalVariable("_OT$result", enhancedReturnType, null, null);
        il.insert((Instruction)InstructionFactory.createStore((Type)enhancedReturnType, (int)otResult.getIndex()));
        il.insert((Instruction)new ACONST_NULL());
        il.setPositions();
        if (logging) {
            BaseCallRedirection.printLogMessage("base-call switch has to be inserted!");
        }
        InstructionList loading = new InstructionList();
        loading.append(InstructionFactory.createThis());
        int index = 1;
        int i = 0;
        while (i < enhancedArgumentTypes.length) {
            loading.append((Instruction)InstructionFactory.createLoad((Type)enhancedArgumentTypes[i], (int)index));
            index += enhancedArgumentTypes[i].getSize();
            ++i;
        }
        Type[] argumentTypes = Type.getArgumentTypes((String)roleMethodSignature);
        Type returnType = Type.getReturnType((String)roleMethodSignature);
        if (debugging) {
            baseCallSurrogate.addLineNumber(il.getStart(), 65534);
        }
        boolean generateSuperAccess = false;
        List<SuperMethodDescriptor> list = superAccesses = IS_COMPILER_GREATER_123 ? CallinBindingManager.getSuperAccesses(baseClassName) : null;
        if (superAccesses != null) {
            block1: for (SuperMethodDescriptor superMethod : superAccesses) {
                for (MethodBinding methodBinding : mbs) {
                    if (!superMethod.methodName.equals(methodBinding.getBaseMethodName()) || !superMethod.signature.equals(methodBinding.getBaseMethodSignature())) continue;
                    generateSuperAccess = true;
                    break block1;
                }
            }
        }
        IFEQ ifSuper = new IFEQ(null);
        GOTO skipElse = new GOTO(null);
        if (generateSuperAccess) {
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.BOOLEAN, (int)7));
            il.append((BranchInstruction)ifSuper);
            il.append(this.genBaseCallSwitch(cpg, mbs, baseCallSurrogate, argumentTypes, outerClass, baseClass, returnType, otResult, loading, true));
            il.append((BranchInstruction)skipElse);
        }
        InstructionList basecall = this.genBaseCallSwitch(cpg, mbs, baseCallSurrogate, argumentTypes, outerClass, baseClass, returnType, otResult, loading, false);
        InstructionHandle callStart = basecall.getStart();
        il.append(basecall);
        if (generateSuperAccess) {
            ifSuper.setTarget(callStart);
            skipElse.setTarget(il.append((Instruction)new NOP()));
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)enhancedReturnType, (int)otResult.getIndex()));
        il.append((Instruction)InstructionFactory.createReturn((Type)enhancedReturnType));
        il.setPositions();
        baseCallSurrogate.removeNOPs();
        baseCallSurrogate.setMaxStack();
        baseCallSurrogate.setMaxLocals();
        return baseCallSurrogate;
    }

    MethodGen replaceBaseCalls(ClassGen cg, Method m, List<MethodBinding> mbs) {
        String[] argumentNames;
        int indexOffset = m.isStatic() ? -1 : 0;
        ConstantPoolGen cpg = cg.getConstantPool();
        String class_name = cg.getClassName();
        String method_name = m.getName();
        MethodGen mg = BaseCallRedirection.newMethodGen(m, class_name, cpg);
        Type[] argumentTypes = mg.getArgumentTypes();
        Type returnType = mg.getReturnType();
        Type[] enhancedArgumentTypes = BaseCallRedirection.enhanceArgumentTypes(mg.getArgumentTypes());
        if (m.isAbstract()) {
            argumentNames = new String[argumentTypes.length];
            int index = 0;
            int i = 0;
            while (i < argumentNames.length) {
                argumentNames[i] = "arg" + index;
                index += argumentTypes[i].getSize();
                ++i;
            }
        } else {
            argumentNames = mg.getArgumentNames();
        }
        String[] enhancedArgumentNames = BaseCallRedirection.enhanceArgumentNames(argumentNames);
        Type enhancedMethodReturnType = BaseCallRedirection.generalizeReturnType(m.getSignature());
        InstructionList il = mg.getInstructionList();
        il = il != null ? il.copy() : new InstructionList();
        MethodGen enhancedMethod = new MethodGen(m.getAccessFlags(), enhancedMethodReturnType, enhancedArgumentTypes, enhancedArgumentNames, method_name, class_name, il, cpg);
        BaseCallRedirection.copyLocalVariables(mg, enhancedMethod);
        BaseCallRedirection.copyLineNumbers(mg, enhancedMethod);
        boolean returnValueAdded = returnType == Type.VOID && enhancedMethodReturnType != Type.VOID;
        CodeExceptionGen[] handlers = BaseCallRedirection.copyExceptionHandlers(mg, enhancedMethod, il);
        ArrayList<IHPair> replacedInstructions = new ArrayList<IHPair>();
        HashSet<InstructionHandle> targetLost = new HashSet<InstructionHandle>();
        LocalVariableGen otResult = null;
        int slot = mg.getMaxLocals() + 6 - indexOffset;
        otResult = enhancedMethod.addLocalVariable("_OT$result", enhancedMethodReturnType, slot, null, null);
        il.insert((Instruction)InstructionFactory.createStore((Type)enhancedMethodReturnType, (int)(otResult.getIndex() - 6)));
        il.insert((Instruction)new ACONST_NULL());
        il.setPositions();
        InstructionHandle[] ihs = il.getInstructionHandles();
        int actInstruction = 0;
        int offset = 6;
        while (actInstruction < ihs.length) {
            Instruction act_instruction = ihs[actInstruction].getInstruction();
            if (act_instruction instanceof LocalVariableInstruction) {
                LocalVariableInstruction localVariableInstruction = (LocalVariableInstruction)act_instruction;
                if (localVariableInstruction.getIndex() != 0 || enhancedMethod.isStatic()) {
                    if (localVariableInstruction instanceof StoreInstruction) {
                        localVariableInstruction = InstructionFactory.createStore((Type)localVariableInstruction.getType(cpg), (int)(offset + localVariableInstruction.getIndex()));
                    } else if (localVariableInstruction instanceof LoadInstruction) {
                        localVariableInstruction = InstructionFactory.createLoad((Type)localVariableInstruction.getType(cpg), (int)(offset + localVariableInstruction.getIndex()));
                    } else if (localVariableInstruction instanceof IINC) {
                        localVariableInstruction.setIndex(offset + localVariableInstruction.getIndex());
                    }
                    ihs[actInstruction].setInstruction((Instruction)localVariableInstruction);
                }
            } else if (act_instruction instanceof RET) {
                RET ret = (RET)act_instruction;
                if (ret.getIndex() != 0) {
                    ihs[actInstruction].setInstruction((Instruction)new RET(offset + ret.getIndex()));
                }
            } else {
                if (BaseCallRedirection.super_or_tsuper_instruction(act_instruction, method_name, cpg)) {
                    InvokeInstruction ii = (InvokeInstruction)act_instruction;
                    InstructionHandle next = ihs[actInstruction + 1];
                    InstructionHandle[] delim = new InstructionHandle[2];
                    int stackDepth = BaseCallRedirection.computeArgumentStackDepth(cpg, ii);
                    InstructionList loading = BaseCallRedirection.pruneLoading(il, ihs, actInstruction, stackDepth, cpg, targetLost, delim, true);
                    if (loading == null) {
                        ++actInstruction;
                        continue;
                    }
                    InstructionList changedArea = this.genEnhancedSuperCall(cpg, ii, enhancedMethod, loading);
                    if (returnValueAdded) {
                        changedArea.append((Instruction)InstructionFactory.createStore((Type)enhancedMethodReturnType, (int)otResult.getIndex()));
                    } else {
                        InstructionHandle ih = this.adjustValue(changedArea, changedArea.getEnd(), enhancedMethodReturnType, returnType);
                        if (debugging && ih != null) {
                            mg.addLineNumber(ih, 65534);
                        }
                    }
                    replacedInstructions.add(new IHPair(delim[0], changedArea.getStart()));
                    replacedInstructions.add(new IHPair(delim[1], changedArea.getEnd()));
                    il.insert(next, changedArea);
                    ++actInstruction;
                    continue;
                }
                if (act_instruction instanceof InvokeInstruction) {
                    InstructionList loading;
                    InvokeInstruction iv = (InvokeInstruction)act_instruction;
                    String iv_name = iv.getName(cpg);
                    if (!iv_name.equals(method_name) && !iv_name.equals("activate")) {
                        ++actInstruction;
                        continue;
                    }
                    InstructionHandle next = ihs[actInstruction + 1];
                    InstructionHandle[] delim = new InstructionHandle[2];
                    int stackDepth = BaseCallRedirection.computeArgumentStackDepth(cpg, iv);
                    boolean deleteThis = true;
                    if (enhancedMethod.isStatic()) {
                        deleteThis = false;
                    }
                    if ((loading = BaseCallRedirection.pruneLoading(il, ihs, actInstruction, stackDepth, cpg, targetLost, delim, deleteThis)) == null) {
                        ++actInstruction;
                        continue;
                    }
                    String roleInterfaceName = BaseCallRedirection.genRoleInterfaceName(cg.getClassName());
                    String calleeClassName = null;
                    if (m.isStatic()) {
                        calleeClassName = BaseCallRedirection.extractTeamName(roleInterfaceName);
                    }
                    InstructionList changedArea = this.genBaseCallSurrogateCall(cpg, iv, enhancedMethod, loading, BaseCallRedirection.extractRoleName(roleInterfaceName), calleeClassName);
                    if (returnValueAdded) {
                        changedArea.append((Instruction)InstructionFactory.createStore((Type)enhancedMethodReturnType, (int)otResult.getIndex()));
                    } else {
                        InstructionHandle ih = this.adjustValue(changedArea, changedArea.getEnd(), enhancedMethodReturnType, returnType);
                        if (debugging && ih != null) {
                            mg.addLineNumber(ih, 65534);
                        }
                    }
                    replacedInstructions.add(new IHPair(delim[0], changedArea.getStart()));
                    replacedInstructions.add(new IHPair(delim[1], changedArea.getEnd()));
                    il.insert(next, changedArea);
                } else if (act_instruction instanceof ReturnInstruction) {
                    InstructionHandle oldReturn;
                    InstructionHandle replacedPos = oldReturn = ihs[actInstruction];
                    il.append(oldReturn, (Instruction)InstructionFactory.createReturn((Type)enhancedMethodReturnType));
                    if (returnValueAdded) {
                        oldReturn.setInstruction((Instruction)InstructionFactory.createLoad((Type)enhancedMethodReturnType, (int)otResult.getIndex()));
                    } else {
                        oldReturn.setInstruction((Instruction)new NOP());
                        replacedPos = this.adjustValue(il, oldReturn, returnType, enhancedMethodReturnType);
                        if (debugging && replacedPos != null) {
                            mg.addLineNumber(replacedPos, 65534);
                        }
                    }
                    if (replacedPos != null) {
                        replacedInstructions.add(new IHPair(oldReturn, replacedPos));
                    }
                }
            }
            ++actInstruction;
        }
        BaseCallRedirection.checkUpdate(handlers, replacedInstructions, targetLost);
        enhancedMethod.removeNOPs();
        il.setPositions();
        enhancedMethod.setMaxStack();
        enhancedMethod.setMaxLocals();
        return enhancedMethod;
    }

    static int computeArgumentStackDepth(ConstantPoolGen cpg, InvokeInstruction ii) {
        Type[] iiargs = ii.getArgumentTypes(cpg);
        int depth = 0;
        int i = 0;
        while (i < iiargs.length) {
            depth += iiargs[i].getSize();
            ++i;
        }
        return depth;
    }

    static void copyLocalVariables(MethodGen src, MethodGen dest) {
        Type[] argumentTypes = src.getArgumentTypes();
        LocalVariableGen[] lvgs = src.getLocalVariables();
        int l = argumentTypes.length;
        while (l < lvgs.length) {
            LocalVariableGen lvg = lvgs[l];
            if (lvg.getIndex() > 0) {
                dest.addLocalVariable(lvg.getName(), lvg.getType(), lvg.getIndex() + 7, null, null);
            }
            ++l;
        }
    }

    static void copyLineNumbers(MethodGen src, MethodGen dest) {
        InstructionList il_dest = dest.getInstructionList();
        il_dest.setPositions();
        LineNumberGen[] src_lng = src.getLineNumbers();
        int i = 0;
        while (i < src_lng.length) {
            int position = src_lng[i].getInstruction().getPosition();
            InstructionHandle ih = il_dest.findHandle(position);
            dest.addLineNumber(ih, src_lng[i].getSourceLine());
            ++i;
        }
    }

    static InstructionList pruneLoading(InstructionList il, InstructionHandle[] ihs, int idx, int stackDepth, ConstantPoolGen cpg, HashSet<InstructionHandle> targetLost, InstructionHandle[] delim, boolean blankThis) {
        InstructionList nlist = new InstructionList();
        InstructionHandle start = ihs[idx];
        InstructionHandle end = ihs[idx--];
        while (stackDepth > 0) {
            start = ihs[idx--];
            Instruction instr = start.getInstruction();
            stackDepth -= BaseCallRedirection.stackDiff(instr, cpg);
            nlist.insert(instr);
        }
        if (blankThis) {
            if (!BaseCallRedirection.isALoad0(ihs[idx].getInstruction())) {
                return null;
            }
            ihs[idx].setInstruction((Instruction)new NOP());
        }
        delim[0] = start;
        delim[1] = end;
        BaseCallRedirection.safeDelete(il, start, end, targetLost);
        return nlist;
    }

    static boolean isALoad0(Instruction i) {
        if (!(i instanceof ALOAD)) {
            return false;
        }
        return ((ALOAD)i).getIndex() == 0;
    }

    InstructionList genBaseCallSwitch(ConstantPoolGen cpg, List<MethodBinding> mbs, MethodGen enhancedMethod, Type[] roleArgumentTypes, ObjectType outerClass, ObjectType baseClass, Type returnType, LocalVariableGen otResult, InstructionList loading, boolean isSuperAccess) {
        String className = enhancedMethod.getClassName();
        Type enhancedMethodReturnType = enhancedMethod.getReturnType();
        boolean callinHasReturnValue = returnType != Type.VOID;
        InstructionList il = new InstructionList();
        int localResult = -1;
        LocalVariableGen lg = null;
        if (callinHasReturnValue) {
            lg = enhancedMethod.addLocalVariable("_OT$tmpResult", returnType, null, null);
            localResult = lg.getIndex();
            il.append(InstructionFactory.createNull((Type)returnType));
            il.append((Instruction)InstructionFactory.createStore((Type)returnType, (int)localResult));
        }
        InstructionHandle switchStart = il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)5));
        BaseCallRedirection.removeDuplicatedBaseMethodTags(mbs);
        int numberOfCases = mbs.size();
        GOTO[] breaks = new GOTO[numberOfCases];
        int i = 0;
        while (i < numberOfCases) {
            breaks[i] = new GOTO(null);
            ++i;
        }
        int[] matches = new int[numberOfCases];
        InstructionHandle[] targets = new InstructionHandle[numberOfCases];
        int caseCounter = 0;
        for (MethodBinding mb : mbs) {
            boolean resultLiftingNecessary;
            Type[] enhancedBaseArgumentTypes;
            ObjectType baseChainReturnType;
            String baseChainMethodName;
            String wrapperName = mb.getWrapperName();
            int[] paramPositions = CallinBindingManager.getParamPositions(outerClass.getClassName(), wrapperName);
            if (logging) {
                BaseCallRedirection.printLogMessage("param pos(" + wrapperName + ")=" + paramPositions);
            }
            matches[caseCounter] = CallinBindingManager.getBaseCallTag(mb.getBaseClassName(), mb.getBaseMethodName(), mb.getBaseMethodSignature());
            InstructionHandle nextBranch = il.append((Instruction)new NOP());
            short invocationKind = isSuperAccess ? (short)184 : 182;
            String boundBaseClassName = mb.getBaseClassName();
            if (boundBaseClassName.indexOf("__OT__") != -1) {
                boundBaseClassName = ObjectTeamsTransformation.genRoleInterfaceName(boundBaseClassName);
                invocationKind = 185;
            }
            String baseMethodName = mb.getBaseMethodName();
            String baseMethodSignature = mb.getBaseMethodSignature();
            Type[] baseMethodArgumentTypes = Type.getArgumentTypes((String)baseMethodSignature);
            Type baseMethodReturnType = Type.getReturnType((String)baseMethodSignature);
            if (isSuperAccess) {
                baseChainMethodName = "_OT$" + baseMethodName + "$super";
                baseChainReturnType = returnType;
                int len = baseMethodArgumentTypes.length;
                enhancedBaseArgumentTypes = new Type[len + 1];
                System.arraycopy(baseMethodArgumentTypes, 0, enhancedBaseArgumentTypes, 1, len);
                enhancedBaseArgumentTypes[0] = baseClass;
            } else {
                baseChainMethodName = BaseCallRedirection.genChainMethName(baseMethodName);
                baseChainReturnType = object;
                enhancedBaseArgumentTypes = BaseCallRedirection.enhanceArgumentTypes(baseMethodArgumentTypes);
            }
            String baseClassName = baseClass.toString();
            if (baseClassName.indexOf("__OT__") != -1) {
                baseClass = new ObjectType(ObjectTeamsTransformation.genRoleInterfaceName(baseClassName));
                if (logging) {
                    BaseCallRedirection.printLogMessage(String.valueOf(baseClassName) + " --> " + ObjectTeamsTransformation.genRoleInterfaceName(baseClassName));
                }
            }
            InstructionHandle baseCallLine = il.append(InstructionFactory.createThis());
            il.append((Instruction)this.factory.createFieldAccess(className, "_OT$base", (Type)baseClass, (short)180));
            if (!baseClass.getClassName().equals(boundBaseClassName)) {
                il.append(this.factory.createCast((Type)baseClass, (Type)new ObjectType(boundBaseClassName)));
            }
            if (!isSuperAccess) {
                int idx = 0;
                while (idx < 6) {
                    il.append((Instruction)InstructionFactory.createLoad((Type)enhancedMethod.getArgumentTypes()[idx], (int)(idx + 1)));
                    ++idx;
                }
            }
            int start = isSuperAccess ? 1 : 6;
            il.append(this.translateLoads(this.splitLoading(cpg, loading.copy(), roleArgumentTypes), enhancedMethod.getArgumentTypes(), enhancedBaseArgumentTypes, paramPositions, BaseCallRedirection.extractTeamName(enhancedMethod.getClassName()), className, new ObjectTeamsTransformation.BaseMethodInfo(mb.baseMethodIsCallin(), false, mb.getTranslationFlags()), start, cpg));
            il.append((Instruction)this.factory.createInvoke(boundBaseClassName, baseChainMethodName, (Type)baseChainReturnType, enhancedBaseArgumentTypes, invocationKind));
            boolean bl = resultLiftingNecessary = (mb.getTranslationFlags() & 1) != 0;
            if (resultLiftingNecessary) {
                String liftMethodName = mb.getLiftMethodName();
                Type liftMethodReturnType = Type.getReturnType((String)mb.getLiftMethodSignature());
                Type[] liftMethodArgs = Type.getArgumentTypes((String)mb.getLiftMethodSignature());
                il.append(this.factory.createCast((Type)baseChainReturnType, baseMethodReturnType));
                ObjectType liftType = (ObjectType)(liftMethodReturnType instanceof ArrayType ? ((ArrayType)liftMethodReturnType).getBasicType() : liftMethodReturnType);
                int liftedDepth = BaseCallRedirection.countOccurrences(liftType.getClassName(), '$');
                int thisNestingDepth = BaseCallRedirection.countOccurrences(className, '$');
                ObjectType liftReceiverType = outerClass;
                if (liftedDepth == thisNestingDepth) {
                    il.append(InstructionFactory.createThis());
                    il.append((Instruction)this.factory.createGetField(className, "this$" + (thisNestingDepth - 1), (Type)outerClass));
                } else if (liftedDepth == thisNestingDepth + 1) {
                    liftReceiverType = new ObjectType(className);
                    il.append((Instruction)new ALOAD(0));
                } else {
                    throw new OTREInternalError("Mismatching nesting levels for lift-call in base-call-surrogate: " + thisNestingDepth + " vs. " + liftedDepth);
                }
                il.append((Instruction)new SWAP());
                il.append((Instruction)this.factory.createInvoke(liftReceiverType.getClassName(), liftMethodName, liftMethodReturnType, liftMethodArgs, (short)182));
            }
            InstructionHandle afterBaseCallLine = il.append((Instruction)new NOP());
            if (baseChainReturnType != Type.VOID) {
                il.append((Instruction)new DUP());
                if (!resultLiftingNecessary) {
                    this.adjustValue(il, null, (Type)baseChainReturnType, enhancedMethodReturnType);
                }
                il.append((Instruction)InstructionFactory.createStore((Type)enhancedMethodReturnType, (int)otResult.getIndex()));
                this.adjustValue(il, null, (Type)baseChainReturnType, returnType);
                if (callinHasReturnValue) {
                    il.append((Instruction)InstructionFactory.createStore((Type)returnType, (int)localResult));
                }
            }
            targets[caseCounter] = nextBranch;
            il.append((BranchInstruction)breaks[caseCounter]);
            ++caseCounter;
            if (!debugging) continue;
            enhancedMethod.addLineNumber(baseCallLine, 65533);
            enhancedMethod.addLineNumber(afterBaseCallLine, 65534);
        }
        InstructionList messagePush = new InstructionList();
        messagePush.append((Instruction)this.factory.createNew("java.lang.StringBuffer"));
        messagePush.append((Instruction)new DUP());
        messagePush.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "<init>", (Type)Type.VOID, new Type[0], (short)183));
        messagePush.append((CompoundInstruction)new PUSH(cpg, "Unhandled base-call case: "));
        messagePush.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "append", (Type)Type.STRINGBUFFER, new Type[]{Type.STRING}, (short)182));
        messagePush.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)5));
        messagePush.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "append", (Type)Type.STRINGBUFFER, new Type[]{Type.INT}, (short)182));
        messagePush.append((Instruction)this.factory.createInvoke("java.lang.StringBuffer", "toString", (Type)Type.STRING, new Type[0], (short)182));
        InstructionHandle defaultCase = this.createThrowInternalError(cpg, il, messagePush);
        InstructionHandle afterSwitch = il.append((Instruction)new NOP());
        il.append(switchStart, BaseCallRedirection.createLookupSwitch(matches, targets, breaks, defaultCase, afterSwitch));
        if (callinHasReturnValue) {
            il.append((Instruction)InstructionFactory.createLoad((Type)returnType, (int)localResult));
            lg.setStart(il.getStart());
            lg.setEnd(il.getEnd());
        }
        return il;
    }

    private static void removeDuplicatedBaseMethodTags(List<MethodBinding> mbs) {
        if (mbs.size() < 2) {
            return;
        }
        MethodBinding[] mbArray = mbs.toArray(new MethodBinding[mbs.size()]);
        Comparator<MethodBinding> baseCallTagComparator = new Comparator<MethodBinding>(){

            @Override
            public int compare(MethodBinding firstMB, MethodBinding secondMB) {
                int secondBaseTag;
                int firstBaseTag = CallinBindingManager.getBaseCallTag(firstMB.getBaseClassName(), firstMB.getBaseMethodName(), firstMB.getBaseMethodSignature());
                if (firstBaseTag < (secondBaseTag = CallinBindingManager.getBaseCallTag(secondMB.getBaseClassName(), secondMB.getBaseMethodName(), secondMB.getBaseMethodSignature()))) {
                    return -1;
                }
                if (firstBaseTag > secondBaseTag) {
                    return 1;
                }
                return 0;
            }
        };
        Arrays.sort(mbArray, baseCallTagComparator);
        int i = 0;
        while (i + 1 < mbArray.length) {
            if (baseCallTagComparator.compare(mbArray[i], mbArray[i + 1]) == 0) {
                mbs.remove(mbArray[i + 1]);
            }
            ++i;
        }
    }

    private static String extractTeamName(String roleClassName) {
        int lastDollarIndex = roleClassName.lastIndexOf(36);
        return roleClassName.substring(0, lastDollarIndex);
    }

    private static String extractRoleName(String roleClassName) {
        int lastDollarIndex = roleClassName.lastIndexOf(36);
        return roleClassName.substring(lastDollarIndex + 1, roleClassName.length());
    }

    static CodeExceptionGen[] copyExceptionHandlers(MethodGen source, MethodGen dest, InstructionList il) {
        il.setPositions();
        CodeExceptionGen[] excGens = source.getExceptionHandlers();
        CodeExceptionGen[] newGens = new CodeExceptionGen[excGens.length];
        if (excGens != null && excGens.length > 0) {
            int hcount = 0;
            while (hcount < excGens.length) {
                CodeExceptionGen excGen = excGens[hcount];
                InstructionHandle excStart = il.findHandle(excGen.getStartPC().getPosition());
                InstructionHandle excEnd = il.findHandle(excGen.getEndPC().getPosition());
                InstructionHandle excHandler = il.findHandle(excGen.getHandlerPC().getPosition());
                ObjectType catchType = excGen.getCatchType();
                newGens[hcount] = dest.addExceptionHandler(excStart, excEnd, excHandler, catchType);
                ++hcount;
            }
        }
        return newGens;
    }

    static void updateHandlers(CodeExceptionGen[] handlers, IHPair replaced) {
        InstructionHandle old = replaced.fst();
        InstructionHandle neu = replaced.snd();
        int i = 0;
        while (i < handlers.length) {
            if (handlers[i].containsTarget(old) && old != neu) {
                handlers[i].updateTarget(old, neu);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    static void safeDelete(InstructionList il, InstructionHandle start, InstructionHandle end, HashSet<InstructionHandle> collect) {
        block3: {
            try {
                il.delete(start, end);
                break block3;
            }
            catch (TargetLostException e) {
                targets = e.getTargets();
                tcount = 0;
                ** while (tcount < targets.length)
            }
lbl-1000:
            // 1 sources

            {
                collect.add(targets[tcount]);
                ++tcount;
                continue;
            }
        }
    }

    static void checkUpdate(CodeExceptionGen[] handlers, ArrayList<IHPair> replacedList, HashSet<InstructionHandle> lost) {
        for (IHPair replaced : replacedList) {
            BaseCallRedirection.updateHandlers(handlers, replaced);
            lost.remove(replaced.fst());
        }
        if (!lost.isEmpty()) {
            System.err.println("Warning: " + lost.size() + " target(s) lost: ");
            Iterator<InstructionHandle> it = lost.iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        }
    }

    InstructionList genEnhancedSuperCall(ConstantPoolGen cpg, InvokeInstruction ii, MethodGen enhancedMethod, InstructionList loading) {
        Type returnType = enhancedMethod.getReturnType();
        Type[] argTypes = BaseCallRedirection.enhanceArgumentTypes(ii.getArgumentTypes(cpg));
        InstructionList il = new InstructionList();
        il.append(InstructionFactory.createThis());
        int index = 1;
        int i = 0;
        while (i < 6) {
            il.append((Instruction)InstructionFactory.createLoad((Type)argTypes[i], (int)index));
            index += argTypes[i].getSize();
            ++i;
        }
        il.append(loading);
        short kind = 0;
        kind = ii instanceof INVOKESPECIAL ? (short)183 : 182;
        il.append((Instruction)this.factory.createInvoke(ii.getClassName(cpg), ii.getMethodName(cpg), returnType, argTypes, kind));
        return il;
    }

    InstructionList genBaseCallSurrogateCall(ConstantPoolGen cpg, InvokeInstruction iv, MethodGen enhancedMethod, InstructionList loading, String roleClassName, String calleeClassName) {
        short invokeKind;
        int indexOffset;
        int n = indexOffset = enhancedMethod.isStatic() ? -1 : 0;
        if (calleeClassName == null) {
            calleeClassName = iv.getClassName(cpg);
        }
        Type returnType = enhancedMethod.getReturnType();
        Type[] argTypes = BaseCallRedirection.enhanceArgumentTypes(iv.getArgumentTypes(cpg));
        InstructionList il = new InstructionList();
        String methodName = BaseCallRedirection.getBaseCallSurrogateName(enhancedMethod.getName(), enhancedMethod.isStatic(), roleClassName);
        if (!enhancedMethod.isStatic()) {
            il.append(InstructionFactory.createThis());
            invokeKind = 182;
        } else {
            invokeKind = 184;
        }
        int index = 1;
        int i = 0;
        while (i < argTypes.length) {
            if (i < 6) {
                il.append((Instruction)InstructionFactory.createLoad((Type)argTypes[i], (int)(index + indexOffset)));
            }
            index += argTypes[i].getSize();
            ++i;
        }
        il.append(loading);
        il.append((Instruction)this.factory.createInvoke(calleeClassName, methodName, returnType, argTypes, invokeKind));
        return il;
    }

    private static boolean super_or_tsuper_instruction(Instruction instr, String method_name, ConstantPoolGen cpg) {
        if (BaseCallRedirection.isTSuperCall(instr, method_name, cpg)) {
            return true;
        }
        return BaseCallRedirection.isSuperCall(instr, method_name, cpg);
    }

    private static boolean isTSuperCall(Instruction instr, String method_name, ConstantPoolGen cpg) {
        if (instr instanceof INVOKEVIRTUAL) {
            INVOKEVIRTUAL iv = (INVOKEVIRTUAL)instr;
            String iv_name = iv.getName(cpg);
            Type[] argTypes = iv.getArgumentTypes(cpg);
            if (argTypes.length < 1) {
                return false;
            }
            String lastArgument = argTypes[argTypes.length - 1].toString();
            if (iv_name.equals(method_name) && lastArgument.indexOf("TSuper__OT__") != -1) {
                if (logging) {
                    BaseCallRedirection.printLogMessage("tsuper-call to " + iv_name + " has to be enhanced!");
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isSuperCall(Instruction instr, String method_name, ConstantPoolGen cpg) {
        INVOKESPECIAL is;
        String is_name;
        if (instr instanceof INVOKESPECIAL && (is_name = (is = (INVOKESPECIAL)instr).getName(cpg)).equals(method_name)) {
            if (logging) {
                BaseCallRedirection.printLogMessage("super-call to " + is_name + " has to be enhanced!");
            }
            return true;
        }
        return false;
    }

    private static String getBaseCallSurrogateName(String method_name, boolean staticFlag, String roleClassName) {
        if (staticFlag) {
            return "_OT$" + roleClassName + "$" + method_name + "$base";
        }
        return "_OT$" + method_name + "$base";
    }

    private static String revertToOriginalName(String method_name) {
        int p = method_name.lastIndexOf(36);
        return method_name.substring(p + 1);
    }

    public void doTransformCode(ClassGen cg) {
    }

    static class IHPair {
        private InstructionHandle _ih1;
        private InstructionHandle _ih2;

        public IHPair(InstructionHandle ih1, InstructionHandle ih2) {
            this._ih1 = ih1;
            this._ih2 = ih2;
        }

        public InstructionHandle fst() {
            return this._ih1;
        }

        public InstructionHandle snd() {
            return this._ih2;
        }
    }
}

