/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl.delta;

import java.text.MessageFormat;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBIndexField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaVisitor;
import org.eclipse.net4j.db.ddl.delta.IDBIndexFieldDelta;
import org.eclipse.net4j.db.ddl.delta.IDBPropertyDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDeltaWithPosition;
import org.eclipse.net4j.internal.db.ddl.delta.DBIndexDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBPropertyDelta;
import org.eclipse.net4j.util.ObjectUtil;

public final class DBIndexFieldDelta
extends DBDeltaWithPosition
implements IDBIndexFieldDelta {
    private static final long serialVersionUID = 1L;

    public DBIndexFieldDelta(DBDelta parent, String name, IDBDelta.ChangeKind changeKind) {
        super(parent, name, changeKind);
    }

    public DBIndexFieldDelta(DBIndexDelta parent, IDBIndexField indexField, IDBIndexField oldIndexField) {
        this((DBDelta)parent, DBIndexFieldDelta.getName(indexField, oldIndexField), DBIndexFieldDelta.getChangeKind(indexField, oldIndexField));
        Integer oldPosition;
        Integer position = indexField == null ? null : Integer.valueOf(indexField.getPosition());
        Integer n = oldPosition = oldIndexField == null ? null : Integer.valueOf(oldIndexField.getPosition());
        if (!ObjectUtil.equals((Object)position, (Object)oldPosition)) {
            this.addPropertyDelta(new DBPropertyDelta<Integer>(this, "position", IDBPropertyDelta.Type.INTEGER, position, oldPosition));
        }
    }

    protected DBIndexFieldDelta() {
    }

    @Override
    public IDBDelta.DeltaType getDeltaType() {
        return IDBDelta.DeltaType.INDEX_FIELD;
    }

    @Override
    public DBIndexDelta getParent() {
        return (DBIndexDelta)super.getParent();
    }

    @Override
    public IDBIndexField getSchemaElement(IDBSchema schema) {
        IDBIndex index = this.getParent().getSchemaElement(schema);
        if (index == null) {
            return null;
        }
        return index.getIndexField(this.getName());
    }

    @Override
    public String toString() {
        return MessageFormat.format("DBIndexFieldDelta[name={0}, kind={1}, propertyDeltas={2}]", new Object[]{this.getName(), this.getChangeKind(), this.getPropertyDeltas().values()});
    }

    @Override
    protected void doAccept(IDBDeltaVisitor visitor) {
        visitor.visit(this);
    }
}

