/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.dnd.DndConfigurationStrategy;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class MarkupEditorOutline
extends ContentOutlinePage
implements IShowInSource,
IShowInTarget {
    private final MarkupEditor editor;
    private boolean disableReveal;
    private DndConfigurationStrategy dndConfigurationStrategy;

    public MarkupEditorOutline(MarkupEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setUseHashlookup(true);
        viewer.setAutoExpandLevel(-1);
        viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        viewer.setInput((Object)this.editor.getOutlineModel());
        viewer.addOpenListener(event -> this.revealInEditor(event.getSelection(), true));
        viewer.addPostSelectionChangedListener(event -> this.revealInEditor(event.getSelection(), false));
        viewer.expandAll();
        new ToolTip(viewer.getControl(), 1, false){

            protected Composite createToolTipContentArea(Event event, Composite parent) {
                Composite comp = new Composite(parent, 0);
                comp.setBackground(parent.getDisplay().getSystemColor(29));
                GridLayout gl = new GridLayout(1, false);
                gl.marginBottom = 2;
                gl.marginTop = 2;
                gl.marginHeight = 0;
                gl.marginWidth = 0;
                gl.marginLeft = 2;
                gl.marginRight = 2;
                gl.verticalSpacing = 1;
                comp.setLayout((Layout)gl);
                Object tipItem = this.getToolTipItem(new Point(event.x, event.y));
                if (tipItem instanceof OutlineItem) {
                    OutlineItem outlineItem = (OutlineItem)tipItem;
                    Label label = new Label(comp, 64);
                    label.setBackground(comp.getBackground());
                    label.setText(outlineItem.getTooltip());
                }
                return comp;
            }

            protected boolean shouldCreateToolTip(Event event) {
                boolean shouldCreate;
                Object eventItem = this.getToolTipItem(new Point(event.x, event.y));
                boolean bl = shouldCreate = eventItem != null && eventItem instanceof OutlineItem && super.shouldCreateToolTip(event);
                if (!shouldCreate) {
                    this.hide();
                }
                return shouldCreate;
            }

            protected Object getToolTipItem(Point point) {
                TreeItem item = ((Tree)MarkupEditorOutline.this.getTreeViewer().getControl()).getItem(point);
                if (item != null) {
                    return item.getData();
                }
                return null;
            }
        };
        IPageSite site = this.getSite();
        site.setSelectionProvider((ISelectionProvider)viewer);
        this.configureActionBars(site);
        MenuManager manager = new MenuManager("#PopUp");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(menuManager -> this.contextMenuAboutToShow(menuManager));
        viewer.getTree().setMenu(manager.createContextMenu((Control)viewer.getTree()));
        site.registerContextMenu("org.eclipse.mylyn.wikitext.ui.editor.markupEditor.outlineContextMenu", manager, (ISelectionProvider)viewer);
        this.configureDnd();
        this.configureActions();
    }

    private void configureActionBars(IPageSite site) {
        IActionBars actionBars = site.getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        CollapseAllAction collapseAllAction = new CollapseAllAction(this.getTreeViewer());
        toolBarManager.add((IAction)collapseAllAction);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new ActionHandler((IAction)collapseAllAction));
        actionBars.updateActionBars();
    }

    public void dispose() {
        if (this.dndConfigurationStrategy != null) {
            this.dndConfigurationStrategy.dispose();
            this.dndConfigurationStrategy = null;
        }
        super.dispose();
    }

    private void configureDnd() {
        this.dndConfigurationStrategy = new DndConfigurationStrategy();
        this.dndConfigurationStrategy.configure(this.editor, this.getControl(), (ISelectionProvider)this.getTreeViewer());
    }

    private void configureActions() {
        this.registerAction(ITextEditorActionConstants.UNDO);
        this.registerAction(ITextEditorActionConstants.REDO);
        this.registerAction(ITextEditorActionConstants.REVERT);
        this.registerAction(ITextEditorActionConstants.SAVE);
        this.registerAction(ITextEditorActionConstants.FIND);
        this.registerAction(ITextEditorActionConstants.PRINT);
    }

    private void registerAction(String actionId) {
        IAction action = this.editor.getAction(actionId);
        if (action != null) {
            this.getSite().getActionBars().setGlobalActionHandler(actionId, action);
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("group.undo"));
        menuManager.add((IContributionItem)new GroupMarker("group.save"));
        menuManager.add((IContributionItem)new Separator("group.copy"));
        menuManager.add((IContributionItem)new Separator("group.print"));
        menuManager.add((IContributionItem)new Separator("group.edit"));
        menuManager.add((IContributionItem)new Separator("group.find"));
        menuManager.add((IContributionItem)new Separator("group.add"));
        menuManager.add((IContributionItem)new Separator("group.showIn"));
        menuManager.add((IContributionItem)new Separator("group.reorganize"));
        menuManager.add((IContributionItem)new Separator("group.rest"));
        menuManager.add((IContributionItem)new Separator("additions"));
        this.addAction(menuManager, "group.undo", ITextEditorActionConstants.UNDO);
        this.addAction(menuManager, "group.undo", ITextEditorActionConstants.REDO);
        this.addAction(menuManager, "group.undo", ITextEditorActionConstants.REVERT);
        this.addAction(menuManager, "group.save", ITextEditorActionConstants.SAVE);
        this.addAction(menuManager, "group.find", ITextEditorActionConstants.FIND);
        this.addAction(menuManager, "group.print", ITextEditorActionConstants.PRINT);
    }

    protected final void addAction(IMenuManager menu, String group, String actionId) {
        IAction action = this.editor.getAction(actionId);
        if (action != null) {
            IMenuManager subMenu;
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if ((subMenu = menu.findMenuUsingPath(group)) != null) {
                subMenu.add(action);
            } else {
                menu.appendToGroup(group, action);
            }
        }
    }

    protected TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    private void revealInEditor(ISelection selection, boolean open) {
        IStructuredSelection structuredSelection;
        Object firstElement;
        if (this.disableReveal) {
            return;
        }
        if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof OutlineItem) {
            OutlineItem item = (OutlineItem)firstElement;
            this.editor.selectAndReveal(item);
        }
    }

    public void refresh() {
        this.getTreeViewer().getTree().setRedraw(false);
        try {
            this.getTreeViewer().refresh();
            this.getTreeViewer().expandAll();
        }
        finally {
            this.getTreeViewer().getTree().setRedraw(true);
        }
    }

    public void setSelection(ISelection selection) {
        this.disableReveal = true;
        try {
            super.setSelection(selection);
        }
        finally {
            this.disableReveal = false;
        }
    }

    public ShowInContext getShowInContext() {
        return this.editor.getShowInContext();
    }

    public boolean show(ShowInContext context) {
        return this.editor.show(context);
    }

    private static class CollapseAllAction
    extends Action {
        private final TreeViewer viewer;

        public CollapseAllAction(TreeViewer viewer) {
            super(Messages.MarkupEditor_collapseAllAction_label);
            this.setDescription(Messages.MarkupEditor_collapseAllAction_description);
            this.setToolTipText(Messages.MarkupEditor_collapseAllAction_tooltip);
            this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)WikiTextUiPlugin.getDefault().getPluginId(), (String)"icons/collapseall.gif"));
            this.viewer = viewer;
        }

        public void run() {
            try {
                this.viewer.getControl().setRedraw(false);
                this.viewer.collapseAll();
            }
            finally {
                this.viewer.getControl().setRedraw(true);
            }
        }
    }
}

