/**
 * Copyright (c) 2009, 2019 Mia-Software and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.modisco.infra.facet.validation;

import java.util.List;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.facet.Facet;
import org.eclipse.modisco.infra.facet.FacetSet;
import org.eclipse.modisco.infra.facet.plugin.FacetPlugin;

/**
 * 
 * @deprecated Replaced by EMF Facet
 */
@Deprecated
public class ExtendedClassValidation extends AbstractModelConstraint {

	@Override
	public IStatus validate(final IValidationContext ctx) {
		EObject eObject = ctx.getTarget();
		EMFEventType eType = ctx.getEventType();
		try {
			IStatus result = ctx.createSuccessStatus();
			if (eType == EMFEventType.NULL) {
				Facet facet = (Facet) eObject;
				List<EClass> superTypes = facet.getESuperTypes();
				for (EClass superType : superTypes) {
					boolean found = superType.getEPackage().getNsURI()
							.equals(EcorePackage.eINSTANCE.getNsURI());
					EPackage ePackage = ((FacetSet) facet.getEPackage()).getExtendedPackage();
					if (ePackage.getEClassifiers().contains(superType)) {
						found = true;
					}
					if (found) {
						result = ctx.createSuccessStatus();
					} else {
						result = ctx.createFailureStatus(superType.getName(), facet.getName());
						break;
					}
				}
			} else {
				result = ctx.createSuccessStatus();
			}
			return result;
		} catch (NullPointerException e) {
			String message = "Unexpected null value in " + eObject.eResource().getURI().toString(); //$NON-NLS-1$
			MoDiscoLogger.logWarning(e, message, FacetPlugin.getDefault());
			return ctx.createSuccessStatus();
		}
	}
}
