/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.util.DuplicateEntryException;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.TypeHashMap;
import org.eclipse.m2m.atl.emftvm.util.TypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldContainer {
    protected final Map<String, TypeMap<Object, Field>> fields = new HashMap<String, TypeMap<Object, Field>>();
    protected final Map<String, TypeMap<Object, Field>> staticFields = new HashMap<String, TypeMap<Object, Field>>();
    protected final Set<Field> allFields = new HashSet<Field>();

    public void registerField(Field f) {
        f.clear();
        if (f.isStatic()) {
            FieldContainer.registerFieldIn(f, this.staticFields);
        } else {
            FieldContainer.registerFieldIn(f, this.fields);
        }
        this.allFields.add(f);
    }

    private static void registerFieldIn(Field f, Map<String, TypeMap<Object, Field>> reg) {
        String name = f.getName();
        TypeMap<Object, Field> fieldreg = reg.get(name);
        if (fieldreg == null) {
            fieldreg = new TypeHashMap<Object, Field>();
            reg.put(name, fieldreg);
        }
        EClassifier ectx = f.getEContext();
        assert (ectx != null);
        Object ctx = EMFTVMUtil.getRegistryType(ectx);
        fieldreg.put(ctx, f);
    }

    public Field findField(Object context, String name) throws DuplicateEntryException {
        TypeMap<Object, Field> fieldreg = this.fields.get(name);
        if (fieldreg != null) {
            Object ctxKey;
            Field f = (Field)fieldreg.get(context);
            if (f == null && (ctxKey = fieldreg.findKey(context)) != null) {
                f = (Field)fieldreg.get(ctxKey);
                assert (f != null);
                fieldreg.put(context, f);
            }
            return f;
        }
        return null;
    }

    public boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    public Field findStaticField(Object context, String name) throws DuplicateEntryException {
        TypeMap<Object, Field> fieldreg = this.staticFields.get(name);
        if (fieldreg != null) {
            return (Field)fieldreg.get(context);
        }
        return null;
    }

    public boolean hasStaticField(String name) {
        return this.staticFields.containsKey(name);
    }

    public void clear() {
        for (Field f : this.allFields) {
            f.clear();
        }
    }

    public String toString() {
        return "FieldContainer [fields=" + this.fields + ", staticFields=" + this.staticFields + "]";
    }
}

