/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.CodeBlockInstruction;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.impl.InstructionImpl;

public abstract class CodeBlockInstructionImpl
extends InstructionImpl
implements CodeBlockInstruction {
    protected static final int CB_INDEX_EDEFAULT = -1;
    protected int cbIndex = -1;
    protected CodeBlock codeBlock;

    protected CodeBlockInstructionImpl() {
    }

    protected EClass eStaticClass() {
        return EmftvmPackage.Literals.CODE_BLOCK_INSTRUCTION;
    }

    public CodeBlock getCodeBlock() {
        CodeBlock ob;
        if (this.codeBlock == null && (ob = this.getOwningBlock()) != null && this.cbIndex != -1 && this.cbIndex < ob.getNested().size()) {
            this.codeBlock = (CodeBlock)ob.getNested().get(this.cbIndex);
        }
        if (this.codeBlock != null && this.codeBlock.eIsProxy()) {
            InternalEObject oldCodeBlock = (InternalEObject)this.codeBlock;
            this.codeBlock = (CodeBlock)this.eResolveProxy(oldCodeBlock);
            if (this.codeBlock != oldCodeBlock && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldCodeBlock, (Object)this.codeBlock));
            }
        }
        return this.codeBlock;
    }

    public CodeBlock basicGetCodeBlock() {
        CodeBlock ob;
        if (this.codeBlock == null && (ob = this.getOwningBlock()) != null && this.cbIndex != -1 && this.cbIndex < ob.getNested().size()) {
            this.codeBlock = (CodeBlock)ob.getNested().get(this.cbIndex);
        }
        return this.codeBlock;
    }

    public void setCodeBlock(CodeBlock newCodeBlock) {
        CodeBlock oldCodeBlock = this.codeBlock;
        this.codeBlock = newCodeBlock;
        this.cbIndex = -1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldCodeBlock, (Object)this.codeBlock));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getCbIndex();
            }
            case 7: {
                if (resolve) {
                    return this.getCodeBlock();
                }
                return this.basicGetCodeBlock();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setCbIndex((Integer)newValue);
                return;
            }
            case 7: {
                this.setCodeBlock((CodeBlock)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setCbIndex(-1);
                return;
            }
            case 7: {
                this.setCodeBlock(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public int getCbIndex() {
        if (this.cbIndex == -1) {
            CodeBlock ob = this.getOwningBlock();
            CodeBlock cb = this.getCodeBlock();
            if (ob != null && cb != null) {
                this.cbIndex = ob.getNested().indexOf((Object)cb);
                if (this.cbIndex < 0) {
                    throw new IllegalArgumentException(String.format("Code block argument %s not found with nested code blocks of %s", cb, ob));
                }
            }
        }
        return this.cbIndex;
    }

    public void setCbIndex(int newCbIndex) {
        int oldCbIndex = this.cbIndex;
        this.cbIndex = newCbIndex;
        if (newCbIndex != -1) {
            this.codeBlock = null;
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldCbIndex, this.cbIndex));
        }
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.getCbIndex() != -1;
            }
            case 7: {
                return this.basicGetCodeBlock() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(' ');
        result.append(this.getCbIndex());
        return result.toString();
    }
}

