/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import org.eclipse.compare.contentmergeviewer.TokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;

public class LastSaveComparator {
    private AtlEditor editor;
    private TokenComparator saveComparator;
    private TokenComparator currentComparator;
    private RangeDifference[] ranges;
    private String content = null;

    public LastSaveComparator(AtlEditor editor) {
        this.editor = editor;
    }

    public void markAsSave() {
        this.saveComparator = new TokenComparator(this.getDocument().get());
        this.markAsCurrent();
    }

    private void markAsCurrent() {
        String content = this.getDocument().get();
        if (this.content == null || !this.content.equals(content)) {
            this.content = content;
            this.currentComparator = new TokenComparator(this.getDocument().get());
            this.ranges = RangeDifferencer.findRanges((IRangeComparator)this.currentComparator, (IRangeComparator)this.saveComparator);
        }
    }

    private IDocument getDocument() {
        return this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
    }

    public int[] save2currentPosition(int[] save) {
        this.markAsCurrent();
        if (save[0] > -1) {
            IndexedPos b = this.save2currentPosition(save[0], null);
            IndexedPos e = this.save2currentPosition(save[1], b);
            return new int[]{b.position, e.position};
        }
        return null;
    }

    private IndexedPos save2currentPosition(int saveIndex, IndexedPos first) {
        int begin;
        int i = begin = first != null ? first.rangeIndex : 0;
        while (i < this.ranges.length) {
            RangeDifference range = this.ranges[i];
            int saveStart = this.saveComparator.getTokenStart(range.rightStart());
            int saveEnd = this.saveComparator.getTokenStart(range.rightEnd());
            if (saveIndex >= saveStart && saveIndex < saveEnd) {
                int currentEnd;
                int diff;
                int currentStart = this.currentComparator.getTokenStart(range.leftStart());
                if (currentStart + (diff = saveIndex - saveStart) < (currentEnd = this.currentComparator.getTokenStart(range.leftEnd()))) {
                    return new IndexedPos(i, currentStart + diff);
                }
                return new IndexedPos(i, currentEnd);
            }
            ++i;
        }
        return new IndexedPos(this.ranges.length, -1);
    }

    public int[] current2savePosition(int[] current) {
        this.markAsCurrent();
        if (current[0] > -1) {
            IndexedPos b = this.current2savePosition(current[0], null);
            IndexedPos e = this.current2savePosition(current[1], b);
            return new int[]{b.position, e.position};
        }
        return null;
    }

    private IndexedPos current2savePosition(int currentIndex, IndexedPos first) {
        int begin;
        int i = begin = first != null ? first.rangeIndex : 0;
        while (i < this.ranges.length) {
            RangeDifference range = this.ranges[i];
            int currentStart = this.currentComparator.getTokenStart(range.leftStart());
            int currentEnd = this.currentComparator.getTokenStart(range.leftEnd());
            if (currentIndex >= currentStart && currentIndex < currentEnd) {
                int saveEnd;
                int diff;
                int saveStart = this.saveComparator.getTokenStart(range.rightStart());
                if (saveStart + (diff = currentIndex - currentStart) < (saveEnd = this.saveComparator.getTokenStart(range.rightEnd()))) {
                    return new IndexedPos(i, saveStart + diff);
                }
                return new IndexedPos(i, saveEnd);
            }
            ++i;
        }
        return new IndexedPos(this.ranges.length, -1);
    }

    private static class IndexedPos {
        protected int rangeIndex;
        protected int position;

        protected IndexedPos(int rangeIndex, int position) {
            this.rangeIndex = rangeIndex;
            this.position = position;
        }
    }
}

