/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.markers;

import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.m2e.core.ui.internal.markers.MavenProblemResolution;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    public boolean hasResolutions(IMarker marker) {
        return true;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        return new IMarkerResolution[]{new RefreshResolution(marker)};
    }

    private class RefreshResolution
    extends MavenProblemResolution {
        public RefreshResolution(IMarker marker) {
            super(marker);
        }

        @Override
        public String getDescription() {
            return Messages.MarkerResolutionGenerator_desc;
        }

        public Image getImage() {
            return null;
        }

        public String getLabel() {
            return Messages.MarkerResolutionGenerator_label;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

        @Override
        public void fix(IMarker[] markers, IDocument doc, IProgressMonitor monitor) {
            Set<IProject> projects = this.getProjects(Stream.of(markers));
            new UpdateMavenProjectJob(projects.toArray(new IProject[projects.size()])).schedule();
        }

        @Override
        public boolean canFix(IMarker marker) throws CoreException {
            return "org.eclipse.m2e.core.maven2Problem.configuration".equals(marker.getType());
        }
    }
}

