/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.checks;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.client.core.model.ICheckConfPO;
import org.eclipse.jubula.client.teststyle.ExtensionHelper;
import org.eclipse.jubula.client.teststyle.checks.CheckConfMock;
import org.eclipse.jubula.client.teststyle.checks.Severity;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;
import org.eclipse.jubula.client.teststyle.exceptions.AttributeNotFoundException;
import org.eclipse.jubula.client.teststyle.quickfix.Quickfix;
import org.eclipse.jubula.client.teststyle.quickfix.QuickfixFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCheck
implements Cloneable {
    private String m_name;
    private String m_id;
    private String m_fulltextDescription = "";
    private ICheckConfPO m_conf = new CheckConfMock();
    private Map<String, String> m_attrDescription = new HashMap<String, String>();

    public final Severity getSeverity() {
        return Severity.valueOf(this.m_conf.getSeverity());
    }

    public final String getFulltextDescription() {
        return this.m_fulltextDescription;
    }

    public final void setFulltextDescription(String tmp) {
        this.m_fulltextDescription = tmp;
    }

    public final void setSeverity(Severity severity) {
        this.m_conf.setSeverity(severity.toString());
    }

    public final void addDescriptionForAttribute(String key, String value) {
        this.m_attrDescription.put(key, value);
    }

    public final String getDescriptionForAttribute(String key) {
        return this.m_attrDescription.get(key);
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final String getId() {
        return this.m_id;
    }

    public final void setId(String id) {
        this.m_id = id;
    }

    public final Map<BaseContext, Boolean> getContexts() {
        HashMap<BaseContext, Boolean> tmp = new HashMap<BaseContext, Boolean>();
        for (Map.Entry e : this.m_conf.getContexts().entrySet()) {
            BaseContext context = BaseContext.getFor((String)e.getKey());
            boolean value = true;
            value = new BigDecimal(1).equals(e.getValue()) ? true : (new BigDecimal(0).equals(e.getValue()) ? false : (Boolean)e.getValue());
            tmp.put(context, value);
        }
        return tmp;
    }

    public final void setContexts(Map<BaseContext, Boolean> contexts) {
        HashMap<String, Boolean> tmp = new HashMap<String, Boolean>();
        for (Map.Entry<BaseContext, Boolean> e : contexts.entrySet()) {
            tmp.put(e.getKey().getClass().getSimpleName(), e.getValue());
        }
        this.m_conf.setContexts(tmp);
    }

    public final void setActive(boolean active) {
        this.m_conf.setActive(Boolean.valueOf(active));
    }

    public final void setActive(boolean active, BaseContext context) {
        this.m_conf.getContexts().put(context.getClass().getSimpleName(), active);
    }

    public final boolean isActive() {
        return this.m_conf.isActive();
    }

    public final boolean isActive(BaseContext context) {
        return this.isActive() && this.getContexts().get(context) != false;
    }

    public abstract String getDescription();

    public abstract boolean hasError(Object var1);

    public Quickfix[] getQuickfix(Object obj) {
        return QuickfixFactory.getDefaultQuickfixFor(obj);
    }

    public String getSuffix(Object obj) {
        return "";
    }

    public String getPrefix(Object obj) {
        return "";
    }

    public final List<Object> hasError(List<Object> objs) {
        ArrayList<Object> objsWithError = new ArrayList<Object>();
        for (Object obj : objs) {
            if (!this.hasError(obj)) continue;
            objsWithError.add(obj);
        }
        return objsWithError;
    }

    public final String getAttributeValue(String name) throws AttributeNotFoundException {
        if (!this.m_conf.getAttr().containsKey(name)) {
            throw new AttributeNotFoundException(name);
        }
        return (String)this.m_conf.getAttr().get(name);
    }

    public final String getDefaultAttributeValue(String name) throws AttributeNotFoundException {
        Map attr = ExtensionHelper.getDefaults().get(this.getId()).getAttr();
        if (!attr.containsKey(name)) {
            throw new AttributeNotFoundException(name);
        }
        return (String)attr.get(name);
    }

    public final void setAttributeValue(String name, String value) {
        this.m_conf.getAttr().put(name, value);
    }

    public final Map<String, String> getAttributes() {
        return this.m_conf.getAttr();
    }

    public final void setAttributes(Map<String, String> attributes) {
        this.m_conf.setAttr(attributes);
    }

    public BaseCheck clone() {
        BaseCheck tmp = null;
        try {
            tmp = (BaseCheck)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        tmp.setConf(new CheckConfMock());
        tmp.setAttributes(new HashMap<String, String>(this.getAttributes()));
        tmp.setActive(this.isActive());
        tmp.setContexts(new HashMap<BaseContext, Boolean>(this.getContexts()));
        tmp.setSeverity(this.getSeverity());
        tmp.setFulltextDescription(this.getFulltextDescription());
        return tmp;
    }

    public void setConf(ICheckConfPO conf) {
        this.m_conf = conf;
    }

    public ICheckConfPO getConf() {
        return this.m_conf;
    }

    public Map<String, String> getDescriptions() {
        return this.m_attrDescription;
    }

    protected int getIntegerAttributeValue(String attributeName) {
        try {
            return Integer.parseInt(this.getAttributeValue(attributeName));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(this.getDefaultAttributeValue(attributeName));
        }
    }
}

