/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.functions;

import org.eclipse.jubula.client.core.functions.AbstractFunctionEvaluator;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class SystemPropertyEvaluator
extends AbstractFunctionEvaluator {
    public String evaluate(String[] arguments) throws InvalidDataException {
        this.validateParamCount(arguments, 1);
        try {
            String key = arguments[0];
            String propertyName = System.getProperty(key);
            if (propertyName == null) {
                throw new InvalidDataException("no Property with this name!", MessageIDs.E_WRONG_PARAMETER_VALUE);
            }
            return propertyName;
        }
        catch (SecurityException se) {
            throw new InvalidDataException(se.getLocalizedMessage(), MessageIDs.E_WRONG_PARAMETER_VALUE);
        }
    }
}

