/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.resources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContentChangeListener
implements IResourceChangeListener {
    private List<IResource> changedResources = new ArrayList<IResource>();
    private String projectName;

    public WebContentChangeListener(String projectName) {
        this.projectName = projectName;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta webResourceDelta;
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        IPath webContentPath = J2EEUtils.getWebContentPath((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName));
        if (!webContentPath.hasTrailingSeparator()) {
            webContentPath = webContentPath.addTrailingSeparator();
        }
        if ((webResourceDelta = rootDelta.findMember(webContentPath)) == null) {
            return;
        }
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (delta.getKind() != 1) {
                    return true;
                }
                IResource resource = delta.getResource();
                WebContentChangeListener.this.changedResources.add(resource);
                return true;
            }
        };
        try {
            webResourceDelta.accept(visitor);
        }
        catch (CoreException ce) {
            CXFCorePlugin.log(ce.getStatus());
        }
    }

    public List<IResource> getChangedResources() {
        return this.changedResources;
    }
}

