/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.ui.internal;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.ProfilerPreferences;
import org.eclipse.jst.server.core.internal.ServerProfiler;
import org.eclipse.jst.server.ui.internal.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ProfilePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo comboBox;
    private ArrayList<String> nameList;
    private ArrayList<String> idList;

    public void init(IWorkbench arg0) {
        this.nameList = new ArrayList();
        this.idList = new ArrayList();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label profilersLabel = new Label(composite, 16384);
        profilersLabel.setText(Messages.profilerPrefsTitle);
        this.loadValues();
        if (this.nameList == null || this.nameList.size() == 0) {
            Composite labelComposite = new Composite(composite, 0);
            GridLayout labelLayout = new GridLayout();
            layout.numColumns = 1;
            layout.marginLeft = 10;
            labelComposite.setLayout((Layout)labelLayout);
            Label noRegisteredProfilersLabel = new Label(labelComposite, 16384);
            GridData nrplData = new GridData();
            noRegisteredProfilersLabel.setData((Object)nrplData);
            noRegisteredProfilersLabel.setForeground(new Color((Device)Display.getDefault(), 255, 0, 0));
            noRegisteredProfilersLabel.setText(Messages.profilerPrefsNoneRegistered);
        } else {
            this.comboBox = new Combo(composite, 12);
            GridData comboLayout = new GridData();
            comboLayout.verticalAlignment = 1;
            comboLayout.horizontalAlignment = 4;
            comboLayout.grabExcessHorizontalSpace = true;
            this.comboBox.setLayoutData((Object)comboLayout);
            String[] strList = this.nameList.toArray(new String[0]);
            this.comboBox.setItems(strList);
            int index = this.findIndexOfSelectedProfiler();
            if (index != -1) {
                this.comboBox.select(index);
            } else {
                this.comboBox.select(0);
            }
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private int findIndexOfSelectedProfiler() {
        String preference = ProfilerPreferences.getInstance().getServerProfilerId();
        if (preference == null) {
            return -1;
        }
        int i = 0;
        while (i < this.idList.size()) {
            if (this.idList.get(i).equals(preference)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void loadValues() {
        ServerProfiler[] profilers = JavaServerPlugin.getServerProfilers();
        int i = 0;
        while (i < profilers.length) {
            String name = profilers[i].getName();
            String id = profilers[i].getId();
            if (name != null && id != null) {
                this.nameList.add(name);
                this.idList.add(id);
            }
            ++i;
        }
    }

    public boolean performOk() {
        if (this.comboBox != null) {
            String selectedId = this.idList.get(this.comboBox.getSelectionIndex());
            ProfilerPreferences.getInstance().setServerProfilerId(selectedId);
        }
        return super.performOk();
    }
}

