/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.RelativeHandleLocator;

class CornerRelativeHandleLocator
extends RelativeHandleLocator {
    private double relativeX = 0.0;
    private double relativeY = 0.0;
    private double offsetXMultiplier = 0.0;
    private double offsetYMultiplier = 0.0;

    public CornerRelativeHandleLocator(IFigure reference, int location) {
        super(reference, location);
        switch (location & 5) {
            case 1: {
                this.relativeY = 0.0;
                this.offsetYMultiplier = -1.0;
                break;
            }
            case 4: {
                this.relativeY = 1.0;
                this.offsetYMultiplier = 0.0;
                break;
            }
            default: {
                this.relativeY = 0.5;
            }
        }
        switch (location & 0x18) {
            case 8: {
                this.relativeX = 0.0;
                this.offsetXMultiplier = -1.0;
                break;
            }
            case 16: {
                this.relativeX = 1.0;
                this.offsetXMultiplier = 0.0;
                break;
            }
            default: {
                this.relativeX = 0.5;
            }
        }
    }

    protected void relocateBounds(Rectangle targetBounds, Dimension newTargetSize) {
        targetBounds.x += (int)((double)(targetBounds.width + 2) * this.relativeX + (double)(newTargetSize.width + 1) * this.offsetXMultiplier);
        targetBounds.y += (int)((double)targetBounds.height * this.relativeY + (double)(newTargetSize.height + 1) * this.offsetYMultiplier);
        targetBounds.setSize(newTargetSize);
    }

    protected Rectangle getCurrentTargetBounds(IFigure relocateFigure) {
        IFigure reference = this.getReferenceFigure();
        PrecisionRectangle targetBounds = new PrecisionRectangle(this.getReferenceBox().getResized(-1, -1));
        reference.translateToAbsolute((Translatable)targetBounds);
        relocateFigure.translateToRelative((Translatable)targetBounds);
        return targetBounds;
    }

    protected Dimension getNewTargetSize(IFigure relocateFigure) {
        return relocateFigure.getPreferredSize();
    }

    public void relocate(IFigure target) {
        Rectangle targetBounds = this.getCurrentTargetBounds(target);
        Dimension targetSize = this.getNewTargetSize(target);
        this.relocateBounds(targetBounds, targetSize);
        target.setBounds(targetBounds);
    }
}

