/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class AbsolutePointLocator
implements Locator {
    private static AbsolutePointLocator INSTANCE;
    private static final Point DEFAULT_POINT;
    private Point _referencePoint = DEFAULT_POINT;
    private int _xOffset = 0;
    private int _yOffset = 0;
    private IFigure _intersectFigure;

    static {
        DEFAULT_POINT = new Point(0, 0);
    }

    public static synchronized AbsolutePointLocator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AbsolutePointLocator();
        }
        return INSTANCE;
    }

    public void relocate(IFigure target) {
        Point leftTop = new Point(this._referencePoint.x + this._xOffset, this._referencePoint.y + this._yOffset);
        target.translateToRelative((Translatable)leftTop);
        Dimension d = target.getPreferredSize();
        Rectangle rect = new Rectangle(leftTop, d);
        if (this._intersectFigure != null) {
            rect = rect.intersect(this._intersectFigure.getBounds());
        }
        target.setBounds(rect);
    }

    public void setReferencePoint(Point point, int xoffset, int yoffset) {
        this._referencePoint = point == null ? DEFAULT_POINT : point;
        this._xOffset = xoffset;
        this._yOffset = yoffset;
    }

    public void setIntersectFigure(IFigure intersectFigure) {
        this._intersectFigure = intersectFigure;
    }

    private AbsolutePointLocator() {
    }
}

