/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dnd.internal;

import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jst.jsf.common.ui.internal.dialogs.CommonWizardDialog;
import org.eclipse.jst.pagedesigner.dnd.ILocalDropHandler;
import org.eclipse.jst.pagedesigner.dnd.internal.DropSelectionWizard;
import org.eclipse.jst.pagedesigner.dnd.internal.Messages;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

public class LocalDropCommand
extends Command {
    private Map _feedbackToHandlers;
    private IHTMLGraphicalViewer _viewer;
    private Object _localObject;
    private Node _widget;
    private IDOMPosition _position;

    public LocalDropCommand(IHTMLGraphicalViewer viewer, Object localObject, Map feedbackHandlers) {
        this._viewer = viewer;
        this._localObject = localObject;
        this._feedbackToHandlers = feedbackHandlers;
    }

    public void setWidget(Node widget) {
        this._widget = widget;
    }

    public void setDOMPosition(IDOMPosition position) {
        this._position = position;
    }

    public void execute() {
        if (this._feedbackToHandlers.size() == 1) {
            ILocalDropHandler handler = (ILocalDropHandler)this._feedbackToHandlers.values().toArray()[0];
            if (handler.useWizard(this._localObject, this._viewer)) {
                IWizard wizard = this._widget != null ? handler.getWizard(this._localObject, this._widget, this._viewer) : handler.getWizard(this._localObject, this._position, this._viewer);
                CommonWizardDialog wizardDialog = new CommonWizardDialog(this.getShell(), wizard);
                wizardDialog.setTitle(Messages.getString("LocalDropCommand.DropHandler"));
                wizardDialog.create();
                wizardDialog.open();
            } else if (this._widget != null) {
                handler.doUpdateWidget(this._localObject, this._widget, this._viewer);
            } else {
                handler.doInsertElements(this._localObject, this._position, this._viewer);
            }
        } else {
            CommonWizardDialog wizardDialog = new CommonWizardDialog(this.getShell(), this.getWizard());
            wizardDialog.setTitle(Messages.getString("LocalDropCommand.DropHandler"));
            wizardDialog.setBlockOnOpen(false);
            wizardDialog.create();
            wizardDialog.open();
        }
    }

    private IWizard getWizard() {
        if (this._widget != null) {
            return new DropSelectionWizard(this._viewer, this._localObject, this._feedbackToHandlers, this._widget);
        }
        return new DropSelectionWizard(this._viewer, this._localObject, this._feedbackToHandlers, this._position);
    }

    private Shell getShell() {
        return this._viewer.getControl().getShell();
    }
}

