/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDERegistration;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.ELProxyContributor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.ServletBeanProxyContributor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.FaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.LibraryClassBasedTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.XMLBasedTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglib;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.FaceletLibraryClassTagLib;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.FaceletXMLDefnTaglib;

public class TagRecordFactory {
    private final ProxyFactoryRegistry _registry;
    private final IProject _project;
    private static final NullProxyFactoryRegistry NULL_REGISTRY = new NullProxyFactoryRegistry();

    public TagRecordFactory(IProject project, boolean useJEMProxy) {
        this._project = project;
        NullProxyFactoryRegistry registry = NULL_REGISTRY;
        if (useJEMProxy) {
            try {
                registry = TagRecordFactory.createProxyRegistry(this._project);
            }
            catch (Exception e) {
                FaceletCorePlugin.log("While creatinng proxy", e);
            }
        }
        this._registry = registry;
    }

    public IFaceletTagRecord createRecords(FaceletTaglib taglibDefn, IFaceletTagRecord.TagRecordDescriptor descriptor) {
        FaceletTagRecord retValue = null;
        if (taglibDefn instanceof FaceletLibraryClassTagLib) {
            if (this._registry != NULL_REGISTRY) {
                LibraryClassBasedTagRecord record = new LibraryClassBasedTagRecord(this._registry, (FaceletLibraryClassTagLib)((Object)taglibDefn), this._project, descriptor);
                try {
                    record.initURI();
                    retValue = record;
                }
                catch (CoreException e) {
                    FaceletCorePlugin.log("While creating record: " + record, e);
                }
            }
        } else {
            XMLBasedTagRecord record;
            if (taglibDefn instanceof FaceletXMLDefnTaglib) {
                throw new UnsupportedOperationException();
            }
            retValue = record = new XMLBasedTagRecord(taglibDefn, descriptor);
        }
        return retValue;
    }

    public void dispose() {
        if (this._registry != null && this._registry != NULL_REGISTRY) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    TagRecordFactory.this._registry.terminateRegistry(false);
                }

                public void handleException(Throwable e) {
                    FaceletCorePlugin.log("While creatinng proxy", e);
                }
            });
        }
    }

    private static ProxyFactoryRegistry createProxyRegistry(IProject project) throws CoreException {
        IConfigurationContributor[] contributor = new IConfigurationContributor[]{new ServletBeanProxyContributor(JSFVersion.V1_1), new ELProxyContributor(project)};
        return IDERegistration.startAnImplementation((IConfigurationContributor[])contributor, (boolean)false, (IProject)project, (String)project.getName(), (String)"org.eclipse.jst.jsf.facelet.core", (IProgressMonitor)new NullProgressMonitor());
    }

    private static class NullProxyFactoryRegistry
    extends ProxyFactoryRegistry {
        private NullProxyFactoryRegistry() {
        }

        public ICallbackRegistry getCallbackRegistry() {
            throw new UnsupportedOperationException("This is null proxy");
        }

        protected void registryTerminated(boolean wait) {
            throw new UnsupportedOperationException("This is null proxy");
        }
    }
}

