/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.ui.libprov;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderFrameworkUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.ui.internal.SharedWorkingCopyManager;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

public abstract class LibraryFacetPropertyPage
extends PropertyPage {
    private IProject project;
    private IFacetedProject facetedProject;
    private IFacetedProjectWorkingCopy facetedProjectWorkingCopy;
    private IFacetedProjectListener facetedProjectListener;
    private Composite rootComposite;
    private LibraryInstallDelegate libraryInstallDelegate;

    public abstract IProjectFacetVersion getProjectFacetVersion();

    protected final IProject getProject() {
        return this.project;
    }

    protected final IFacetedProject getFacetedProject() {
        return this.facetedProject;
    }

    protected final LibraryInstallDelegate getLibraryInstallDelegate() {
        return this.libraryInstallDelegate;
    }

    protected LibraryInstallDelegate createLibraryInstallDelegate(IFacetedProject project, IProjectFacetVersion fv) {
        return new LibraryInstallDelegate((IFacetedProjectBase)project, fv);
    }

    public final void createControl(Composite parent) {
        super.createControl(parent);
        Button revertButton = this.getDefaultsButton();
        revertButton.setText(Resources.revertButton);
        GridData gd = new GridData(256);
        Point minButtonSize = revertButton.computeSize(-1, -1, true);
        gd.widthHint = Math.max(this.convertHorizontalDLUsToPixels(61), minButtonSize.x);
        revertButton.setLayoutData((Object)gd);
        this.updateButtons();
        this.getShell().layout(true, true);
    }

    protected final Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        this.project = element instanceof IProject ? (IProject)element : (IProject)Platform.getAdapterManager().loadAdapter((Object)element, IProject.class.getName());
        if (this.project != null) {
            try {
                this.facetedProject = ProjectFacetsManager.create((IProject)this.project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        Dialog.applyDialogFont((Control)parent);
        this.rootComposite = new Composite(parent, 0);
        if (this.facetedProject != null) {
            this.facetedProjectWorkingCopy = SharedWorkingCopyManager.getWorkingCopy((IFacetedProject)this.facetedProject);
            this.facetedProjectListener = new IFacetedProjectListener(){

                public void handleEvent(IFacetedProjectEvent event) {
                    LibraryFacetPropertyPage.this.updateContents();
                }
            };
            this.facetedProject.addListener(this.facetedProjectListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_MODIFIED});
            this.facetedProjectWorkingCopy.addListener(this.facetedProjectListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_MODIFIED});
        }
        this.updateContents();
        return this.rootComposite;
    }

    protected Control createPageContents(Composite parent) {
        return LibraryProviderFrameworkUi.createInstallLibraryPanel(parent, this.libraryInstallDelegate);
    }

    private void updateContents() {
        Control control;
        int n;
        Control[] controlArray;
        if (this.rootComposite.getDisplay().getThread() != Thread.currentThread()) {
            this.rootComposite.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    LibraryFacetPropertyPage.this.updateContents();
                }
            });
            return;
        }
        IProjectFacetVersion fv = this.getProjectFacetVersion();
        String errorMessage = null;
        if (this.facetedProject == null) {
            errorMessage = Resources.invalidContextMessage;
        } else if (fv == null || !this.facetedProject.hasProjectFacet(fv)) {
            errorMessage = Resources.facetNotPresetInProjectMessage;
        } else if (this.facetedProjectWorkingCopy.isDirty()) {
            errorMessage = Resources.dirtyWorkingCopyMessage;
        } else if (this.libraryInstallDelegate == null) {
            controlArray = this.rootComposite.getChildren();
            n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            IPropertyChangeListener delegateListener = new IPropertyChangeListener(){

                public void propertyChanged(String property, Object oldValue, Object newValue) {
                    LibraryFacetPropertyPage.this.updateValidation();
                }
            };
            this.libraryInstallDelegate = this.createLibraryInstallDelegate(this.facetedProject, fv);
            this.libraryInstallDelegate.addListener(delegateListener, new String[0]);
            this.rootComposite.setLayout((Layout)GridLayoutUtil.gl((int)1, (int)0, (int)0));
            Control contents = this.createPageContents(this.rootComposite);
            contents.setLayoutData((Object)GridLayoutUtil.gdhfill());
        }
        if (errorMessage != null) {
            controlArray = this.rootComposite.getChildren();
            n = controlArray.length;
            int n3 = 0;
            while (n3 < n) {
                control = controlArray[n3];
                control.dispose();
                ++n3;
            }
            if (this.libraryInstallDelegate != null) {
                this.libraryInstallDelegate.dispose();
            }
            this.libraryInstallDelegate = null;
            this.rootComposite.setLayout((Layout)GridLayoutUtil.gl((int)1, (int)0, (int)0));
            Text label = new Text(this.rootComposite, 72);
            label.setText(errorMessage);
            label.setLayoutData((Object)GridLayoutUtil.gdhfill());
        }
        this.updateValidation();
        this.updateButtons();
        this.getShell().layout(true, true);
    }

    private void updateButtons() {
        Button revertButton;
        Button applyButton;
        boolean enableApply = this.isValid();
        boolean enableRevert = true;
        if (this.libraryInstallDelegate == null) {
            enableApply = false;
            enableRevert = false;
        }
        if ((applyButton = this.getApplyButton()) != null) {
            applyButton.setEnabled(enableApply);
        }
        if ((revertButton = this.getDefaultsButton()) != null) {
            revertButton.setEnabled(enableRevert);
        }
    }

    protected final void updateValidation() {
        if (this.rootComposite.isDisposed()) {
            return;
        }
        if (this.rootComposite.getDisplay().getThread() != Thread.currentThread()) {
            this.rootComposite.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    LibraryFacetPropertyPage.this.updateValidation();
                }
            });
            return;
        }
        IStatus st = this.performValidation();
        int severity = st.getSeverity();
        if (severity == 4) {
            this.setMessage(st.getMessage(), 3);
            this.setValid(false);
        } else {
            if (severity == 2) {
                this.setMessage(st.getMessage(), 2);
            } else if (severity == 1) {
                this.setMessage(st.getMessage(), 1);
            } else {
                this.setMessage(null);
            }
            this.setValid(true);
        }
    }

    protected IStatus performValidation() {
        if (this.libraryInstallDelegate != null) {
            return this.libraryInstallDelegate.validate();
        }
        return Status.OK_STATUS;
    }

    public boolean performOk() {
        final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                LibraryFacetPropertyPage.this.performOkInternal();
            }
        };
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            throw new RuntimeException(te);
        }
        return true;
    }

    private void performOkInternal() throws CoreException {
        if (this.libraryInstallDelegate != null) {
            this.libraryInstallDelegate.execute(null);
            this.libraryInstallDelegate.reset();
        }
    }

    protected void performApply() {
        this.performOk();
    }

    protected void performDefaults() {
        if (this.libraryInstallDelegate != null) {
            this.libraryInstallDelegate.reset();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.libraryInstallDelegate != null) {
            this.libraryInstallDelegate.dispose();
        }
        if (this.facetedProject != null) {
            this.facetedProject.removeListener(this.facetedProjectListener);
            SharedWorkingCopyManager.releaseWorkingCopy((IFacetedProject)this.facetedProject);
        }
    }

    private static final class Resources
    extends NLS {
        public static String revertButton;
        public static String invalidContextMessage;
        public static String facetNotPresetInProjectMessage;
        public static String dirtyWorkingCopyMessage;

        static {
            Resources.initializeMessages((String)LibraryFacetPropertyPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

