/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportAdder;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.OrderPreservingImportAdder;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.PackageAndContainingTypeImportComparator;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.PackageImportComparator;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ReorderingImportAdder;

public final class ImportRewriteConfiguration {
    final OriginalImportHandling originalImportHandling;
    final ImportContainerSorting typeContainerSorting;
    final ImportContainerSorting staticContainerSorting;
    final ImplicitImportIdentification implicitImportIdentification;
    final List<String> importOrder;
    final int typeOnDemandThreshold;
    final int staticOnDemandThreshold;

    ImportRewriteConfiguration(Builder builder) {
        this.originalImportHandling = builder.originalImportHandling;
        this.typeContainerSorting = builder.typeContainerSorting;
        this.staticContainerSorting = builder.staticContainerSorting;
        this.implicitImportIdentification = builder.implicitImportIdentification;
        this.importOrder = builder.importOrder;
        this.typeOnDemandThreshold = builder.typeOnDemandThreshold;
        this.staticOnDemandThreshold = builder.staticOnDemandThreshold;
    }

    public static class Builder {
        final OriginalImportHandling originalImportHandling;
        ImportContainerSorting typeContainerSorting;
        ImportContainerSorting staticContainerSorting;
        ImplicitImportIdentification implicitImportIdentification;
        List<String> importOrder;
        Integer typeOnDemandThreshold;
        Integer staticOnDemandThreshold;

        public static Builder discardingOriginalImports() {
            return new Builder(OriginalImportHandling.DISCARD);
        }

        public static Builder preservingOriginalImports() {
            return new Builder(OriginalImportHandling.PRESERVE_IN_ORDER);
        }

        private Builder(OriginalImportHandling originalImportHandling) {
            this.originalImportHandling = originalImportHandling;
            this.typeContainerSorting = ImportContainerSorting.BY_PACKAGE;
            this.staticContainerSorting = ImportContainerSorting.BY_PACKAGE_AND_CONTAINING_TYPE;
            this.implicitImportIdentification = ImplicitImportIdentification.JAVA_LANG_AND_CU_PACKAGE;
            this.importOrder = Collections.emptyList();
            this.typeOnDemandThreshold = null;
            this.staticOnDemandThreshold = null;
        }

        public Builder setTypeContainerSorting(ImportContainerSorting typeContainerSorting) {
            this.typeContainerSorting = typeContainerSorting;
            return this;
        }

        public Builder setStaticContainerSorting(ImportContainerSorting staticContainerSorting) {
            this.staticContainerSorting = staticContainerSorting;
            return this;
        }

        public Builder setImplicitImportIdentification(ImplicitImportIdentification implicitImportIdentification) {
            this.implicitImportIdentification = implicitImportIdentification;
            return this;
        }

        public Builder setImportOrder(List<String> importOrder) {
            this.importOrder = Collections.unmodifiableList(new ArrayList<String>(importOrder));
            return this;
        }

        public Builder setTypeOnDemandThreshold(int typeOnDemandThreshold) {
            this.typeOnDemandThreshold = typeOnDemandThreshold;
            return this;
        }

        public Builder setStaticOnDemandThreshold(int staticOnDemandThreshold) {
            this.staticOnDemandThreshold = staticOnDemandThreshold;
            return this;
        }

        public ImportRewriteConfiguration build() {
            return new ImportRewriteConfiguration(this);
        }
    }

    public static enum ImplicitImportIdentification {
        JAVA_LANG_AND_CU_PACKAGE{

            @Override
            Set<String> determineImplicitImportContainers(ICompilationUnit compilationUnit) {
                HashSet<String> implicitImportContainerNames = new HashSet<String>();
                implicitImportContainerNames.add("java.lang");
                IJavaElement packageFragment = compilationUnit.getParent();
                String compilationUnitPackageName = packageFragment.getElementName();
                if (compilationUnitPackageName.isEmpty() && !packageFragment.exists() && compilationUnit.exists()) {
                    try {
                        IPackageDeclaration[] packageDeclarations = compilationUnit.getPackageDeclarations();
                        if (packageDeclarations.length > 0) {
                            implicitImportContainerNames.add(packageDeclarations[0].getElementName());
                            return implicitImportContainerNames;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                implicitImportContainerNames.add(compilationUnitPackageName);
                return implicitImportContainerNames;
            }
        }
        ,
        NONE{

            @Override
            Set<String> determineImplicitImportContainers(ICompilationUnit compilationUnit) {
                return Collections.emptySet();
            }
        };


        abstract Set<String> determineImplicitImportContainers(ICompilationUnit var1);
    }

    public static enum ImportContainerSorting {
        BY_PACKAGE_AND_CONTAINING_TYPE{

            @Override
            Comparator<ImportName> createContainerComparator(JavaProject javaProject) {
                return new PackageAndContainingTypeImportComparator();
            }
        }
        ,
        BY_PACKAGE{

            @Override
            Comparator<ImportName> createContainerComparator(JavaProject javaProject) {
                return new PackageImportComparator(javaProject);
            }
        };


        abstract Comparator<ImportName> createContainerComparator(JavaProject var1);
    }

    public static enum OriginalImportHandling {
        DISCARD{

            @Override
            boolean shouldRemoveOriginalImports() {
                return true;
            }

            @Override
            boolean shouldFixAllLineDelimiters() {
                return true;
            }

            @Override
            ImportAdder createImportAdder(Comparator<ImportName> importComparator) {
                return new ReorderingImportAdder(importComparator);
            }
        }
        ,
        PRESERVE_IN_ORDER{

            @Override
            boolean shouldRemoveOriginalImports() {
                return false;
            }

            @Override
            boolean shouldFixAllLineDelimiters() {
                return false;
            }

            @Override
            ImportAdder createImportAdder(Comparator<ImportName> importComparator) {
                return new OrderPreservingImportAdder(importComparator);
            }
        };


        abstract boolean shouldRemoveOriginalImports();

        abstract boolean shouldFixAllLineDelimiters();

        abstract ImportAdder createImportAdder(Comparator<ImportName> var1);
    }
}

