/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.custom;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;

public abstract class AbstractAsynchronousCustomFeature
extends AbstractCustomFeature {
    public AbstractAsynchronousCustomFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected abstract void execute(ICustomContext var1, IProgressMonitor var2);

    protected void beforeJobExecution() {
    }

    protected void afterJobExecution() {
    }

    protected Job initializeJob(final ICustomContext context) {
        return new Job(this.getName()){

            protected IStatus run(final IProgressMonitor monitor) {
                TransactionalEditingDomain editingDomain = AbstractAsynchronousCustomFeature.this.getDiagramBehavior().getEditingDomain();
                RecordingCommand command = new RecordingCommand(editingDomain, this.getName()){
                    private IStatus result;
                    {
                        super($anonymous0, $anonymous1);
                        this.result = null;
                    }

                    protected void doExecute() {
                        try {
                            AbstractAsynchronousCustomFeature.this.execute(context, monitor);
                            this.result = Status.OK_STATUS;
                        }
                        catch (OperationCanceledException e) {
                            this.result = Status.CANCEL_STATUS;
                        }
                    }

                    public Collection<?> getResult() {
                        return this.result == null ? Collections.EMPTY_LIST : Collections.singletonList(this.result);
                    }
                };
                editingDomain.getCommandStack().execute((Command)command);
                AbstractAsynchronousCustomFeature.this.getDiagramBehavior().getDiagramContainer().updateDirtyState();
                AbstractAsynchronousCustomFeature.this.afterJobExecution();
                return (IStatus)command.getResult().iterator().next();
            }
        };
    }

    protected void configureJob(Job job) {
        job.setUser(true);
        job.setPriority(30);
    }

    @Override
    public final void execute(IContext context) {
        super.execute(context);
    }

    @Override
    public final void execute(ICustomContext context) {
        Job job = this.initializeJob(context);
        this.configureJob(job);
        this.beforeJobExecution();
        job.schedule();
    }

    @Override
    public final boolean hasDoneChanges() {
        return false;
    }
}

