/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.DropShadowBorder;
import org.eclipse.gmf.runtime.draw2d.ui.figures.RectangularDropShadow;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.LineBorderEx;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class RectangularDropShadowLineBorder
extends LineBorderEx
implements DropShadowBorder {
    private boolean drawDropShadow = true;
    private static RectangularDropShadow dropShadow = new RectangularDropShadow();

    public RectangularDropShadowLineBorder(int w) {
        super(w);
    }

    public RectangularDropShadowLineBorder() {
    }

    protected int getShadowWidth() {
        if (this.shouldDrawDropShadow()) {
            return this.getDropShadow().getShadowWidth();
        }
        return 0;
    }

    protected int getShadowHeight() {
        if (this.shouldDrawDropShadow()) {
            return this.getDropShadow().getShadowHeight();
        }
        return 0;
    }

    @Override
    public Insets getInsets(IFigure figure) {
        Insets insetsNew = new Insets(this.getWidth());
        IMapMode mm = MapModeUtil.getMapMode(figure);
        insetsNew.bottom += mm.DPtoLP(this.getShadowHeight());
        insetsNew.right += mm.DPtoLP(this.getShadowWidth());
        return insetsNew;
    }

    protected boolean shouldDrawShadow(IFigure figure) {
        if (!this.shouldDrawDropShadow()) {
            return false;
        }
        Rectangle rBox = figure.getBounds();
        return rBox.width >= this.getShadowWidth() * 2 && rBox.height >= this.getShadowHeight() * 2;
    }

    @Override
    public Insets getTransparentInsets(IFigure figure) {
        Insets insetsNew = new Insets();
        insetsNew.top = 0;
        insetsNew.left = 0;
        insetsNew.bottom = MapModeUtil.getMapMode(figure).DPtoLP(this.getShadowHeight());
        insetsNew.right = MapModeUtil.getMapMode(figure).DPtoLP(this.getShadowWidth());
        return insetsNew;
    }

    public boolean isOpaque() {
        return false;
    }

    public void paintLineBorder(IFigure figure, Graphics g, Insets insets) {
        if (this.getWidth() > 0) {
            tempRect.setBounds(RectangularDropShadowLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
            g.setLineWidth(this.getWidth());
            g.setLineStyle(this.getStyle());
            g.drawRectangle(tempRect);
        }
    }

    public void paintDropShadowBorder(IFigure figure, Graphics g, Insets insets, Rectangle rBox) {
        this.getDropShadow().drawShadow(figure, g, rBox);
        IMapMode mm = MapModeUtil.getMapMode(figure);
        if (this.getWidth() > 0) {
            tempRect.setBounds(RectangularDropShadowLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            RectangularDropShadowLineBorder.tempRect.width -= mm.DPtoLP(this.getShadowWidth());
            RectangularDropShadowLineBorder.tempRect.height -= mm.DPtoLP(this.getShadowHeight());
            tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
            g.setLineWidth(this.getWidth());
            g.setLineStyle(this.getStyle());
            if (this.getColor() != null) {
                g.setForegroundColor(this.getColor());
            } else {
                g.setForegroundColor(figure.getForegroundColor());
            }
            g.drawRectangle(tempRect);
        }
    }

    @Override
    public void paint(IFigure figure, Graphics g, Insets insets) {
        Rectangle rBox = new Rectangle(figure.getBounds());
        if (this.shouldDrawShadow(figure)) {
            this.paintDropShadowBorder(figure, g, insets, rBox);
        } else {
            this.paintLineBorder(figure, g, insets);
        }
    }

    @Override
    public boolean shouldDrawDropShadow() {
        return this.drawDropShadow;
    }

    @Override
    public void setShouldDrawDropShadow(boolean bDrawDropShadow) {
        this.drawDropShadow = bDrawDropShadow;
    }

    protected RectangularDropShadow getDropShadow() {
        return dropShadow;
    }
}

