/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.operations;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class ResolutionResult {
    private static final String NESTING_INDENT = "  ";
    private final HashMap<IInstallableUnit, MultiStatus> iuToStatusMap = new HashMap();
    private MultiStatus summaryStatus;

    public IStatus getSummaryStatus() {
        if (this.summaryStatus != null) {
            return this.summaryStatus;
        }
        return Status.OK_STATUS;
    }

    public void setSummaryStatus(MultiStatus status) {
        this.summaryStatus = status;
    }

    public void addSummaryStatus(IStatus status) {
        if (this.summaryStatus == null) {
            this.summaryStatus = new MultiStatus("org.eclipse.equinox.p2.operations", 0, Messages.ResolutionResult_SummaryStatus, null);
        }
        this.summaryStatus.add(status);
    }

    public IStatus statusOf(IInstallableUnit iu) {
        return (IStatus)this.iuToStatusMap.get(iu);
    }

    public void addStatus(IInstallableUnit iu, IStatus status) {
        MultiStatus iuSummaryStatus = this.iuToStatusMap.get(iu);
        if (iuSummaryStatus == null) {
            iuSummaryStatus = new MultiStatus("org.eclipse.equinox.p2.operations", 10002, new IStatus[]{status}, this.getIUString(iu), null);
        } else {
            iuSummaryStatus.add(status);
        }
    }

    private String getIUString(IInstallableUnit iu) {
        if (iu == null) {
            return Messages.PlanAnalyzer_Items;
        }
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (name != null) {
            return name;
        }
        return iu.getId();
    }

    public String getSummaryReport() {
        if (this.summaryStatus != null) {
            StringBuffer buffer = new StringBuffer();
            this.appendDetailText((IStatus)this.summaryStatus, buffer, -1, false);
            return buffer.toString();
        }
        return "";
    }

    public String getDetailedReport(IInstallableUnit[] ius) {
        StringBuffer buffer = new StringBuffer();
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            MultiStatus iuStatus = this.iuToStatusMap.get(iu);
            if (iuStatus != null) {
                this.appendDetailText((IStatus)iuStatus, buffer, 0, true);
            }
            ++n2;
        }
        String report = buffer.toString();
        if (report.length() == 0) {
            return null;
        }
        return report;
    }

    void appendDetailText(IStatus status, StringBuffer buffer, int indent, boolean includeTopLevelMessage) {
        IStatus[] children;
        Throwable t;
        if (includeTopLevelMessage) {
            int i = 0;
            while (i < indent) {
                buffer.append(NESTING_INDENT);
                ++i;
            }
            if (status.getMessage() != null) {
                buffer.append(status.getMessage());
            }
        }
        if ((t = status.getException()) != null) {
            buffer.append('\n');
            int i = 0;
            while (i <= indent) {
                buffer.append(NESTING_INDENT);
                ++i;
            }
            if (t instanceof CoreException) {
                IStatus exceptionStatus = ((CoreException)t).getStatus();
                if (exceptionStatus != null && exceptionStatus.getMessage() != null) {
                    buffer.append(exceptionStatus.getMessage());
                } else {
                    String details = t.getLocalizedMessage();
                    if (details != null) {
                        buffer.append(details);
                    }
                }
            } else {
                String details = t.getLocalizedMessage();
                if (details != null) {
                    buffer.append(details);
                }
            }
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            this.appendDetailText(child, buffer, indent + 1, true);
            ++n2;
        }
    }
}

