/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.notifications;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.NewEventNotification;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.ServerResponsesNotification;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.SetupNewServersNotification;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.SetupSystemNotification;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Servers;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;

@Singleton
public class MylynNotificationsSupport {
    public static final String CTX_STATE_NOTIFICATION_IN_PROGRESS = "org.eclipse.epp.logging.aeri.ide.di.notification-in-progress";
    public static final String INTERNAL_SYSTEM_NOTIFICATION_CLOSED = "org/eclipse/epp/internal/logging/aeri/ui/notifications/closed";
    public static final String INTERNAL_NOTIFICATION_OPENED = "org/eclipse/epp/internal/logging/aeri/ui/notifications/opened";
    private Set<Notification> displayed = Sets.newConcurrentHashSet();
    private IEclipseContext context;

    @Inject
    public MylynNotificationsSupport(IEventBroker broker, IEclipseContext context) {
        this.context = context;
    }

    @Inject
    @Optional
    public void notificationClosed(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/notifications/closed") Notification event) {
        this.displayed.remove((Object)event);
        this.context.modify(CTX_STATE_NOTIFICATION_IN_PROGRESS, (Object)(!this.displayed.isEmpty() ? 1 : 0));
    }

    @Inject
    @Optional
    public void notificationOpened(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/notifications/opened") Notification event) {
        this.displayed.add(event);
        this.context.modify(CTX_STATE_NOTIFICATION_IN_PROGRESS, (Object)(!this.displayed.isEmpty() ? 1 : 0));
    }

    public boolean isNotificationInProgress() {
        return !this.displayed.isEmpty();
    }

    public void showConfigureSystemNotification() {
        this.testIsNotificationInProgress();
        SetupSystemNotification notification = (SetupSystemNotification)((Object)ContextInjectionFactory.make(SetupSystemNotification.class, (IEclipseContext)this.context));
        NotificationsUi.getService().notify((List)ImmutableList.of((Object)((Object)notification)));
    }

    public void showConfigureNewServersNotification(List<IServerDescriptor> servers) {
        this.testIsNotificationInProgress();
        SetupNewServersNotification notification = (SetupNewServersNotification)((Object)ContextInjectionFactory.make(SetupNewServersNotification.class, (IEclipseContext)this.context));
        notification.setServers(Servers.sort(servers));
        NotificationsUi.getService().notify((List)ImmutableList.of((Object)((Object)notification)));
    }

    public void showServerResponsesNotification(ILogEventGroup group) {
        this.testIsNotificationInProgress();
        IEclipseContext child = this.context.createChild("endpoint-responses-notification");
        child.set(ILogEventGroup.class, (Object)group);
        ServerResponsesNotification notification = (ServerResponsesNotification)((Object)ContextInjectionFactory.make(ServerResponsesNotification.class, (IEclipseContext)child));
        NotificationsUi.getService().notify((List)ImmutableList.of((Object)((Object)notification)));
    }

    public void showNewEventLoggedNotification(ILogEventGroup group) {
        this.testIsNotificationInProgress();
        Class<NewEventNotification> clazz = NewEventNotification.class;
        IEclipseContext child = this.context.createChild("new-log-events-notification");
        child.set(ILogEventGroup.class, (Object)group);
        NewEventNotification notification = (NewEventNotification)((Object)ContextInjectionFactory.make(clazz, (IEclipseContext)child));
        NotificationsUi.getService().notify((List)ImmutableList.of((Object)((Object)notification)));
    }

    private void testIsNotificationInProgress() {
        if (SystemControl.isDebug() && this.isNotificationInProgress()) {
            Logs.log((Logs.ILogMessage)LogMessages.DEBUG_NOTIFICATION_IN_PROGRESS, (Object[])new Object[]{ImmutableList.of(this.displayed)});
        }
    }
}

