/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.handlers;

import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ServersPage;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.SetupWizard;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.SetupWizardDialog;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Servers;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

@Creatable
public class OpenServersSetupWizardHandler {
    @Execute
    public void execute(IEclipseContext context, @Named(value="org.eclipse.epp.logging.aeri.ide.servers") List<IServerDescriptor> servers, final IEventBroker broker) {
        IEclipseContext child = context.createChild("setup-wizard");
        List<IServerDescriptor> unconfigured = Servers.sort(Servers.copyOfUnconfigured(servers));
        child.set("org.eclipse.epp.logging.aeri.ide.servers", unconfigured);
        SetupWizard wizard = (SetupWizard)((Object)ContextInjectionFactory.make(SetupWizard.class, (IEclipseContext)child));
        ServersPage serversPage = (ServersPage)((Object)ContextInjectionFactory.make(ServersPage.class, (IEclipseContext)child));
        wizard.addPage((IWizardPage)serversPage);
        Shell parentShell = (Shell)child.get("activeShell");
        SetupWizardDialog dialog = new SetupWizardDialog(parentShell, wizard){

            protected void finishPressed() {
                super.finishPressed();
                broker.post("org/eclipse/epp/internal/logging/aeri/ui/event/reschedule", null);
            }
        };
        dialog.open();
    }
}

