/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ExternalServersEnabledAlert;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.wizard.Wizard;

public class SetupWizard
extends Wizard {
    public static final String CTX_STATE_SETUP_IN_PROGRESS = "org.eclipse.epp.logging.aeri.ide.di.configure-in-progress";
    private ISystemSettings systemSettings;
    private IEclipseContext parentContext;
    private List<IServerDescriptor> servers;
    private boolean onShellClosedEvent;

    @Inject
    public SetupWizard(ISystemSettings systemSettings, @Named(value="org.eclipse.epp.logging.aeri.ide.servers") List<IServerDescriptor> servers, ImageRegistry registry, IEclipseContext eclipseContext) {
        this.systemSettings = systemSettings;
        this.servers = servers;
        this.parentContext = eclipseContext;
        this.setHelpAvailable(false);
        this.setWindowTitle(Messages.WIZARD_TITLE_SETUP);
        this.setNeedsProgressMonitor(false);
        this.setDefaultPageImageDescriptor(registry.getDescriptor("icons/wizban/stacktraces_wiz.png"));
        this.parentContext.modify(CTX_STATE_SETUP_IN_PROGRESS, (Object)true);
    }

    public boolean performCancel() {
        if (this.onShellClosedEvent) {
            return true;
        }
        this.systemSettings.setSendMode(SendMode.NEVER);
        this.systemSettings.setConfigured(true);
        this.parentContext.modify(CTX_STATE_SETUP_IN_PROGRESS, (Object)false);
        return true;
    }

    public boolean performFinish() {
        if (this.needsWarning() && this.showAlert() != 0) {
            return false;
        }
        for (IServerDescriptor server : this.servers) {
            server.setConfigured(true);
        }
        this.systemSettings.setConfigured(true);
        this.parentContext.modify(CTX_STATE_SETUP_IN_PROGRESS, (Object)false);
        return true;
    }

    private int showAlert() {
        return new ExternalServersEnabledAlert(this.getShell()).open();
    }

    private boolean needsWarning() {
        for (IServerDescriptor server : this.servers) {
            String id = server.getId();
            if (!server.isEnabled() || id.startsWith("org.eclipse")) continue;
            return true;
        }
        return false;
    }

    public void notifyShellClosedEvent() {
        this.onShellClosedEvent = true;
    }
}

