/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.di;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ide.IIdeFactory;
import org.eclipse.epp.internal.logging.aeri.ide.IIdePackage;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.di.ServerStateLocationCreationFunction;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.CreateServerConnectionHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Servers;
import org.eclipse.epp.logging.aeri.core.ILink;
import org.eclipse.epp.logging.aeri.core.IModelFactory;
import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.IServerConnection;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.util.Logs;

public class ExtensionPointServersCreationFunction
extends ContextFunction {
    public static final String EXT_SERVERS_ID = "org.eclipse.epp.logging.aeri.ide.servers";

    public Object compute(IEclipseContext notused, String contextKey) {
        contextKey = (String)Preconditions.checkNotNull((Object)contextKey);
        IEclipseContext systemContext = SystemControl.getSystemContext();
        IExtensionRegistry registry = (IExtensionRegistry)systemContext.get(IExtensionRegistry.class);
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXT_SERVERS_ID);
        ImmutableList.Builder b = ImmutableList.builder();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IServerDescriptor server = IIdeFactory.eINSTANCE.createServerDescriptor();
            server.setConfigurationElement(element);
            server.setClazz(element.getAttribute("class"));
            String contributor = element.getContributor().getName();
            server.setContributor(contributor);
            this.copyFromRegistry(element, (EObject)server, (Set<EAttribute>)ImmutableSet.of((Object)IIdePackage.Literals.SERVER_DESCRIPTOR__ID, (Object)IIdePackage.Literals.SERVER_DESCRIPTOR__NAME, (Object)IIdePackage.Literals.SERVER_DESCRIPTOR__DESCRIPTION, (Object)IIdePackage.Literals.SERVER_DESCRIPTOR__ICON16, (Object)IIdePackage.Literals.SERVER_DESCRIPTOR__ICON32));
            this.readLinks(server, element);
            try {
                IEclipseContext childContext = systemContext.createChild("Server Context of '" + server.getId() + "'");
                childContext.set(IServerDescriptor.class, (Object)server);
                childContext.set(File.class.getName(), (Object)new ServerStateLocationCreationFunction());
                IServerConnection object = new CreateServerConnectionHandler().execute(server, childContext);
                server.setConnection(object);
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_EXTENSION_FAILED, (Throwable)e, (Object[])new Object[]{server.getId(), e.getMessage()});
            }
            b.add((Object)server);
            ++n2;
        }
        List<IServerDescriptor> servers = Servers.sort((Iterable<IServerDescriptor>)b.build());
        systemContext.set(contextKey, servers);
        return servers;
    }

    private void readLinks(IServerDescriptor server, IConfigurationElement element) {
        IConfigurationElement[] children;
        EMap links = server.getLinks();
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren("link");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            ILink link = IModelFactory.eINSTANCE.createLink();
            this.copyFromRegistry(child, (EObject)link, (Set<EAttribute>)ImmutableSet.of((Object)IModelPackage.Literals.LINK__REL, (Object)IModelPackage.Literals.LINK__HREF, (Object)IModelPackage.Literals.LINK__TITLE));
            links.put((Object)link.getRel(), (Object)link);
            ++n2;
        }
    }

    private void copyFromRegistry(IConfigurationElement child, EObject link, Set<EAttribute> attrs) {
        for (EAttribute attr : attrs) {
            String value = child.getAttribute(attr.getName());
            link.eSet((EStructuralFeature)attr, (Object)value);
        }
    }
}

