/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.Nullable;

public class StatusSwitch<T> {
    @Nullable
    public T doSwitch(@Nullable IStatus status) {
        if (status == null) {
            return null;
        }
        T res = this.caseStatus(status);
        if (res != null) {
            return res;
        }
        Throwable exception = status.getException();
        if (exception != null && (res = this.doSwitch(exception)) != null) {
            return res;
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            res = this.doSwitch(child);
            if (res != null) {
                return res;
            }
            ++n2;
        }
        return res;
    }

    @Nullable
    public T doSwitch(Throwable exception) {
        CoreException coreException;
        IStatus innerStatus;
        if (exception == null) {
            return null;
        }
        T res = this.caseThrowable(exception);
        if (res != null) {
            return res;
        }
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            res = this.caseStackTraceElement(element);
            if (res != null) {
                return res;
            }
            ++n2;
        }
        if (exception instanceof CoreException && (innerStatus = (coreException = (CoreException)exception).getStatus()) != null && (res = this.doSwitch(innerStatus)) != null) {
            return res;
        }
        Throwable cause = exception.getCause();
        if (cause != null && (res = this.doSwitch(cause)) != null) {
            return res;
        }
        return res;
    }

    @Nullable
    public T caseStatus(IStatus status) {
        return null;
    }

    @Nullable
    public T caseThrowable(Throwable throwable) {
        return null;
    }

    @Nullable
    public T caseStackTraceElement(StackTraceElement stackTraceElement) {
        return null;
    }
}

