/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.junit4;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.composite.AbstractControlFactory;
import org.eclipse.emf.parsley.composite.DialogControlFactory;
import org.eclipse.emf.parsley.composite.FormControlFactory;
import org.eclipse.emf.parsley.composite.MultipleFeatureControl;
import org.eclipse.emf.parsley.junit4.AbstractEmfParsleyShellBasedTest;
import org.eclipse.emf.parsley.junit4.ui.util.RunnableWithResult;
import org.eclipse.emf.parsley.junit4.util.TestDefaultRealm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractEmfParsleyControlBasedTest
extends AbstractEmfParsleyShellBasedTest {
    private static final Logger LOGGER = Logger.getLogger(AbstractEmfParsleyControlBasedTest.class);
    private TestDefaultRealm realm;

    @Before
    public void setupRealm() {
        this.realm = new TestDefaultRealm();
    }

    @After
    public void disposeRealm() {
        this.realm.dispose();
    }

    protected EditingDomain getEditingDomain() {
        return null;
    }

    protected void initialize(DialogControlFactory controlFactory, EObject obj) {
        this.initializeCommon((AbstractControlFactory)controlFactory, obj);
        controlFactory.init(this.getEditingDomain(), obj, (Composite)this.getShell());
        this.getShell().open();
    }

    protected Boolean initialize(final FormControlFactory controlFactory, final EObject obj) {
        this.initializeCommon((AbstractControlFactory)controlFactory, obj);
        this.getShell().open();
        return this.syncExecInRealm(new RunnableWithResult<Boolean>(){

            @Override
            public Boolean run() {
                controlFactory.init(AbstractEmfParsleyControlBasedTest.this.getEditingDomain(), obj, (Composite)AbstractEmfParsleyControlBasedTest.this.getShell(), new FormToolkit(AbstractEmfParsleyControlBasedTest.this.getDisplay()));
                return true;
            }
        });
    }

    protected void initializeCommon(AbstractControlFactory controlFactory, EObject obj) {
        this.injectMembers(controlFactory);
        this.getOrCreateInjector().injectMembers((Object)controlFactory);
    }

    protected Control createControl(final AbstractControlFactory factory, final EStructuralFeature feature) {
        return this.syncExecInRealm(new RunnableWithResult<Control>(){

            @Override
            public Control run() {
                return factory.create(feature);
            }
        });
    }

    protected void assertCheckbox(Control control, final boolean checked) {
        this.assertControlClass(control, Button.class);
        final Button button = (Button)control;
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                Assert.assertTrue((String)"not a checkbox", ((button.getStyle() & 0x20) != 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)checked, (Object)button.getSelection());
            }
        });
    }

    protected void assertLabel(Control control, final String expectedText) {
        this.assertControlClass(control, Label.class);
        final Label label = (Label)control;
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((Object)expectedText, (Object)label.getText());
            }
        });
    }

    protected void assertStyle(final Control control, final int expectedStyle) {
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                Assert.assertTrue(((control.getStyle() & expectedStyle) > 0 ? 1 : 0) != 0);
            }
        });
    }

    protected void assertStyle(ComboViewer comboViewer, int expectedStyle) {
        this.assertStyle((Control)comboViewer.getCombo(), expectedStyle);
    }

    protected void assertEnabled(final Control control, final boolean expectedEnabled) {
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((Object)expectedEnabled, (Object)control.getEnabled());
            }
        });
    }

    protected void assertCombo(Control control, final String expectedElements, final int selected) {
        this.assertControlClass(control, Combo.class);
        final Combo combo = (Combo)control;
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                String[] items = combo.getItems();
                String join = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)items)), (Functions.Function1)new Functions.Function1<String, String>(){

                    public String apply(String it) {
                        return it.toString();
                    }
                }), (CharSequence)", ");
                Assert.assertEquals((Object)expectedElements, (Object)join);
                Assert.assertEquals((long)selected, (long)combo.getSelectionIndex());
            }
        });
    }

    protected void assertText(Control control, final String expectedText) {
        this.assertControlClass(control, Text.class);
        final Text text = (Text)control;
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((Object)expectedText, (Object)text.getText());
            }
        });
    }

    protected void modifyText(Control control, final String newText) {
        this.assertControlClass(control, Text.class);
        final Text text = (Text)control;
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                text.setText(newText);
            }
        });
        this.assertText(control, newText);
    }

    protected void assertMultipleFeatureControl(Control control, String expectedLabelText, boolean isButtonVisible) {
        this.assertMultipleFeatureControl(control, expectedLabelText, isButtonVisible, true);
    }

    protected void assertMultipleFeatureControl(Control control, final String expectedLabelText, final boolean isButtonVisible, final boolean isButtonEnabled) {
        this.assertControlClass(control, MultipleFeatureControl.class);
        final MultipleFeatureControl mfc = (MultipleFeatureControl)control;
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                Button button = mfc.getButton();
                Assert.assertEquals((Object)"...", (Object)button.getText());
                Assert.assertEquals((Object)expectedLabelText, (Object)mfc.getLabel().getText());
                Assert.assertEquals((Object)isButtonVisible, (Object)button.isVisible());
                Assert.assertEquals((Object)isButtonEnabled, (Object)button.isEnabled());
            }
        });
    }

    protected void setSelectionProgrammatically(final ISelectionProvider selectionProvider, final EObject ... elements) {
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                selectionProvider.setSelection((ISelection)new StructuredSelection((Object[])elements));
            }
        });
    }

    protected void assertTextEditable(Control control, final boolean expectedEditable) {
        this.assertControlClass(control, Text.class);
        final Text text = (Text)control;
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((Object)expectedEditable, (Object)text.getEditable());
            }
        });
    }

    protected void assertTextEnabled(Control control, final boolean expectedEnabled) {
        this.assertControlClass(control, Text.class);
        final Text text = (Text)control;
        this.syncExecVoid(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((Object)expectedEnabled, (Object)text.isEnabled());
            }
        });
    }

    protected void assertControlClass(Control control, Class<? extends Control> clazz) {
        Class<?> controlClass = control.getClass();
        Assert.assertTrue((String)("expected class: " + clazz.getSimpleName() + ", actual class: " + controlClass.getSimpleName()), (boolean)clazz.isAssignableFrom(controlClass));
    }

    protected <T> T syncExecInRealm(final RunnableWithResult<T> toExecute) {
        final ArrayList arrayList = new ArrayList();
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)Display.getDefault()), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            arrayList.add(toExecute.run());
                        }
                        catch (Throwable e) {
                            LOGGER.error((Object)("Exception in runnable: " + e.getMessage()), e);
                            arrayList.add(null);
                        }
                    }
                });
            }
        });
        return (T)arrayList.get(0);
    }
}

