/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.observer;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.emfstore.common.ESObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ObserverCall {
    public List<Result> getObserverCallResults();

    public static class Result {
        private final ESObserver observer;
        private final Method method;
        private final Object result;
        private final Throwable throwable;
        private static final Map<String, Object> DEFAULT_VALUES = new LinkedHashMap<String, Object>();

        static {
            DEFAULT_VALUES.put("int", 0);
            DEFAULT_VALUES.put("boolean", Boolean.FALSE);
            DEFAULT_VALUES.put("long", 0L);
            DEFAULT_VALUES.put("float", new Float(0.0f));
            DEFAULT_VALUES.put("double", new Double(0.0));
            DEFAULT_VALUES.put("byte", new Byte(-128));
            DEFAULT_VALUES.put("short", new Short(Short.MIN_VALUE));
        }

        public Result(ESObserver observer, Method method, Object result) {
            this.observer = observer;
            this.method = method;
            this.result = result;
            this.throwable = null;
        }

        public Result(ESObserver observer, Method method, Throwable throwable) {
            this.observer = observer;
            this.method = method;
            this.result = null;
            this.throwable = throwable;
        }

        public boolean exceptionOccurred() {
            return this.throwable != null;
        }

        public Throwable getException() {
            return this.throwable;
        }

        public ESObserver getObserver() {
            return this.observer;
        }

        public Object getResult() {
            return this.result;
        }

        public Object getResultOrDefaultValue() {
            Object result = this.getResult();
            if (result == null) {
                result = Result.getDefaultValue(this.method);
            }
            return result;
        }

        public static Object getDefaultValue(Method method) {
            if (method.getReturnType().isPrimitive()) {
                return DEFAULT_VALUES.get(method.getReturnType().getSimpleName());
            }
            return null;
        }
    }
}

