/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common;

import java.util.Locale;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.emfstore.internal.common.EMFStoreResource;

public class EMFStoreResourceHelper
extends XMIHelperImpl {
    public EMFStoreResourceHelper(EMFStoreResource resource) {
        super((XMLResource)resource);
    }

    public String convertToString(EFactory factory, EDataType dataType, Object value) {
        Class instanceClass = dataType.getInstanceClass();
        if (instanceClass == Float.TYPE || instanceClass == Float.class) {
            return this.format((Float)value);
        }
        if (instanceClass == Double.TYPE || instanceClass == Double.class) {
            return this.format((Double)value);
        }
        return super.convertToString(factory, dataType, value);
    }

    private String format(Float value) {
        return String.format(Locale.US, "%f", Float.valueOf(value.floatValue()));
    }

    private String format(Double value) {
        return String.format(Locale.US, "%f", (double)value);
    }
}

