/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.simple;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.MetamodelFactory;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="dropContainment", label="Drop Containment", description="In the metamodel, the containment of a reference is dropped. At the same time, a new container reference is created in a container class. In the model, elements previously contained by the first reference have to be contained by the new container reference. It is assumed that these elements are indirectly contained in an instance of the container class.", breaking=true)
public class DropContainment
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference whose containment is dropped")
    public EReference reference;
    @EdaptParameter(description="The container class in which the containment reference is created")
    public EClass containerClass;
    @EdaptParameter(description="The name of the new containment reference")
    public String containerReferenceName;

    @EdaptConstraint(restricts="reference", description="The reference must be containment")
    public boolean checkReferenceContainment(EReference reference) {
        return reference.isContainment();
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass contextClass = this.reference.getEContainingClass();
        this.reference.setContainment(false);
        EReference containerReference = MetamodelFactory.newEReference((EClass)this.containerClass, (String)this.containerReferenceName, (EClass)this.reference.getEReferenceType(), (int)0, (int)-1, (boolean)true);
        Iterator iterator = model.getAllInstances(contextClass).iterator();
        while (iterator.hasNext()) {
            Instance contextElement;
            Instance containerElement = contextElement = (Instance)iterator.next();
            while (containerElement != null && !containerElement.instanceOf(this.containerClass)) {
                containerElement = containerElement.getContainer();
            }
            Object value = contextElement.get((EStructuralFeature)this.reference);
            if (this.reference.isMany()) {
                ((List)containerElement.get((EStructuralFeature)containerReference)).addAll((List)value);
                continue;
            }
            if (value == null) continue;
            containerElement.add((EStructuralFeature)containerReference, value);
        }
    }
}

