/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.swt;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.internal.swt.ECPAdditionalRendererDescription;
import org.eclipse.emf.ecp.view.internal.swt.ECPRendererDescription;
import org.eclipse.emf.ecp.view.internal.swt.EmptyVElementSWTRenderer;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.model.common.ECPStaticRendererTester;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelUtil;
import org.eclipse.emf.ecp.view.spi.swt.ECPAdditionalRendererTester;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.UnknownVElementSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.reporting.AmbiguousRendererPriorityReport;
import org.eclipse.emf.ecp.view.spi.swt.reporting.ECPRendererDescriptionInitFailedReport;
import org.eclipse.emf.ecp.view.spi.swt.reporting.NoRendererFoundReport;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RendererInitFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractAdditionalSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.osgi.framework.Bundle;

@Deprecated
public class SWTRendererFactoryImpl
implements SWTRendererFactory {
    private static final String TEST_DYNAMIC = "dynamicTest";
    private static final String TEST_STATIC = "staticTest";
    private static final String TESTER_PRIORITY = "priority";
    private static final String TESTER_VELEMENT = "element";
    private static final String RENDERER_TESTER = "testClass";
    private static final String RENDER_EXTENSION = "org.eclipse.emf.ecp.ui.view.swt.renderers";
    private static final String ADDITIONAL_RENDER_EXTENSION = "org.eclipse.emf.ecp.ui.view.swt.additionalRenderers";
    private final Set<ECPRendererDescription> rendererDescriptors = new LinkedHashSet<ECPRendererDescription>();
    private final Set<ECPAdditionalRendererDescription> additionalRendererDescriptors = new LinkedHashSet<ECPAdditionalRendererDescription>();

    public SWTRendererFactoryImpl() {
        this.readRenderer();
        this.readAdditionalRenderer();
    }

    protected Set<ECPAdditionalRendererDescription> getAdditionalRendererDescriptors() {
        return this.additionalRendererDescriptors;
    }

    protected Set<ECPRendererDescription> getRendererDescriptors() {
        return this.rendererDescriptors;
    }

    private void readRenderer() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(RENDER_EXTENSION);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    Class<AbstractSWTRenderer<VElement>> renderer = SWTRendererFactoryImpl.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute("renderer"));
                    LinkedHashSet<ECPRendererTester> tester = new LinkedHashSet<ECPRendererTester>();
                    IConfigurationElement[] iConfigurationElementArray2 = configurationElement.getChildren();
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement testerExtension = iConfigurationElementArray2[n6];
                        if (TEST_DYNAMIC.equals(testerExtension.getName())) {
                            tester.add((ECPRendererTester)testerExtension.createExecutableExtension(RENDERER_TESTER));
                        } else if (TEST_STATIC.equals(testerExtension.getName())) {
                            int priority = Integer.parseInt(testerExtension.getAttribute(TESTER_PRIORITY));
                            String vElement = testerExtension.getAttribute(TESTER_VELEMENT);
                            Class supportedEObject = SWTRendererFactoryImpl.loadClass(testerExtension.getContributor().getName(), vElement);
                            tester.add((ECPRendererTester)new ECPStaticRendererTester(priority, supportedEObject));
                        }
                        ++n6;
                    }
                    this.rendererDescriptors.add(new ECPRendererDescription(renderer, tester));
                }
                catch (CoreException ex) {
                    this.report(new ECPRendererDescriptionInitFailedReport(ex));
                }
                catch (ClassNotFoundException ex) {
                    this.report(new ECPRendererDescriptionInitFailedReport(ex));
                }
                catch (InvalidRegistryObjectException ex) {
                    this.report(new ECPRendererDescriptionInitFailedReport(ex));
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void readAdditionalRenderer() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ADDITIONAL_RENDER_EXTENSION);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    Class<AbstractAdditionalSWTRenderer<VElement>> renderer = SWTRendererFactoryImpl.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute("renderer"));
                    ECPAdditionalRendererTester tester = (ECPAdditionalRendererTester)configurationElement.createExecutableExtension("tester");
                    this.additionalRendererDescriptors.add(new ECPAdditionalRendererDescription(renderer, tester));
                }
                catch (CoreException ex) {
                    this.report(new ECPRendererDescriptionInitFailedReport(ex));
                }
                catch (ClassNotFoundException e) {
                    this.report(new ECPRendererDescriptionInitFailedReport(e));
                }
                catch (InvalidRegistryObjectException e) {
                    this.report(new ECPRendererDescriptionInitFailedReport(e));
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void report(AbstractReport reportEntity) {
        Activator.getDefault().getReportService().report(reportEntity);
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }

    @Override
    public AbstractSWTRenderer<VElement> getRenderer(VElement vElement, ViewModelContext viewContext) {
        int highestPriority = -1;
        AbstractSWTRenderer bestCandidate = null;
        ReportService reportService = Activator.getDefault().getReportService();
        for (ECPRendererDescription description : this.rendererDescriptors) {
            int currentPriority = -1;
            for (ECPRendererTester tester : description.getTester()) {
                int testerPriority = tester.isApplicable(vElement, viewContext);
                if (testerPriority <= currentPriority) continue;
                currentPriority = testerPriority;
            }
            if (currentPriority == highestPriority && highestPriority != -1) {
                reportService.report((AbstractReport)new AmbiguousRendererPriorityReport(currentPriority, description.getRenderer().getClass().getCanonicalName(), bestCandidate.getClass().getCanonicalName()));
            }
            if (currentPriority <= highestPriority) continue;
            highestPriority = currentPriority;
            AbstractSWTRenderer renderer = this.createRenderer(vElement, viewContext, reportService, description.getRenderer());
            if (renderer == null) continue;
            bestCandidate = renderer;
        }
        if (bestCandidate == null) {
            reportService.report((AbstractReport)new NoRendererFoundReport(vElement));
            bestCandidate = ViewModelUtil.isDebugMode() ? new UnknownVElementSWTRenderer(vElement, viewContext, reportService) : new EmptyVElementSWTRenderer(vElement, viewContext, reportService);
        }
        bestCandidate.init();
        return bestCandidate;
    }

    private AbstractSWTRenderer<VElement> createRenderer(VElement vElement, ViewModelContext viewContext, ReportService reportService, Class<? extends AbstractSWTRenderer<VElement>> rendererClass) {
        try {
            return rendererClass.getConstructor(vElement.getClass().getInterfaces()[0], ViewModelContext.class).newInstance(vElement, viewContext);
        }
        catch (InstantiationException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport(ex));
        }
        catch (IllegalAccessException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport(ex));
        }
        catch (IllegalArgumentException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport(ex));
        }
        catch (InvocationTargetException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport(ex));
        }
        catch (NoSuchMethodException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport(ex));
        }
        catch (SecurityException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport(ex));
        }
        return null;
    }

    @Override
    public Collection<AbstractAdditionalSWTRenderer<VElement>> getAdditionalRenderer(VElement vElement, ViewModelContext viewModelContext) {
        ReportService reportService = Activator.getDefault().getReportService();
        LinkedHashSet<AbstractAdditionalSWTRenderer<VElement>> renderers = new LinkedHashSet<AbstractAdditionalSWTRenderer<VElement>>();
        for (ECPAdditionalRendererDescription description : this.additionalRendererDescriptors) {
            AbstractSWTRenderer<VElement> renderer;
            ECPAdditionalRendererTester tester = description.getTester();
            if (!tester.isApplicable(vElement, viewModelContext) || (renderer = this.createRenderer(vElement, viewModelContext, reportService, description.getRenderer())) == null) continue;
            renderer.init();
            renderers.add((AbstractAdditionalSWTRenderer<VElement>)((AbstractAdditionalSWTRenderer)renderer));
        }
        return renderers;
    }
}

