/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.net4j;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.cdo.util.CDOURIData;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.view.AbstractCDOViewProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.container.FactoryNotFoundException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;

public abstract class CDONet4jViewProvider
extends AbstractCDOViewProvider {
    protected final String transport;

    public CDONet4jViewProvider(String transport, int priority) {
        super("cdo\\.net4j\\." + transport + "://.*", priority);
        this.transport = transport;
    }

    public CDOView getView(URI uri, ResourceSet resourceSet) {
        CDOURIData data = this.createURIData(uri);
        IConnector connector = this.getConnector(data.getAuthority());
        CDONet4jSession session = this.getNet4jSession(connector, data.getUserName(), data.getPassWord(), data.getRepositoryName());
        String viewID = data.getViewID();
        if (viewID != null) {
            if (data.isTransactional()) {
                return session.openTransaction(viewID, resourceSet);
            }
            return session.openView(viewID, resourceSet);
        }
        String branchPath = data.getBranchPath().toPortableString();
        CDOBranch branch = session.getBranchManager().getBranch(branchPath);
        long timeStamp = data.getTimeStamp();
        if (data.isTransactional()) {
            return session.openTransaction(branch, resourceSet);
        }
        return session.openView(branch, timeStamp, resourceSet);
    }

    public String getPath(URI uri) {
        return new Path(uri.path()).makeAbsolute().removeFirstSegments(1).toString();
    }

    public URI getViewURI(URI uri) {
        CDOURIData uriData = this.createURIData(uri);
        uriData.setResourcePath(null);
        uriData.setExtraParameters(null);
        return uriData.toURI();
    }

    public URI getResourceURI(CDOView view, String path) {
        long timeStamp;
        StringBuilder builder = new StringBuilder();
        builder.append("cdo.net4j.");
        builder.append(this.transport);
        builder.append("://");
        CDONet4jSession session = (CDONet4jSession)view.getSession();
        IChannel channel = session.options().getNet4jProtocol().getChannel();
        if (channel == null) {
            return null;
        }
        IConnector connector = (IConnector)channel.getMultiplexer();
        String repositoryName = session.getRepositoryInfo().getName();
        this.append(builder, connector, repositoryName);
        if (path != null) {
            if (!path.startsWith("/")) {
                builder.append("/");
            }
            builder.append(path);
        }
        int params = 0;
        String branchPath = view.getBranch().getPathName();
        if (!"MAIN".equalsIgnoreCase(branchPath)) {
            builder.append(params++ == 0 ? "?" : "&");
            builder.append("branch");
            builder.append("=");
            builder.append(branchPath);
        }
        if ((timeStamp = view.getTimeStamp()) != 0L) {
            builder.append(params++ == 0 ? "?" : "&");
            builder.append("time");
            builder.append("=");
            builder.append(new SimpleDateFormat().format(new Date(timeStamp)));
        }
        if (!view.isReadOnly()) {
            builder.append(params++ == 0 ? "?" : "&");
            builder.append("transactional");
            builder.append("=true");
        }
        return URI.createURI((String)builder.toString());
    }

    protected CDOURIData createURIData(URI uri) {
        return new CDOURIData(uri);
    }

    protected String getURIAuthority(IConnector connector) {
        String url = connector.getURL().toString();
        return URI.createURI((String)url).authority();
    }

    protected CDONet4jSession getNet4jSession(IConnector connector, String userName, String passWord, String repositoryName) {
        CDONet4jSessionConfiguration configuration = this.getNet4jSessionConfiguration(connector, userName, passWord, repositoryName);
        return configuration.openNet4jSession();
    }

    protected CDONet4jSessionConfiguration getNet4jSessionConfiguration(IConnector connector, String userName, String passWord, String repositoryName) {
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector(connector);
        configuration.setRepositoryName(repositoryName);
        PasswordCredentialsProvider credentialsProvider = null;
        if (userName != null && passWord != null) {
            credentialsProvider = new PasswordCredentialsProvider(userName, passWord);
        } else {
            StringBuilder builder = new StringBuilder();
            this.append(builder, connector, repositoryName);
            String resource = builder.toString();
            try {
                credentialsProvider = (IPasswordCredentialsProvider)this.getContainer().getElement("org.eclipse.net4j.util.security.credentialsProviders", "password", resource);
            }
            catch (FactoryNotFoundException factoryNotFoundException) {
                // empty catch block
            }
            if (credentialsProvider == null) {
                try {
                    credentialsProvider = (IPasswordCredentialsProvider)this.getContainer().getElement("org.eclipse.net4j.util.credentialsProviders", "password", resource);
                }
                catch (FactoryNotFoundException factoryNotFoundException) {
                    // empty catch block
                }
            }
        }
        configuration.setCredentialsProvider((IPasswordCredentialsProvider)credentialsProvider);
        return configuration;
    }

    @Deprecated
    protected CDOSession getSession(IConnector connector, String userName, String passWord, String repositoryName) {
        return (CDOSession)this.getNet4jSession(connector, userName, passWord, repositoryName);
    }

    @Deprecated
    protected CDOSessionConfiguration getSessionConfiguration(IConnector connector, String userName, String passWord, String repositoryName) {
        return (CDOSessionConfiguration)this.getNet4jSessionConfiguration(connector, userName, passWord, repositoryName);
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected IConnector getConnector(String authority) {
        IManagedContainer container = this.getContainer();
        String description = this.getConnectorDescription(authority);
        return Net4jUtil.getConnector((IManagedContainer)container, (String)this.transport, (String)description);
    }

    protected String getConnectorDescription(String authority) {
        return authority;
    }

    private void append(StringBuilder builder, IConnector connector, String repositoryName) {
        String authority = this.getURIAuthority(connector);
        builder.append(authority);
        builder.append("/");
        builder.append(repositoryName);
    }

    public static class JVM
    extends CDONet4jViewProvider {
        public JVM(int priority) {
            super("jvm", priority);
        }

        public JVM() {
            this(500);
        }
    }

    public static class SSL
    extends CDONet4jViewProvider {
        public SSL(int priority) {
            super("ssl", priority);
        }

        public SSL() {
            this(500);
        }
    }

    public static class TCP
    extends CDONet4jViewProvider {
        public TCP(int priority) {
            super("tcp", priority);
        }

        public TCP() {
            this(500);
        }
    }

    public static class WS
    extends CDONet4jViewProvider {
        public static final String ACCEPTOR_NAME_PREFIX = "@";

        public WS(int priority) {
            super("ws", priority);
        }

        public WS() {
            this(500);
        }

        @Override
        public String getPath(URI uri) {
            Path path = new Path(uri.path());
            int index = this.getAcceptorSegmentIndex((IPath)path);
            if (index == -1) {
                throw new InvalidURIException(uri);
            }
            return path.makeAbsolute().removeFirstSegments(index + 2).toString();
        }

        @Override
        protected String getURIAuthority(IConnector connector) {
            String prefix;
            String url = connector.getURL().toString();
            if (url.startsWith(prefix = String.valueOf(this.transport) + "://")) {
                url = url.substring(prefix.length());
            }
            return url;
        }

        @Override
        protected CDOURIData createURIData(URI uri) {
            CDOURIData data = super.createURIData(uri);
            IPath path = new Path(data.getRepositoryName()).append(data.getResourcePath());
            int index = this.getAcceptorSegmentIndex(path);
            if (index == -1) {
                throw new InvalidURIException(uri);
            }
            String authority = data.getAuthority();
            int j = 0;
            while (j <= index) {
                authority = String.valueOf(authority) + "/" + path.segment(j);
                ++j;
            }
            data.setAuthority(authority);
            data.setRepositoryName(path.segment(index + 1));
            data.setResourcePath(path.removeFirstSegments(index + 2));
            return data;
        }

        protected int getAcceptorSegmentIndex(IPath path) {
            int i = 0;
            while (i < path.segmentCount()) {
                if (path.segment(i).startsWith(ACCEPTOR_NAME_PREFIX)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

