/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CheckoutTypePage
extends CheckoutWizardPage {
    private CDORepository repository;
    private String type = "online-transactional";
    private Button transactionalButton;
    private Button historicalButton;
    private Button offlineButton;

    public CheckoutTypePage() {
        super("Checkout Type", "Select the type of the new checkout.");
    }

    public final String getType() {
        return this.type;
    }

    public final void setType(String type) {
        if (!ObjectUtil.equals((Object)this.type, (Object)type)) {
            CheckoutTypePage.log("Setting type to " + type);
            this.type = type;
            this.typeChanged(type);
        }
    }

    @Override
    protected GridData createCompositeGridData() {
        return new GridData(0x1000000, 0x1000000, true, true);
    }

    @Override
    protected void createUI(Composite parent) {
        this.transactionalButton = this.addChoice(parent, "Online Transactional", "icons/transactional.gif", "Creates a remote connection for online editing.", "online-transactional");
        this.historicalButton = this.addChoice(parent, "Online Historical", "icons/historical.gif", "Creates a remote connection for online auditing.", "online-historical");
        this.offlineButton = this.addChoice(parent, "Offline", "icons/disconnect.gif", "Creates a local checkout for offline editing.", "offline");
    }

    private Button addChoice(Composite composite, String text, String imagePath, String description, final String type) {
        final SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutTypePage.this.setType(type);
                CheckoutTypePage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                CheckoutTypePage.this.showNextPage();
            }
        };
        Button button = new Button(composite, 16);
        button.setText(text);
        button.addSelectionListener(listener);
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                listener.widgetDefaultSelected(null);
            }
        });
        GridLayout descriptionLayout = UIUtil.createGridLayout((int)2);
        descriptionLayout.marginLeft = 20;
        descriptionLayout.horizontalSpacing = 5;
        Composite descriptionComposite = new Composite(composite, 0);
        descriptionComposite.setLayout((Layout)descriptionLayout);
        Label imageLabel = new Label(descriptionComposite, 0);
        imageLabel.setImage(OM.getImage(imagePath));
        Label descriptionLabel = new Label(descriptionComposite, 0);
        descriptionLabel.setText(description);
        new Label(composite, 0);
        return button;
    }

    private Button getButton(String type) {
        if (type == "online-transactional") {
            return this.transactionalButton;
        }
        if (type == "online-historical") {
            return this.historicalButton;
        }
        if (type == "offline") {
            return this.offlineButton;
        }
        return null;
    }

    @Override
    protected void repositoryChanged(CDORepository repository) {
        this.repository = repository;
        Button button = this.getButton(this.type);
        if (button != null && !button.isEnabled()) {
            this.setType("online-transactional");
        }
        super.repositoryChanged(repository);
    }

    @Override
    protected void pageActivated() {
        if (this.transactionalButton != null) {
            this.transactionalButton.setEnabled(false);
            this.historicalButton.setEnabled(false);
            this.offlineButton.setEnabled(false);
            if (this.repository != null) {
                this.transactionalButton.setEnabled(true);
                CDORepository.VersioningMode versioningMode = this.repository.getVersioningMode();
                if (versioningMode == null || versioningMode.isSupportingAudits()) {
                    this.historicalButton.setEnabled(true);
                    CDORepository.IDGeneration idGeneration = this.repository.getIDGeneration();
                    if (idGeneration == null || idGeneration == CDORepository.IDGeneration.UUID) {
                        this.offlineButton.setEnabled(true);
                    }
                }
                if (this.historicalButton.getSelection() && !this.historicalButton.isEnabled()) {
                    this.setType("online-transactional");
                } else if (this.offlineButton.getSelection() && !this.offlineButton.isEnabled()) {
                    this.setType("online-transactional");
                }
            }
            this.transactionalButton.setSelection("online-transactional".equals(this.type));
        }
        this.historicalButton.setSelection("online-historical".equals(this.type));
        this.offlineButton.setSelection("offline".equals(this.type));
    }

    @Override
    protected boolean doValidate() throws CheckoutWizardPage.ValidationProblem {
        return true;
    }

    @Override
    protected void fillProperties(Properties properties) {
        properties.setProperty("type", this.type);
        properties.setProperty("readOnly", Boolean.toString("online-historical".equals(this.type)));
    }
}

