/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.decorators;

import java.io.IOException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.egit.gitflow.GitFlowConfig;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.decorators.DecoratorRepositoryStateCache;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;

public class GitFlowLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String DECORATOR_ID = "org.eclipse.egit.gitflow.ui.internal.decorators.GitflowLightweightDecorator";
    private ILog log = Activator.getDefault().getLog();

    public void decorate(Object element, IDecoration decoration) {
        Repository repository;
        if (!PlatformUI.isWorkbenchRunning() || Activator.getDefault() == null) {
            return;
        }
        GitFlowConfig config = null;
        if (element instanceof GitFlowRepository) {
            config = ((GitFlowRepository)element).getConfig();
        } else if (element instanceof RepositoryNode && (repository = ((RepositoryNode)element).getRepository()) != null) {
            config = new GitFlowConfig(DecoratorRepositoryStateCache.INSTANCE.getConfig(repository));
        }
        try {
            if (config != null) {
                this.decorateRepository(config, decoration);
            }
        }
        catch (Exception e) {
            this.log.log(Activator.error(e.getMessage(), e));
        }
    }

    private void decorateRepository(GitFlowConfig config, IDecoration decoration) throws IOException {
        DecorationHelper helper = new DecorationHelper();
        helper.decorate(decoration, config);
    }

    private static class DecorationHelper {
        private static final ImageDescriptor INITIALIZED_IMAGE = new CachedImageDescriptor(UIIcons.OVR_GITFLOW);

        private DecorationHelper() {
        }

        public void decorate(IDecoration decoration, GitFlowConfig config) throws IOException {
            this.decorateIcons(decoration, config);
        }

        private void decorateIcons(IDecoration decoration, GitFlowConfig config) {
            ImageDescriptor overlay = null;
            if (config.isInitialized()) {
                overlay = INITIALIZED_IMAGE;
            }
            if (overlay != null) {
                decoration.addOverlay(overlay);
            }
        }

        private static class CachedImageDescriptor
        extends ImageDescriptor {
            private ImageDescriptor descriptor;
            private ImageData data;

            public CachedImageDescriptor(ImageDescriptor descriptor) {
                this.descriptor = descriptor;
            }

            public ImageData getImageData() {
                if (this.data == null) {
                    this.data = this.descriptor.getImageData();
                }
                return this.data;
            }
        }
    }
}

