/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.util.DependencyImpactDescription;
import org.eclipse.datatools.enablement.ibm.util.DependencyImpactMessages;
import org.eclipse.datatools.enablement.ibm.util.DependencyProvider;
import org.eclipse.datatools.enablement.ibm.util.ImpactProvider;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DependencyImpactAnalyst {
    private static DependencyImpactAnalyst INSTANCE = null;
    private ArrayList dependencyProviders = new ArrayList();
    private ArrayList impactProviders = new ArrayList();
    private Map dependencyMap = null;

    public static DependencyImpactAnalyst getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DependencyImpactAnalyst();
        }
        return INSTANCE;
    }

    public DependencyImpactDescription[] getDirectDependencies(EObject obj) {
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        Set excluded = this.getAllContainedObjects(obj);
        Iterator it = this.dependencyProviders.iterator();
        while (it.hasNext()) {
            DependencyProvider provider = (DependencyProvider)it.next();
            try {
                DependencyImpactDescription[] deps = provider.getDependencies(obj);
                if (deps == null) continue;
                int i = 0;
                while (i < deps.length) {
                    if (deps[i].getSource()[0] != null && deps[i].getTarget() != null) {
                        excluded.add(deps[i].getTarget());
                        dependencies.add(deps[i]);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                it.remove();
            }
        }
        dependencies.addAll(this.getDirectDependenciesInternal(obj, excluded));
        return dependencies.toArray(new DependencyImpactDescription[dependencies.size()]);
    }

    private List getDirectDependenciesInternal(EObject obj, Set excluded) {
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        excluded.addAll(this.getAllContainers(obj));
        excluded.add(obj);
        if (obj instanceof SQLObject) {
            for (Dependency dep : ((SQLObject)obj).getDependencies()) {
                dependencies.add(this.constructDependencyImpactDescription(new EObject[]{obj}, dep.getDependencyType(), dep.getTargetEnd()));
                excluded.add(dep.getTargetEnd());
            }
        }
        if (!(obj instanceof Dependency)) {
            ArrayList vec = this.getAllReferenceDependencies(obj, excluded);
            dependencies.addAll(vec);
        }
        return dependencies;
    }

    public DependencyImpactDescription[] getAggregateDependencies(EObject obj) {
        Set contained = this.getAllContainedObjects(obj);
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        DependencyImpactDescription[] desc = this.getDirectDependencies(obj);
        int i = 0;
        while (i < desc.length) {
            dependencies.add(desc[i]);
            ++i;
        }
        Iterator it = contained.iterator();
        while (it.hasNext()) {
            desc = this.getDirectDependencies((EObject)it.next());
            int i2 = 0;
            while (i2 < desc.length) {
                if (!contained.contains(desc[i2].getTarget())) {
                    dependencies.add(desc[i2]);
                }
                ++i2;
            }
        }
        DependencyImpactDescription[] r = new DependencyImpactDescription[dependencies.size()];
        it = dependencies.iterator();
        int i3 = 0;
        while (it.hasNext()) {
            r[i3++] = (DependencyImpactDescription)it.next();
        }
        return r;
    }

    public DependencyImpactDescription[] getDirectDependencies(EObject obj, int recursionDepth) {
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        Set excluded = this.getAllContainedObjects(obj);
        excluded.addAll(this.getAllContainers(obj));
        DependencyImpactDescription[] d = this.getDirectDependencies(obj);
        int i = 0;
        while (i < d.length) {
            dependencies.add(d[i]);
            excluded.add(d[i].getTarget());
            ++i;
        }
        int size = dependencies.size();
        int i2 = 0;
        while (i2 < size) {
            dependencies.addAll(this.getDirectDependencies(((DependencyImpactDescription)dependencies.get(i2)).getTarget(), recursionDepth, excluded));
            ++i2;
        }
        return dependencies.toArray(new DependencyImpactDescription[dependencies.size()]);
    }

    public DependencyImpactDescription[] getAggregateDependencies(EObject obj, int recursionDepth) {
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        Set excluded = this.getAllContainedObjects(obj);
        excluded.addAll(this.getAllContainers(obj));
        DependencyImpactDescription[] d = this.getAggregateDependencies(obj);
        int i = 0;
        while (i < d.length) {
            dependencies.add(d[i]);
            excluded.add(d[i].getTarget());
            ++i;
        }
        int size = dependencies.size();
        int i2 = 0;
        while (i2 < size) {
            dependencies.addAll(this.getAggregateDependencies(((DependencyImpactDescription)dependencies.get(i2)).getTarget(), recursionDepth, excluded));
            ++i2;
        }
        return dependencies.toArray(new DependencyImpactDescription[dependencies.size()]);
    }

    public DependencyImpactDescription[] getDirectImpacted(EObject obj) {
        this.buildDependencyMapForAll(obj);
        DependencyImpactDescription[] r = this.getDirectImpactedInternal(obj);
        this.clearDependencyMap();
        return r;
    }

    public DependencyImpactDescription[] getDirectImpacted2(EObject obj) {
        this.buildDependencyMapForAll(obj);
        DependencyImpactDescription[] r = this.getDirectImpactedInternal(obj);
        return r;
    }

    private void buildDependencyMapForAll(EObject selectedObj) {
        if (this.dependencyMap != null) {
            return;
        }
        this.dependencyMap = new HashMap();
        if (selectedObj instanceof ICatalogObject) {
            return;
        }
    }

    private void buildDependencyMap(EObject obj) {
        EObject root = ContainmentServiceImpl.INSTANCE.getRootElement(obj);
        Set elements = this.getAllContainedObjects(root);
        elements.add(root);
        for (EObject o : elements) {
            HashSet excluded = new HashSet();
            for (DependencyImpactDescription desc : this.getDirectDependenciesInternal(o, excluded)) {
                ArrayList impacted;
                EObject target = desc.getTarget();
                if (this.dependencyMap.containsKey(target)) {
                    impacted = (ArrayList)this.dependencyMap.get(target);
                } else {
                    impacted = new ArrayList();
                    this.dependencyMap.put(target, impacted);
                }
                EObject[] source = desc.getSource();
                String type = desc.getType();
                int k = 0;
                while (k < source.length) {
                    impacted.add(this.constructDependencyImpactDescription(new EObject[]{target}, type, source[k]));
                    ++k;
                }
            }
        }
    }

    public void clearDependencyMap() {
        this.dependencyMap = null;
    }

    private DependencyImpactDescription[] getDirectImpactedInternal(EObject obj) {
        ArrayList<DependencyImpactDescription> impactedVector = new ArrayList<DependencyImpactDescription>();
        if (obj instanceof IDatabaseObject) {
            IDatabaseObject dbObj = (IDatabaseObject)obj;
            ICatalogObject[] objs = dbObj.getImpacted();
            int len = objs.length;
            new ArrayList();
            int i = 0;
            while (i < len) {
                EObject target = (EObject)objs[i];
                if (target instanceof ForeignKey) {
                    target = ((ForeignKey)target).getBaseTable();
                }
                impactedVector.add(this.constructDependencyImpactDescription(new EObject[]{obj}, DependencyImpactMessages.DependencyImpactAnalyst_REFERENCE, target));
                ++i;
            }
        } else {
            Iterator it = this.impactProviders.iterator();
            while (it.hasNext()) {
                ImpactProvider provider = (ImpactProvider)it.next();
                try {
                    DependencyImpactDescription[] impacted = provider.getImpacted(obj);
                    if (impacted == null) continue;
                    int m = 0;
                    while (m < impacted.length) {
                        if (impacted[m].getSource()[0] != null && impacted[m].getTarget() != null) {
                            impactedVector.add(impacted[m]);
                        }
                        ++m;
                    }
                }
                catch (Exception e) {
                    it.remove();
                    IBMPluginActivator.getInstance().writeLog(4, 0, e.getMessage(), e);
                }
            }
            Object c = this.dependencyMap.get(obj);
            if (c != null) {
                impactedVector.addAll((ArrayList)c);
            }
        }
        return impactedVector.toArray(new DependencyImpactDescription[impactedVector.size()]);
    }

    public DependencyImpactDescription[] getAggregateImpacted(EObject obj) {
        this.buildDependencyMapForAll(obj);
        Set contained = this.getAllContainedObjects(obj);
        ArrayList<EObject> keys = new ArrayList<EObject>();
        ArrayList<DependencyImpactDescription> values = new ArrayList<DependencyImpactDescription>();
        DependencyImpactDescription[] desc = this.getDirectImpactedInternal(obj);
        int i = 0;
        while (i < desc.length) {
            keys.add(desc[i].getTarget());
            values.add(desc[i]);
            ++i;
        }
        Iterator it = contained.iterator();
        while (it.hasNext()) {
            desc = this.getDirectImpactedInternal((EObject)it.next());
            int i2 = 0;
            while (i2 < desc.length) {
                if (!contained.contains(desc[i2].getTarget())) {
                    keys.add(desc[i2].getTarget());
                    values.add(desc[i2]);
                }
                ++i2;
            }
        }
        DependencyImpactDescription[] r = new DependencyImpactDescription[keys.size()];
        it = values.iterator();
        int i3 = 0;
        while (it.hasNext()) {
            r[i3++] = (DependencyImpactDescription)it.next();
        }
        this.clearDependencyMap();
        return r;
    }

    public DependencyImpactDescription[] getDirectImpacted(EObject obj, int recursionDepth) {
        this.buildDependencyMapForAll(obj);
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        Set excluded = this.getAllContainedObjects(obj);
        excluded.addAll(this.getAllContainers(obj));
        DependencyImpactDescription[] d = this.getDirectImpactedInternal(obj);
        int i = 0;
        while (i < d.length) {
            dependencies.add(d[i]);
            excluded.add(d[i].getTarget());
            ++i;
        }
        int size = dependencies.size();
        int i2 = 0;
        while (i2 < size) {
            dependencies.addAll(this.getDirectImpacted(((DependencyImpactDescription)dependencies.get(i2)).getTarget(), recursionDepth, excluded));
            ++i2;
        }
        DependencyImpactDescription[] r = dependencies.toArray(new DependencyImpactDescription[dependencies.size()]);
        this.clearDependencyMap();
        return r;
    }

    public DependencyImpactDescription[] getAggregateImpacted(EObject obj, int recursionDepth) {
        this.buildDependencyMapForAll(obj);
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        Set excluded = this.getAllContainedObjects(obj);
        excluded.addAll(this.getAllContainers(obj));
        DependencyImpactDescription[] d = this.getAggregateImpacted(obj);
        int i = 0;
        while (i < d.length) {
            dependencies.add(d[i]);
            excluded.add(d[i].getTarget());
            ++i;
        }
        int size = dependencies.size();
        int i2 = 0;
        while (i2 < size) {
            dependencies.addAll(this.getAggregateImpacted(((DependencyImpactDescription)dependencies.get(i2)).getTarget(), recursionDepth, excluded));
            ++i2;
        }
        DependencyImpactDescription[] r = dependencies.toArray(new DependencyImpactDescription[dependencies.size()]);
        this.clearDependencyMap();
        return r;
    }

    private Set getAllContainedObjects(EObject obj) {
        HashSet<EObject> children = new HashSet<EObject>();
        ContainmentService service = IBMPluginActivator.getInstance().getContainmentService();
        for (EObject child : service.getContainedDisplayableElements(obj)) {
            if (!(child instanceof SQLObject)) continue;
            children.add(child);
            children.addAll(this.getAllContainedObjects(child));
        }
        return children;
    }

    private Set getAllContainers(EObject obj) {
        HashSet containers = new HashSet();
        containers.addAll(ContainmentServiceImpl.INSTANCE.getAllContainers(obj));
        return containers;
    }

    private ArrayList getAllReferenceDependencies(EObject obj, Set excluded) {
        ArrayList deps = this.getReferenceDependencies(obj, excluded, obj);
        for (EObject child : this.getAllInvisibleChildren(obj)) {
            if (!(child instanceof SQLObject)) continue;
            deps.addAll(this.getReferenceDependencies(child, excluded, obj));
        }
        return deps;
    }

    private ArrayList getReferenceDependencies(EObject obj, Set excluded, EObject source) {
        ContainmentService service = IBMPluginActivator.getInstance().getContainmentService();
        ArrayList<DependencyImpactDescription> deps = new ArrayList<DependencyImpactDescription>();
        EClass eClass = obj.eClass();
        for (EReference reference : eClass.getEAllReferences()) {
            EObject container;
            EObject target;
            Object t;
            if (reference.getEOpposite() == null) {
                if (reference.isMany()) {
                    for (Object t2 : (Collection)obj.eGet((EStructuralFeature)reference)) {
                        if (t2 instanceof Dependency) {
                            t2 = ((Dependency)t2).getTargetEnd();
                        }
                        if (!(t2 instanceof SQLObject) || excluded.contains(t2)) continue;
                        EObject target2 = (EObject)t2;
                        service.getContainer(target2);
                        if (!service.isDisplayableElement(target2)) continue;
                        excluded.add(target2);
                        deps.add(this.constructDependencyImpactDescription(new EObject[]{source}, DependencyImpactMessages.DependencyImpactAnalyst_REFERENCE, target2));
                    }
                    continue;
                }
                t = obj.eGet((EStructuralFeature)reference);
                if (!(t instanceof SQLObject) || excluded.contains(t)) continue;
                target = (EObject)t;
                service.getContainer(target);
                if (!service.isDisplayableElement(target)) continue;
                excluded.add(target);
                deps.add(this.constructDependencyImpactDescription(new EObject[]{source}, DependencyImpactMessages.DependencyImpactAnalyst_REFERENCE, target));
                continue;
            }
            reference.isMany();
            if (!reference.isMany() || reference.isMany() || !((t = obj.eGet((EStructuralFeature)reference)) instanceof EObject) || excluded.contains(t) || (container = service.getContainer(target = (EObject)t)) == null || !service.isDisplayableElement(target)) continue;
            excluded.add(target);
            deps.add(this.constructDependencyImpactDescription(new EObject[]{source}, DependencyImpactMessages.DependencyImpactAnalyst_REFERENCE, target));
        }
        return deps;
    }

    private boolean isLogicalRelationshipEnd(EObject obj) {
        try {
            Method m = obj.getClass().getMethod("getVerbPhrase", null);
            if (m != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return false;
    }

    private boolean isLogicalGeneralization(EObject obj) {
        try {
            Method m = obj.getClass().getMethod("getSupertype", null);
            if (m != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return false;
    }

    private ArrayList getAllInvisibleChildren(EObject obj) {
        ArrayList children = this.getInvisibleChildren(obj);
        int size = children.size();
        int i = 0;
        while (i < size) {
            children.addAll(this.getAllInvisibleChildren((EObject)children.get(i)));
            ++i;
        }
        return children;
    }

    private ArrayList getInvisibleChildren(EObject obj) {
        ArrayList children = new ArrayList();
        ContainmentService service = IBMPluginActivator.getInstance().getContainmentService();
        HashSet excluded = new HashSet();
        excluded.addAll(service.getContainedDisplayableElements(obj));
        for (Object child : service.getContainedElements(obj)) {
            if (excluded.contains(child)) continue;
            children.add(child);
        }
        return children;
    }

    private DependencyImpactDescription constructDependencyImpactDescription(final EObject[] source, final String type, final EObject target) {
        return new DependencyImpactDescription(){

            @Override
            public EObject getTarget() {
                return target;
            }

            @Override
            public EObject[] getSource() {
                return source;
            }

            @Override
            public String getType() {
                return type;
            }
        };
    }

    private ArrayList getDirectDependencies(EObject obj, int recursionDepth, Set excluded) {
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        ArrayList<DependencyImpactDescription> excludedDependencies = new ArrayList<DependencyImpactDescription>();
        if (recursionDepth-- == 0) {
            return dependencies;
        }
        DependencyImpactDescription[] d = this.getDirectDependencies(obj);
        int i = 0;
        while (i < d.length) {
            if (!excluded.contains(d[i].getTarget())) {
                dependencies.add(d[i]);
                excluded.add(d[i].getTarget());
            } else {
                excludedDependencies.add(d[i]);
            }
            ++i;
        }
        int size = dependencies.size();
        int i2 = 0;
        while (i2 < size) {
            dependencies.addAll(this.getDirectDependencies(((DependencyImpactDescription)dependencies.get(i2)).getTarget(), recursionDepth, excluded));
            ++i2;
        }
        dependencies.addAll(excludedDependencies);
        return dependencies;
    }

    private ArrayList getAggregateDependencies(EObject obj, int recursionDepth, Set excluded) {
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        ArrayList<DependencyImpactDescription> excludedDepencencies = new ArrayList<DependencyImpactDescription>();
        if (recursionDepth-- == 0) {
            return dependencies;
        }
        DependencyImpactDescription[] d = this.getAggregateDependencies(obj);
        int i = 0;
        while (i < d.length) {
            if (!excluded.contains(d[i].getTarget())) {
                dependencies.add(d[i]);
                excluded.add(d[i].getTarget());
            } else {
                excludedDepencencies.add(d[i]);
            }
            ++i;
        }
        int size = dependencies.size();
        int i2 = 0;
        while (i2 < size) {
            dependencies.addAll(this.getAggregateDependencies(((DependencyImpactDescription)dependencies.get(i2)).getTarget(), recursionDepth, excluded));
            ++i2;
        }
        dependencies.addAll(excludedDepencencies);
        return dependencies;
    }

    private ArrayList getDirectImpacted(EObject obj, int recursionDepth, Set excluded) {
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        ArrayList<DependencyImpactDescription> excludedDepencencies = new ArrayList<DependencyImpactDescription>();
        if (recursionDepth-- == 0) {
            return dependencies;
        }
        DependencyImpactDescription[] d = this.getDirectImpactedInternal(obj);
        int i = 0;
        while (i < d.length) {
            if (!excluded.contains(d[i].getTarget())) {
                dependencies.add(d[i]);
                excluded.add(d[i].getTarget());
            } else {
                excludedDepencencies.add(d[i]);
            }
            ++i;
        }
        int size = dependencies.size();
        int i2 = 0;
        while (i2 < size) {
            dependencies.addAll(this.getDirectImpacted(((DependencyImpactDescription)dependencies.get(i2)).getTarget(), recursionDepth, excluded));
            ++i2;
        }
        dependencies.addAll(excludedDepencencies);
        return dependencies;
    }

    private ArrayList getAggregateImpacted(EObject obj, int recursionDepth, Set excluded) {
        ArrayList<DependencyImpactDescription> dependencies = new ArrayList<DependencyImpactDescription>();
        ArrayList<DependencyImpactDescription> excludedDependencies = new ArrayList<DependencyImpactDescription>();
        if (recursionDepth-- == 0) {
            return dependencies;
        }
        DependencyImpactDescription[] d = this.getAggregateImpacted(obj);
        int i = 0;
        while (i < d.length) {
            if (!excluded.contains(d[i].getTarget())) {
                dependencies.add(d[i]);
                excluded.add(d[i].getTarget());
            } else {
                excludedDependencies.add(d[i]);
            }
            ++i;
        }
        int size = dependencies.size();
        int i2 = 0;
        while (i2 < size) {
            dependencies.addAll(this.getAggregateImpacted(((DependencyImpactDescription)dependencies.get(i2)).getTarget(), recursionDepth, excluded));
            ++i2;
        }
        dependencies.addAll(excludedDependencies);
        return dependencies;
    }

    private void initProviders() {
        Object provider;
        int j;
        IConfigurationElement[] configElements;
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "dependencyExtension");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            configElements = extensions[i].getConfigurationElements();
            j = 0;
            while (j < configElements.length) {
                block10: {
                    if (configElements[j].getName().equals("dependency")) {
                        provider = null;
                        try {
                            provider = (DependencyProvider)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException coreException) {
                            break block10;
                        }
                        this.dependencyProviders.add(provider);
                    }
                }
                ++j;
            }
            ++i;
        }
        extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "impactExtension");
        extensions = extensionPoint.getExtensions();
        i = 0;
        while (i < extensions.length) {
            configElements = extensions[i].getConfigurationElements();
            j = 0;
            while (j < configElements.length) {
                block11: {
                    if (configElements[j].getName().equals("impact")) {
                        provider = null;
                        try {
                            provider = (ImpactProvider)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException coreException) {
                            break block11;
                        }
                        this.impactProviders.add(provider);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private DependencyImpactAnalyst() {
        this.initProviders();
    }

    private void dumpDependencyMap() {
        Set keySet = this.dependencyMap.keySet();
        for (Object keyObj : keySet) {
            System.out.println("key = " + ((SQLObject)keyObj).eClass().getName() + " " + ((SQLObject)keyObj).getName());
            ArrayList values = (ArrayList)this.dependencyMap.get(keyObj);
            for (DependencyImpactDescription d : values) {
                EObject eVal = d.getTarget();
                if (eVal instanceof SQLObject) {
                    SQLObject val = (SQLObject)eVal;
                    System.out.println("\ttarget = " + val.eClass().getName() + " " + val.getName());
                } else {
                    System.out.println("\ttarget = " + eVal.getClass().getName());
                }
                EObject[] srcs = d.getSource();
                int i = 0;
                while (i < srcs.length) {
                    EObject src = srcs[i];
                    if (src instanceof SQLObject) {
                        System.out.println("\tsource = " + ((SQLObject)src).eClass().getName() + " " + ((SQLObject)src).getName());
                    } else {
                        System.out.println("\tsource = " + ((SQLObject)src).getClass().getName());
                    }
                    ++i;
                }
            }
        }
    }
}

