/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.ui;

import java.util.function.Supplier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.corrosion.Messages;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class InputComponent {
    protected Label label;
    protected Text text;
    protected Button browseButton;
    protected Button variableButton;
    protected Composite container;
    protected String labelString;
    protected ModifyListener editListener;
    protected GridData labelGridData = new GridData(131072, 0x1000000, false, false);
    protected GridData textGridData = new GridData(4, 0x1000000, true, false, 3, 1);

    public InputComponent(Composite container, String labelString, ModifyListener editListener) {
        this.container = container;
        this.labelString = labelString;
        this.editListener = editListener;
    }

    public void createComponent() {
        this.label = new Label(this.container, 0);
        this.label.setText(this.labelString);
        this.label.setLayoutData((Object)this.labelGridData);
        this.text = new Text(this.container, 2048);
        this.text.setLayoutData((Object)this.textGridData);
        this.text.addModifyListener(this.editListener);
    }

    public String getValue() {
        return this.text.getText();
    }

    public void setValue(String value) {
        this.text.setText(value);
        this.editListener.modifyText(null);
    }

    public void createVariableSelection() {
        this.makeSpaceForButton();
        this.variableButton = new Button(this.container, 0);
        this.variableButton.setText(Messages.LaunchUI_variables);
        this.variableButton.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.variableButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            StringVariableSelectionDialog variableSelector = new StringVariableSelectionDialog(this.variableButton.getShell());
            int returnCode = variableSelector.open();
            String result = variableSelector.getVariableExpression();
            if (returnCode == 0 && result != null) {
                this.text.append(result);
                this.editListener.modifyText(null);
            }
        }));
    }

    public void createProjectSelection() {
        this.createSelectionButton();
        this.browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ListSelectionDialog dialog = new ListSelectionDialog(this.browseButton.getShell(), (Object)ResourcesPlugin.getWorkspace().getRoot(), (IStructuredContentProvider)new BaseWorkbenchContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), this.labelString);
            dialog.setTitle(Messages.LaunchUI_selection);
            int returnCode = dialog.open();
            Object[] results = dialog.getResult();
            if (returnCode == 0 && results.length > 0) {
                this.text.setText(((IProject)results[0]).getName());
                this.editListener.modifyText(null);
            }
        }));
    }

    public void createResourceSelection(Supplier<IAdaptable> rootSupplier) {
        this.createSelectionButton();
        this.browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.browseButton.getShell(), (IAdaptable)rootSupplier.get(), this.labelString);
            dialog.setTitle(Messages.LaunchUI_selection);
            int returnCode = dialog.open();
            Object[] results = dialog.getResult();
            if (returnCode == 0 && results.length > 0) {
                this.text.setText(((IResource)results[0]).getFullPath().makeRelative().toString());
                this.editListener.modifyText(null);
            }
        }));
    }

    public void createContainerSelection(Supplier<IContainer> containerSupplier) {
        this.createSelectionButton();
        this.browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.browseButton.getShell(), (IContainer)containerSupplier.get(), true, this.labelString);
            dialog.setTitle(Messages.LaunchUI_selection);
            int returnCode = dialog.open();
            Object[] results = dialog.getResult();
            if (returnCode == 0 && results.length > 0) {
                this.text.setText(((Path)results[0]).makeRelative().toString());
                this.editListener.modifyText(null);
            }
        }));
    }

    public void createFileSelection() {
        this.createSelectionButton();
        this.browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.browseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.text.setText(path);
                this.editListener.modifyText(null);
            }
        }));
    }

    public void createFolderSelection() {
        this.createSelectionButton();
        this.browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog dialog = new DirectoryDialog(this.browseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.text.setText(path);
                this.editListener.modifyText(null);
            }
        }));
    }

    public GridData getLabelGridData() {
        return this.labelGridData;
    }

    public void setLabelGridData(GridData labelGridData) {
        this.labelGridData = labelGridData;
        this.label.setLayoutData((Object)this.labelGridData);
    }

    public GridData getTextGridData() {
        return this.textGridData;
    }

    public void setTextGridData(GridData textGridData) {
        this.textGridData = textGridData;
        this.text.setLayoutData((Object)this.textGridData);
    }

    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.text.setEnabled(enabled);
        if (this.browseButton != null) {
            this.browseButton.setEnabled(enabled);
        }
        if (this.variableButton != null) {
            this.variableButton.setEnabled(enabled);
        }
    }

    public void makeSpaceForButton() {
        GridData data = this.getTextGridData();
        int horizontalSpan = data.horizontalSpan;
        if (horizontalSpan > 1) {
            data.horizontalSpan = horizontalSpan - 1;
        }
        this.setTextGridData(data);
    }

    protected void createSelectionButton() {
        this.makeSpaceForButton();
        this.browseButton = new Button(this.container, 0);
        this.browseButton.setText(Messages.LaunchUI_browse);
        this.browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
    }
}

