/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.ICoreRunnable;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.editor.ServiceViewerConfigurator;
import org.eclipse.cft.server.ui.internal.editor.ServiceViewerSorter;
import org.eclipse.cft.server.ui.internal.editor.ServicesTreeLabelProvider;
import org.eclipse.cft.server.ui.internal.editor.TreeContentProvider;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDescriptor;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizard;
import org.eclipse.cft.server.ui.internal.wizards.PartsWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;

public class CloudFoundryApplicationServicesWizardPage
extends PartsWizardPage {
    private boolean canFinish = true;
    private final String serverTypeId;
    private final CloudFoundryServer cloudServer;
    private CheckboxTableViewer servicesViewer;
    private static final String DESCRIPTION = Messages.CloudFoundryApplicationServicesWizardPage_TEXT_BIND_DESCRIP;
    private final Set<String> selectedServicesToBind = new HashSet<String>();
    private final Set<String> servicesToAdd = new HashSet<String>();
    private final Map<String, CFServiceInstance> allServices = new HashMap<String, CFServiceInstance>();
    private List<CFServiceInstance> existingServices = new ArrayList<CFServiceInstance>();
    private final ApplicationWizardDescriptor descriptor;

    public CloudFoundryApplicationServicesWizardPage(CloudFoundryServer cloudServer, CloudFoundryApplicationModule module, ApplicationWizardDescriptor descriptor) {
        super(Messages.COMMONTXT_SERVICES, Messages.CloudFoundryApplicationServicesWizardPage_TEXT_SERVICE_SELECTION, null);
        this.cloudServer = cloudServer;
        this.serverTypeId = module.getServerTypeId();
        this.descriptor = descriptor;
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    @Override
    public boolean isPageComplete() {
        return this.canFinish;
    }

    public void createControl(Composite parent) {
        this.setDescription(DESCRIPTION);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(this.serverTypeId);
        if (banner != null) {
            this.setImageDescriptor(banner);
        }
        Composite tableArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tableArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableArea);
        Composite toolBarArea = new Composite(tableArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(toolBarArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)toolBarArea);
        Label label = new Label(toolBarArea, 0);
        GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)label);
        label.setText(Messages.CloudFoundryApplicationServicesWizardPage_LABEL_SELECT_SERVICE);
        Table table = new Table(tableArea, 2084);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar bar = toolBarManager.createControl(toolBarArea);
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(true, false).applyTo((Control)bar);
        this.servicesViewer = new CheckboxTableViewer(table);
        this.servicesViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.servicesViewer.setLabelProvider((IBaseLabelProvider)new ServicesTreeLabelProvider((TableViewer)this.servicesViewer));
        this.servicesViewer.setSorter((ViewerSorter)new ServiceViewerSorter((TableViewer)this.servicesViewer));
        new ServiceViewerConfigurator().enableAutomaticViewerResizing().configureViewer((TableViewer)this.servicesViewer);
        this.servicesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] services = CloudFoundryApplicationServicesWizardPage.this.servicesViewer.getCheckedElements();
                if (services != null) {
                    CloudFoundryApplicationServicesWizardPage.this.selectedServicesToBind.clear();
                    Object[] objectArray = services;
                    int n = services.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        CFServiceInstance service = (CFServiceInstance)obj;
                        CloudFoundryApplicationServicesWizardPage.this.selectedServicesToBind.add(service.getName());
                        ++n2;
                    }
                    CloudFoundryApplicationServicesWizardPage.this.setServicesToBindInDescriptor();
                    CloudFoundryApplicationServicesWizardPage.this.checkForUnboundServices();
                }
            }
        });
        Action addServiceAction = new Action(Messages.COMMONTXT_ADD_SERVICE, CloudFoundryImages.NEW_SERVICE){

            public void run() {
                List<CFServiceInstance> addedService;
                boolean deferAdditionOfService = true;
                CloudFoundryServiceWizard wizard = new CloudFoundryServiceWizard(CloudFoundryApplicationServicesWizardPage.this.cloudServer, deferAdditionOfService);
                WizardDialog dialog = new WizardDialog(CloudFoundryApplicationServicesWizardPage.this.getShell(), (IWizard)wizard);
                wizard.setParent(dialog);
                dialog.setPageSize(900, 600);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0 && (addedService = wizard.getServices()) != null) {
                    CloudFoundryApplicationServicesWizardPage.this.addServices(addedService);
                    CloudFoundryApplicationServicesWizardPage.this.checkForUnboundServices();
                }
            }

            public String getToolTipText() {
                return Messages.CloudFoundryApplicationServicesWizardPage_TEXT_TOOLTIP;
            }
        };
        this.servicesViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID >= 0) {
                    e.result = e.result != null ? NLS.bind((String)Messages.CloudFoundryApplicationServicesWizardPage_TEXT_TABLE_ACC_LABEL, (Object)e.result) : Messages.CloudFoundryApplicationServicesWizardPage_TEXT_SERVICE_SELECTION;
                }
            }
        });
        toolBarManager.add((IAction)addServiceAction);
        toolBarManager.update(true);
        this.setControl((Control)tableArea);
        this.setInput();
    }

    protected void addServices(List<CFServiceInstance> services) {
        if (services == null || services.size() == 0) {
            return;
        }
        for (CFServiceInstance service : services) {
            this.allServices.put(service.getName(), service);
            this.servicesToAdd.add(service.getName());
            this.selectedServicesToBind.add(service.getName());
        }
        this.setServicesToBindInDescriptor();
        this.setServicesToCreateInDescriptor();
        this.setBoundServiceSelectionInUI();
    }

    protected void setInput() {
        ICoreRunnable runnable = new ICoreRunnable(){

            @Override
            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    CloudFoundryApplicationServicesWizardPage.this.existingServices = CloudFoundryApplicationServicesWizardPage.this.cloudServer.getBehaviour().getServices(monitor);
                    CloudFoundryApplicationServicesWizardPage.this.allServices.clear();
                    CloudFoundryApplicationServicesWizardPage.this.servicesToAdd.clear();
                    CloudFoundryApplicationServicesWizardPage.this.selectedServicesToBind.clear();
                    CloudFoundryApplicationServicesWizardPage.this.populateServicesFromDeploymentInfo();
                    if (CloudFoundryApplicationServicesWizardPage.this.existingServices != null) {
                        for (CFServiceInstance actualService : CloudFoundryApplicationServicesWizardPage.this.existingServices) {
                            if (actualService == null) continue;
                            CloudFoundryApplicationServicesWizardPage.this.allServices.put(actualService.getName(), actualService);
                        }
                    }
                    for (String name : CloudFoundryApplicationServicesWizardPage.this.selectedServicesToBind) {
                        CFServiceInstance service = (CFServiceInstance)CloudFoundryApplicationServicesWizardPage.this.allServices.get(name);
                        if (!service.isLocal()) continue;
                        CloudFoundryApplicationServicesWizardPage.this.servicesToAdd.add(name);
                    }
                    CloudFoundryApplicationServicesWizardPage.this.setServicesToCreateInDescriptor();
                    CloudFoundryApplicationServicesWizardPage.this.checkForUnboundServices();
                }
                catch (CoreException e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CloudFoundryApplicationServicesWizardPage.this.update(false, CloudFoundryPlugin.getErrorStatus((String)NLS.bind((String)Messages.CloudFoundryApplicationServicesWizardPage_ERROR_VERIFY_SERVICE, (Object)e.getMessage()), (Throwable)e));
                        }
                    });
                }
            }
        };
        this.runAsync(runnable, Messages.CloudFoundryApplicationServicesWizardPage_TEXT_VERIFY_SERVICE_PROGRESS);
    }

    protected void checkForUnboundServices() {
        ICoreRunnable runnable = new ICoreRunnable(){

            @Override
            public void run(IProgressMonitor monitor) {
                ArrayList<String> unboundList = new ArrayList<String>();
                for (String name : CloudFoundryApplicationServicesWizardPage.this.selectedServicesToBind) {
                    if (((CFServiceInstance)CloudFoundryApplicationServicesWizardPage.this.allServices.get(name)).isLocal()) continue;
                    if (CloudFoundryApplicationServicesWizardPage.this.existingServices == null) {
                        unboundList.add(name);
                        continue;
                    }
                    boolean isExisting = false;
                    for (CFServiceInstance cfsi : CloudFoundryApplicationServicesWizardPage.this.existingServices) {
                        if (!cfsi.getName().equals(name)) continue;
                        isExisting = true;
                    }
                    if (isExisting) continue;
                    unboundList.add(name);
                }
                String errMsg = null;
                if (!unboundList.isEmpty()) {
                    String msg = Messages.CloudFoundryApplicationServicesWizardPage_SERVICE_DOES_NOT_EXIST_ONE;
                    String param = (String)unboundList.get(0);
                    if (unboundList.size() > 1) {
                        msg = Messages.CloudFoundryApplicationServicesWizardPage_SERVICE_DOES_NOT_EXIST_MULTI;
                        param = String.valueOf(param) + ", " + (String)unboundList.get(1);
                    }
                    errMsg = NLS.bind((String)msg, (Object)param);
                }
                CloudFoundryApplicationServicesWizardPage.this.canFinish = errMsg == null;
                final String ferrMsg = errMsg;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStatus status = Status.OK_STATUS;
                        if (!CloudFoundryApplicationServicesWizardPage.this.canFinish) {
                            status = new Status(4, "org.eclipse.cft.server.core", ferrMsg);
                        }
                        CloudFoundryApplicationServicesWizardPage.this.update(false, status);
                        CloudFoundryApplicationServicesWizardPage.this.setPageComplete(CloudFoundryApplicationServicesWizardPage.this.canFinish);
                        CloudFoundryApplicationServicesWizardPage.this.setBoundServiceSelectionInUI();
                    }
                });
            }
        };
        this.runAsync(runnable, Messages.CloudFoundryApplicationServicesWizardPage_TEXT_VERIFY_SERVICE_PROGRESS);
    }

    protected void populateServicesFromDeploymentInfo() {
        List servicesToBind = this.descriptor.getDeploymentInfo().getServices();
        if (servicesToBind != null) {
            for (CFServiceInstance service : servicesToBind) {
                this.allServices.put(service.getName(), service);
                this.selectedServicesToBind.add(service.getName());
            }
        }
        this.setServicesToBindInDescriptor();
    }

    protected void setBoundServiceSelectionInUI() {
        this.servicesViewer.setInput((Object)this.allServices.values().toArray(new CFServiceInstance[0]));
        List<CFServiceInstance> checkedServices = this.getServicesToBindAsCloudServices();
        this.servicesViewer.setCheckedElements(checkedServices.toArray());
    }

    protected List<CFServiceInstance> getServicesToBindAsCloudServices() {
        ArrayList<CFServiceInstance> servicesToBind = new ArrayList<CFServiceInstance>();
        for (String serviceName : this.selectedServicesToBind) {
            CFServiceInstance service = this.allServices.get(serviceName);
            if (service == null) continue;
            servicesToBind.add(service);
        }
        return servicesToBind;
    }

    protected void setServicesToBindInDescriptor() {
        List<CFServiceInstance> servicesToBind = this.getServicesToBindAsCloudServices();
        this.descriptor.getDeploymentInfo().setServices(servicesToBind);
    }

    protected void setServicesToCreateInDescriptor() {
        ArrayList<CFServiceInstance> toCreate = new ArrayList<CFServiceInstance>();
        for (String serviceName : this.servicesToAdd) {
            CFServiceInstance service = this.allServices.get(serviceName);
            if (service == null) continue;
            toCreate.add(service);
        }
        this.descriptor.setCloudServicesToCreate(toCreate);
    }

    public void setErrorText(String newMessage) {
        this.setMessage("");
        super.setErrorMessage(newMessage);
    }

    public void setMessageText(String newMessage) {
        this.setErrorMessage("");
        super.setMessage(newMessage);
    }
}

