/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import java.io.IOException;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.log.LogContentType;
import org.eclipse.cft.server.ui.internal.console.ConsoleConfig;
import org.eclipse.cft.server.ui.internal.console.ConsoleStream;
import org.eclipse.cft.server.ui.internal.console.UILogConfig;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

public class SingleConsoleStream
extends ConsoleStream {
    private final UILogConfig config;
    protected IOConsoleOutputStream outputStream;
    private MessageConsole console;

    public SingleConsoleStream(UILogConfig config) {
        this.config = config;
    }

    @Override
    public synchronized boolean isActive() {
        if (this.console != null) {
            IConsole[] activeConsoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            boolean isActive = false;
            if (activeConsoles != null) {
                IConsole[] iConsoleArray = activeConsoles;
                int n = activeConsoles.length;
                int n2 = 0;
                while (n2 < n) {
                    IConsole activeConsole = iConsoleArray[n2];
                    if (activeConsole.equals(this.console)) {
                        isActive = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (isActive && this.outputStream != null && !this.outputStream.isClosed()) {
                return true;
            }
            this.close();
        }
        return false;
    }

    @Override
    protected synchronized IOConsoleOutputStream getOutputStream(LogContentType type) {
        if (this.isActive()) {
            return this.outputStream;
        }
        return null;
    }

    @Override
    public synchronized void close() {
        if (this.outputStream != null && !this.outputStream.isClosed()) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                CloudFoundryPlugin.logError((String)("Failed to close console output stream due to: " + e.getMessage()), (Throwable)e);
            }
        }
        this.console = null;
    }

    @Override
    public synchronized void initialiseStream(ConsoleConfig descriptor) throws CoreException {
        this.console = descriptor.getMessageConsole();
        this.outputStream = this.console.newOutputStream();
        if (this.isActive()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    SingleConsoleStream.this.doInitialiseStream(SingleConsoleStream.this.outputStream);
                }
            });
        }
    }

    protected void doInitialiseStream(IOConsoleOutputStream outputStream) {
        if (this.config != null) {
            outputStream.setColor(Display.getDefault().getSystemColor(this.config.getDisplayColour()));
        }
    }
}

