/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.client.AbstractPublishApplicationOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryCredentialsWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.server.core.IModule;

public abstract class EditorAction
extends Action {
    protected final CloudFoundryApplicationsEditorPage editorPage;
    private final RefreshArea area;

    public EditorAction(CloudFoundryApplicationsEditorPage editorPage, RefreshArea area) {
        this(editorPage, area, null, null);
    }

    public EditorAction(CloudFoundryApplicationsEditorPage editorPage, RefreshArea area, String actionName, ImageDescriptor descriptor) {
        this.editorPage = editorPage;
        this.area = area;
        if (actionName != null) {
            this.setText(actionName);
        }
        if (descriptor != null) {
            this.setImageDescriptor(descriptor);
        }
    }

    public CloudFoundryApplicationsEditorPage getEditorPage() {
        return this.editorPage;
    }

    protected IModule getModule() {
        return this.editorPage.getMasterDetailsBlock().getCurrentModule();
    }

    public String getJobName() {
        return Messages.EditorAction_CLOUD_OPERATION;
    }

    protected abstract ICloudFoundryOperation getOperation(IProgressMonitor var1) throws CoreException;

    protected boolean shouldLogException(CoreException e) {
        return true;
    }

    public void run() {
        Job job = this.getJob();
        this.runJob(job);
    }

    protected void runJob(Job job) {
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.editorPage.getEditorSite().getService(IWorkbenchSiteProgressService.class);
        if (service != null) {
            service.schedule(job, 0L, true);
        } else {
            job.schedule();
        }
    }

    protected Job getJob() {
        Job job = new Job(this.getJobName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ICloudFoundryOperation operation = EditorAction.this.getOperation(monitor);
                    if (operation == null) {
                        throw CloudErrorUtil.toCoreException((String)Messages.CloudFoundryEditorAction_TEXT_NO_OP_EXECUTE);
                    }
                    if (operation instanceof AbstractPublishApplicationOperation) {
                        String name = ((AbstractPublishApplicationOperation)operation).getOperationName();
                        this.setName(name);
                    }
                    operation.run(monitor);
                }
                catch (CoreException ce) {
                    if (CloudErrorUtil.isWrongCredentialsException((CoreException)ce)) {
                        Display.getDefault().syncExec(() -> {
                            CloudFoundryCredentialsWizard wizard = new CloudFoundryCredentialsWizard(EditorAction.this.editorPage.getCloudServer());
                            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                            if (dialog.open() == 0) {
                                this.schedule();
                            }
                        });
                    }
                    IStatus statusForEditor = ce.getStatus();
                    Display.getDefault().syncExec(() -> EditorAction.this.editorPage.setMessage(statusForEditor));
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    protected CloudFoundryServerBehaviour getBehaviour() {
        return this.getEditorPage().getCloudServer().getBehaviour();
    }

    public static class EditorCloudEvent
    extends CloudServerEvent {
        private static final long serialVersionUID = 1L;
        private final RefreshArea refreshArea;

        public EditorCloudEvent(CloudFoundryServer server, int type, IStatus status, RefreshArea refreshArea) {
            super(server, type, status);
            this.refreshArea = refreshArea;
        }

        public RefreshArea getRefreshArea() {
            return this.refreshArea;
        }
    }

    public static enum RefreshArea {
        MASTER,
        DETAIL,
        ALL;

    }
}

