/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.ApplicationDebugLauncher;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryDebugDelegate;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.MenuActionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.wst.server.ui.IServerModule;

public class DebugMenuActionHandler
extends MenuActionHandler<IServerModule> {
    public static final String DEBUG_ACTION_ID = "org.eclipse.cft.server.ui.action.debug";

    protected DebugMenuActionHandler() {
        super(IServerModule.class);
    }

    @Override
    protected List<IAction> getActionsFromSelection(IServerModule serverModule) {
        CloudFoundryServer cloudFoundryServer = (CloudFoundryServer)serverModule.getServer().loadAdapter(CloudFoundryServer.class, null);
        if (cloudFoundryServer == null) {
            return Collections.emptyList();
        }
        ArrayList<IAction> actions = new ArrayList<IAction>();
        return actions;
    }

    static class DebugAction
    extends Action {
        protected final CloudFoundryServer cloudServer;
        protected final CloudFoundryApplicationModule appModule;
        protected ApplicationDebugLauncher launcher;
        private int appInstance;
        private int remoteDebugPort;

        public DebugAction(CloudFoundryServer cloudServer, CloudFoundryApplicationModule appModule) {
            this.cloudServer = cloudServer;
            this.appModule = appModule;
            this.launcher = cloudServer.getBehaviour().getDebugLauncher();
            this.appInstance = 0;
            this.remoteDebugPort = CloudFoundryDebugDelegate.DEFAULT_REMOTE_PORT;
            this.setActionValues();
        }

        protected void setActionValues() {
            this.setText(Messages.DebugMenuActionHandler_TEXT_DEBUG_TOOLTIP);
            this.setImageDescriptor(CloudFoundryImages.DEBUG);
            this.setToolTipText(Messages.DebugMenuActionHandler_TEXT_DEBUG_TOOLTIP);
            this.setEnabled(true);
        }

        public void run() {
            try {
                this.launcher.launch(this.appModule, this.cloudServer, this.appInstance, this.remoteDebugPort);
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError((Throwable)e);
            }
        }
    }
}

