/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.IMemoryBlockAddressInfoRetrieval;
import org.eclipse.cdt.debug.ui.memory.traditional.AbstractPane;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalMemoryByte;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DataPane
extends AbstractPane {
    private Shell fToolTipShell;
    private static final String UNICODE_NORTH_WEST_ARROW = "\u2196";

    public DataPane(Rendering parent) {
        super(parent);
    }

    @Override
    protected String getCellText(MemoryByte[] bytes) {
        return this.fRendering.getRadixText(bytes, this.fRendering.getRadix(), this.fRendering.isTargetLittleEndian());
    }

    @Override
    protected void editCell(BigInteger address, int subCellPosition, char character) {
        try {
            int i;
            MemoryByte[] bytes = this.fRendering.getBytes(this.fCaretAddress, this.fRendering.getBytesPerColumn());
            String cellText = this.getCellText(bytes);
            if (cellText == null) {
                return;
            }
            StringBuilder cellTextBuffer = new StringBuilder(cellText);
            cellTextBuffer.setCharAt(subCellPosition, character);
            BigInteger value = new BigInteger(cellTextBuffer.toString().trim(), this.fRendering.getNumericRadix(this.fRendering.getRadix()));
            boolean isSignedType = this.fRendering.getRadix() == 2;
            boolean isSigned = isSignedType && value.compareTo(BigInteger.valueOf(0L)) < 0;
            int bitCount = value.bitLength();
            if (isSignedType) {
                ++bitCount;
            }
            if (bitCount > this.fRendering.getBytesPerColumn() * 8) {
                return;
            }
            int byteLen = this.fRendering.getBytesPerColumn();
            byte[] byteData = new byte[byteLen];
            int i2 = 0;
            while (i2 < byteLen) {
                int bits = 255;
                if (isSignedType && i2 == byteLen - 1) {
                    bits = 127;
                }
                byteData[i2] = (byte)(value.and(BigInteger.valueOf(bits)).intValue() & bits);
                value = value.shiftRight(8);
                ++i2;
            }
            if (isSigned) {
                int n = byteLen - 1;
                byteData[n] = (byte)(byteData[n] | 0x80);
            }
            if (!this.fRendering.isDisplayLittleEndian()) {
                byte[] byteDataSwapped = new byte[byteData.length];
                i = 0;
                while (i < byteData.length) {
                    byteDataSwapped[i] = byteData[byteData.length - 1 - i];
                    ++i;
                }
                byteData = byteDataSwapped;
            }
            if (byteData.length != bytes.length) {
                return;
            }
            TraditionalMemoryByte[] bytesToSet = new TraditionalMemoryByte[bytes.length];
            i = 0;
            while (i < byteData.length) {
                bytesToSet[i] = new TraditionalMemoryByte(byteData[i]);
                bytesToSet[i].setBigEndian(bytes[i].isBigEndian());
                bytesToSet[i].setEdited(true);
                bytesToSet[i].setChanged(bytes[i].isChanged());
                ++i;
            }
            this.fRendering.getViewportCache().setEditedValue(address, bytesToSet);
            this.advanceCursor();
            this.redraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected int getCellWidth() {
        return this.getCellCharacterCount() * this.getCellCharacterWidth() + this.fRendering.getCellPadding() * 2;
    }

    private int getAddressableWidth() {
        int charsPerOctet = this.fRendering.getRadixCharacterCount(this.fRendering.getRadix(), 1);
        int addressCharacterCount = this.fRendering.getAddressableSize() * charsPerOctet;
        return addressCharacterCount * this.getCellCharacterWidth();
    }

    @Override
    protected int getCellCharacterCount() {
        return this.fRendering.getRadixCharacterCount(this.fRendering.getRadix(), this.fRendering.getBytesPerColumn());
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.fRendering.getColumnCount() * this.getCellWidth() + this.fRendering.getRenderSpacing(), 100);
    }

    private BigInteger getCellAddressAt(int x, int y) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        int col = x / this.getCellWidth();
        int row = y / this.getCellHeight();
        if (col >= this.fRendering.getColumnCount()) {
            return null;
        }
        address = address.add(BigInteger.valueOf(row * this.fRendering.getColumnCount() * this.fRendering.getAddressesPerColumn()));
        address = address.add(BigInteger.valueOf(col * this.fRendering.getAddressesPerColumn()));
        return address;
    }

    private BigInteger getAddressAt(int x, int y) {
        BigInteger cellBaseAddress;
        try {
            cellBaseAddress = this.getCellAddressAt(x, y);
        }
        catch (DebugException e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_DETERMINE_ADDRESS_LOCATION"), (Exception)((Object)e));
            return null;
        }
        if (cellBaseAddress == null) {
            return null;
        }
        Point cellPosition = this.getCellLocation(cellBaseAddress);
        if (cellPosition == null) {
            return null;
        }
        int offset = x - cellPosition.x;
        if (offset < 0) {
            return null;
        }
        int addressableOffset = offset / this.getAddressableWidth();
        assert (addressableOffset <= this.getAddressableOctetsPerColumn());
        return cellBaseAddress.add(BigInteger.valueOf(addressableOffset));
    }

    private Point getAddressLocation(BigInteger address) {
        BigInteger baseAddress;
        Point cellLocation = this.getCellLocation(address);
        try {
            baseAddress = this.getCellAddressAt(cellLocation.x, cellLocation.y);
        }
        catch (DebugException e) {
            return null;
        }
        if (baseAddress == null) {
            return null;
        }
        int addressSpan = address.subtract(baseAddress).intValue();
        int charsWidth = this.fRendering.getRadixCharacterCount(this.fRendering.getRadix(), addressSpan) * this.getCellCharacterWidth();
        return new Point(cellLocation.x + charsWidth, cellLocation.y);
    }

    @Override
    protected Point getCellLocation(BigInteger cellAddress) {
        try {
            BigInteger address = this.fRendering.getViewportStartAddress();
            int cellOffset = cellAddress.subtract(address).intValue();
            int row = (cellOffset *= this.fRendering.getAddressableSize()) / (this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn());
            int col = (cellOffset -= row * this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn()) / this.fRendering.getBytesPerColumn();
            int x = col * this.getCellWidth() + this.fRendering.getCellPadding();
            int y = row * this.getCellHeight() + this.fRendering.getCellPadding();
            return new Point(x, y);
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_DETERMINE_CELL_LOCATION"), e);
            return null;
        }
    }

    private Point getRowFirstCellLocation(BigInteger cellAddress) {
        try {
            BigInteger address = this.fRendering.getViewportStartAddress();
            int cellOffset = cellAddress.subtract(address).intValue();
            int row = (cellOffset *= this.fRendering.getAddressableSize()) / (this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn());
            int x = this.fRendering.getCellPadding();
            int y = row * this.getCellHeight() + this.fRendering.getCellPadding();
            return new Point(x, y);
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_DETERMINE_CELL_LOCATION"), e);
            return null;
        }
    }

    private Point getRowLastCellLocation(BigInteger cellAddress) {
        try {
            BigInteger address = this.fRendering.getViewportStartAddress();
            int cellOffset = cellAddress.subtract(address).intValue();
            int row = (cellOffset *= this.fRendering.getAddressableSize()) / (this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn());
            int col = this.fRendering.getColumnCount() - 1;
            int x = col * this.getCellWidth() + this.fRendering.getCellPadding();
            int y = row * this.getCellHeight() + this.fRendering.getCellPadding();
            return new Point(x, y);
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_DETERMINE_CELL_LOCATION"), e);
            return null;
        }
    }

    @Override
    protected void positionCaret(int x, int y) {
        try {
            BigInteger cellAddress = this.getCellAddressAt(x, y);
            if (cellAddress != null) {
                Point cellPosition = this.getCellLocation(cellAddress);
                int offset = x - cellPosition.x;
                int subCellCharacterPosition = offset / this.getCellCharacterWidth();
                if (subCellCharacterPosition == this.getCellCharacterCount()) {
                    cellAddress = cellAddress.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn()));
                    subCellCharacterPosition = 0;
                    cellPosition = this.getCellLocation(cellAddress);
                }
                this.fCaret.setLocation(cellPosition.x + subCellCharacterPosition * this.getCellCharacterWidth(), cellPosition.y);
                this.fCaretAddress = cellAddress;
                this.fSubCellCaretPosition = subCellCharacterPosition;
                this.setCaretAddress(this.fCaretAddress);
            }
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_POSITION_CURSOR"), e);
        }
    }

    @Override
    protected BigInteger getViewportAddress(int col, int row) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        address = address.add(BigInteger.valueOf((row * this.fRendering.getColumnCount() + col) * this.fRendering.getAddressesPerColumn()));
        return address;
    }

    @Override
    protected void paint(PaintEvent pe) {
        super.paint(pe);
        this.doPaintData(pe);
    }

    protected void doPaintData(PaintEvent pe) {
        GC gc = pe.gc;
        int cellHeight = this.getCellHeight();
        int cellWidth = this.getCellWidth();
        int columns = this.fRendering.getColumnCount();
        try {
            BigInteger startAddress = this.fRendering.getViewportStartAddress();
            int i = 0;
            while (i < this.fRendering.getRowCount()) {
                int col = 0;
                while (col < columns) {
                    gc.setFont(this.fRendering.getFont());
                    if (this.isOdd(col)) {
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorText());
                    } else {
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorTextAlternate());
                    }
                    BigInteger cellAddress = startAddress.add(BigInteger.valueOf((i * this.fRendering.getColumnCount() + col) * this.fRendering.getAddressesPerColumn()));
                    MemoryByte[] bytes = this.fRendering.getBytes(cellAddress, this.fRendering.getBytesPerColumn());
                    boolean drawBox = false;
                    if (this.fRendering.getSelection().isSelected(cellAddress)) {
                        gc.setBackground(this.fRendering.getTraditionalRendering().getColorSelection());
                        gc.fillRectangle(cellWidth * col + this.fRendering.getCellPadding(), cellHeight * i, cellWidth, cellHeight);
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorBackground());
                    } else {
                        gc.setBackground(this.fRendering.getTraditionalRendering().getColorBackground());
                        gc.fillRectangle(cellWidth * col + this.fRendering.getCellPadding(), cellHeight * i, cellWidth, cellHeight);
                        this.applyCustomColor(gc, (TraditionalMemoryByte[])bytes, col);
                        drawBox = this.shouldDrawBox((TraditionalMemoryByte[])bytes, col);
                    }
                    gc.drawText(this.getCellText(bytes), cellWidth * col + this.fRendering.getCellPadding(), cellHeight * i + this.fRendering.getCellPadding());
                    if (drawBox) {
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorTextAlternate());
                        gc.drawRectangle(cellWidth * col, cellHeight * i, cellWidth, cellHeight - 1);
                    }
                    BigInteger cellEndAddress = cellAddress.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn()));
                    cellEndAddress = cellEndAddress.subtract(BigInteger.valueOf(1L));
                    if (this.fCaretEnabled && cellAddress.compareTo(this.fCaretAddress) <= 0 && cellEndAddress.compareTo(this.fCaretAddress) >= 0) {
                        int x = cellWidth * col + this.fRendering.getCellPadding() + this.fSubCellCaretPosition * this.getCellCharacterWidth();
                        int y = cellHeight * i + this.fRendering.getCellPadding();
                        this.fCaret.setLocation(x, y);
                    }
                    if (this.fRendering.isDebug()) {
                        gc.drawRectangle(cellWidth * col + this.fRendering.getCellPadding(), cellHeight * i + this.fRendering.getCellPadding(), cellWidth, cellHeight);
                    }
                    ++col;
                }
                ++i;
            }
            this.markAddressesWithAdditionalInfo(gc);
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_PAINT"), e);
        }
    }

    private void markAddressesWithAdditionalInfo(GC gc) {
        BigInteger[] sortedAddresses;
        if (this.fRendering.isDisposed() || !this.fRendering.isVisible() || this.isDisposed()) {
            return;
        }
        Map<BigInteger, List<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>> addressToInfoItems = this.fRendering.getVisibleValueToAddressInfoItems();
        if (addressToInfoItems.size() < 1) {
            return;
        }
        int addressableWidth = this.getAddressableWidth();
        if (this.fRendering.getAddressableSize() == this.fRendering.getBytesPerColumn()) {
            int n = addressableWidth = this.getAddressableWidth() > this.getCellWidth() ? this.getCellWidth() : this.getAddressableWidth();
        }
        assert (addressableWidth > 0);
        int width = 1;
        int leftMargin = 1;
        int rightMargin = leftMargin + 1;
        int lowerMargin = 1;
        int lineWidth = 2;
        int height = this.getCellTextHeight() - this.fRendering.getCellPadding() + lowerMargin;
        Color origColor = gc.getForeground();
        int origLineWidth = gc.getLineWidth();
        gc.setForeground(this.fRendering.getTraditionalRendering().getColorChanged());
        gc.setLineWidth(lineWidth);
        BigInteger[] bigIntegerArray = sortedAddresses = this.orderItemsAscending(addressToInfoItems.keySet());
        int n = sortedAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] sameStartOrderedItems;
            BigInteger startAddress = bigIntegerArray[n2];
            Point location = this.getAddressLocation(startAddress);
            Point firstCellInRow = this.getRowFirstCellLocation(startAddress);
            Point lastCellInRow = this.getRowLastCellLocation(startAddress);
            List<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem> sameStartAddressitems = addressToInfoItems.get(startAddress);
            IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] iMemoryBlockAddressInfoItemArray = sameStartOrderedItems = this.orderItemsByLengthDescending(sameStartAddressitems);
            int n3 = sameStartOrderedItems.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem item = iMemoryBlockAddressInfoItemArray[n4];
                BigInteger addressUnits = item.getRangeInAddressableUnits();
                Color rangeColor = this.resolveColor(item.getRegionRGBColor());
                if (rangeColor != null) {
                    gc.setForeground(rangeColor);
                }
                BigInteger endAddress = startAddress.add(addressUnits.subtract(BigInteger.ONE));
                Point endLocation = this.getAddressLocation(endAddress);
                endLocation.x += addressableWidth;
                int rowsIndex = (endLocation.y - location.y) / this.getCellHeight();
                int i = 0;
                while (i <= rowsIndex) {
                    Point rowLocation = new Point(firstCellInRow.x, firstCellInRow.y + i * this.getCellHeight());
                    if (this.isRowVisible(rowLocation.y)) {
                        if (i == 0) {
                            if (endLocation.y == location.y) {
                                width = endLocation.x - location.x + rightMargin;
                                gc.drawRectangle(location.x - leftMargin, location.y, width, height);
                            } else {
                                width = lastCellInRow.x + addressableWidth * this.fRendering.getAddressesPerColumn() - location.x + rightMargin;
                                location.x -= leftMargin;
                                this.drawRectangleOpenEnd(location, width, height, gc);
                            }
                        } else if (i > 0 && i < rowsIndex) {
                            width = lastCellInRow.x + addressableWidth * this.fRendering.getAddressesPerColumn() - firstCellInRow.x + rightMargin;
                            assert (width > 0);
                            rowLocation.x -= leftMargin;
                            this.drawParallelLines(rowLocation, width, height, gc);
                        } else if (i == rowsIndex) {
                            width = endLocation.x - firstCellInRow.x + rightMargin;
                            rowLocation.x -= leftMargin;
                            this.drawRectangleOpenStart(rowLocation, width, height, gc);
                        }
                    }
                    ++i;
                }
                String info = this.fRendering.buildAddressInfoString(startAddress, ",", false);
                if (info.length() > 0) {
                    gc.drawText(UNICODE_NORTH_WEST_ARROW + info, location.x, location.y + this.getCellTextHeight());
                }
                if (rangeColor != null) {
                    rangeColor.dispose();
                }
                ++n4;
            }
            ++n2;
        }
        gc.setForeground(origColor);
        gc.setLineWidth(origLineWidth);
    }

    private IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] orderItemsByLengthDescending(List<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem> sameStartAddressitems) {
        if (sameStartAddressitems.isEmpty() || sameStartAddressitems.size() == 1) {
            return sameStartAddressitems.toArray(new IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[sameStartAddressitems.size()]);
        }
        boolean swapped = true;
        int i = 0;
        while (i < sameStartAddressitems.size() - 1) {
            swapped = false;
            int j = 0;
            while (j < sameStartAddressitems.size() - i - 1) {
                if (sameStartAddressitems.get(j).getRangeInAddressableUnits().compareTo(sameStartAddressitems.get(j + 1).getRangeInAddressableUnits()) < 0) {
                    IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem temp = sameStartAddressitems.get(j);
                    sameStartAddressitems.set(j, sameStartAddressitems.get(j + 1));
                    sameStartAddressitems.set(j + 1, temp);
                    swapped = true;
                }
                ++j;
            }
            if (!swapped) break;
            ++i;
        }
        return sameStartAddressitems.toArray(new IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[sameStartAddressitems.size()]);
    }

    private BigInteger[] orderItemsAscending(Set<BigInteger> keySet) {
        ArrayList<BigInteger> collection = new ArrayList<BigInteger>(keySet);
        Collections.sort(collection);
        return collection.toArray(new BigInteger[collection.size()]);
    }

    private Color resolveColor(int intColor) {
        return new Color((Device)this.getDisplay(), intColor >> 16, intColor >> 8 & 0xFF, intColor & 0xFF);
    }

    private boolean isRowVisible(int y) {
        int firstVisibleRow = this.getAddressLocation((BigInteger)this.fRendering.getViewportStartAddress()).y;
        int lastVisibleRow = this.getAddressLocation((BigInteger)this.fRendering.getViewportEndAddress()).y;
        return y >= firstVisibleRow && y <= lastVisibleRow;
    }

    private void drawRectangleOpenStart(Point location, int width, int height, GC gc) {
        gc.drawRectangle(location.x, location.y, width, height);
        this.eraseVerticalLine(location, height, gc);
    }

    private void drawRectangleOpenEnd(Point location, int width, int height, GC gc) {
        gc.drawRectangle(location.x, location.y, width, height);
        Point erasep = new Point(location.x + width, location.y);
        this.eraseVerticalLine(erasep, height, gc);
    }

    private void eraseVerticalLine(Point erasep, int height, GC gc) {
        Color currentColor = gc.getForeground();
        gc.setForeground(this.fRendering.getTraditionalRendering().getColorBackground());
        gc.drawLine(erasep.x, erasep.y, erasep.x, erasep.y + height);
        gc.setForeground(currentColor);
    }

    private void drawParallelLines(Point location, int width, int height, GC gc) {
        gc.drawRectangle(location.x, location.y, width, height);
        this.eraseVerticalLine(location, height, gc);
        Point erasep = new Point(location.x + width, location.y);
        this.eraseVerticalLine(erasep, height, gc);
    }

    protected void applyCustomColor(GC gc, TraditionalMemoryByte[] bytes, int col) {
        boolean anyByteEditing = false;
        int n = 0;
        while (n < bytes.length && !anyByteEditing) {
            if (bytes[n] instanceof TraditionalMemoryByte && bytes[n].isEdited()) {
                anyByteEditing = true;
            }
            ++n;
        }
        TraditionalRendering ren = this.fRendering.getTraditionalRendering();
        if (this.isOdd(col)) {
            gc.setForeground(ren.getColorText());
        } else {
            gc.setForeground(ren.getColorTextAlternate());
        }
        gc.setBackground(ren.getColorBackground());
        if (anyByteEditing) {
            gc.setForeground(ren.getColorEdit());
            gc.setFont(ren.getFontEdit(gc.getFont()));
        } else {
            boolean isColored = false;
            int i = 0;
            while (i < this.fRendering.getHistoryDepth() && !isColored) {
                int n2 = 0;
                while (n2 < bytes.length) {
                    if (bytes[n2].isChanged(i)) {
                        if (i == 0) {
                            gc.setForeground(ren.getColorsChanged()[i]);
                        } else {
                            gc.setBackground(ren.getColorsChanged()[i]);
                        }
                        gc.setFont(ren.getFontChanged(gc.getFont()));
                        isColored = true;
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fToolTipShell != null) {
            this.fToolTipShell.dispose();
            this.fToolTipShell = null;
        }
    }

    @Override
    protected MouseTrackAdapter createMouseHoverListener() {
        return new DataPaneMouseHoverListener();
    }

    private int getAddressableOctetsPerColumn() {
        int addressableSize = this.fRendering.getAddressableSize() > 0 ? this.fRendering.getAddressableSize() : 1;
        return this.fRendering.getBytesPerColumn() / addressableSize;
    }

    class DataPaneMouseHoverListener
    extends MouseTrackAdapter {
        private BigInteger fTooltipAddress = null;
        private final Label fLabelContent = this.createToolTip();

        DataPaneMouseHoverListener() {
        }

        public void mouseExit(MouseEvent e) {
            if (DataPane.this.fToolTipShell != null && !DataPane.this.fToolTipShell.isDisposed()) {
                DataPane.this.fToolTipShell.setVisible(false);
                this.fTooltipAddress = null;
            }
        }

        public void mouseHover(MouseEvent e) {
            if (e.widget == null || !(e.widget instanceof Control) || DataPane.this.fToolTipShell == null || DataPane.this.fToolTipShell.isDisposed()) {
                return;
            }
            Control control = (Control)e.widget;
            BigInteger address = DataPane.this.getAddressAt(e.x, e.y);
            if (address == null) {
                return;
            }
            Point hoverPoint = control.toDisplay(new Point(e.x, e.y));
            if (DataPane.this.fToolTipShell.isVisible() && address.equals(this.fTooltipAddress)) {
                return;
            }
            this.diplayToolTip(hoverPoint, address);
            this.fTooltipAddress = address;
        }

        private void diplayToolTip(Point hoverPoint, BigInteger subAddress) {
            String info;
            StringBuilder sb = new StringBuilder("0x").append(subAddress.toString(16));
            if (DataPane.this.fRendering.hasAddressInfo(subAddress) && (info = DataPane.this.fRendering.buildAddressInfoString(subAddress, "\n", true)).length() > 0) {
                sb.append("\n").append(info);
            }
            this.fLabelContent.setText(sb.toString());
            Rectangle shellBounds = DataPane.this.fToolTipShell.getBounds();
            shellBounds.x = hoverPoint.x;
            shellBounds.y = hoverPoint.y + DataPane.this.getCellHeight();
            DataPane.this.fToolTipShell.setBounds(shellBounds);
            DataPane.this.fToolTipShell.pack();
            DataPane.this.fToolTipShell.setVisible(true);
        }

        private Label createToolTip() {
            if (DataPane.this.fToolTipShell != null) {
                DataPane.this.fToolTipShell.dispose();
            }
            DataPane.this.fToolTipShell = new Shell(DataPane.this.getShell(), 16400);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.marginWidth = 2;
            gridLayout.marginHeight = 0;
            DataPane.this.fToolTipShell.setLayout((Layout)gridLayout);
            DataPane.this.fToolTipShell.setBackground(DataPane.this.fToolTipShell.getDisplay().getSystemColor(29));
            return this.createToolTipContent((Composite)DataPane.this.fToolTipShell);
        }

        private Label createToolTipContent(Composite composite) {
            Label toolTipContent = new Label(composite, 0);
            toolTipContent.setForeground(composite.getDisplay().getSystemColor(28));
            toolTipContent.setBackground(composite.getDisplay().getSystemColor(29));
            toolTipContent.setLayoutData((Object)new GridData(772));
            return toolTipContent;
        }
    }
}

