/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint2;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public abstract class AbstractLineBreakpoint
extends CBreakpoint
implements ICLineBreakpoint2 {
    public AbstractLineBreakpoint() {
    }

    public AbstractLineBreakpoint(IResource resource, Map<String, Object> attributes, boolean add) throws CoreException {
        super(resource, attributes, add);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    @Override
    public String getAddress() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.address", "");
    }

    @Override
    public String getFileName() throws CoreException {
        String fileName = this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.sourceHandle", "");
        Path path = new Path(fileName);
        return path.isValidPath(fileName) ? path.lastSegment() : null;
    }

    @Override
    public String getFunction() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.function", "");
    }

    @Override
    public void setAddress(String address) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.address", address);
    }

    @Override
    public void setFunction(String function) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.function", function);
    }

    @Override
    public int getRequestedLine() throws CoreException {
        return this.ensureMarker().getAttribute("requestedLine", -1);
    }

    @Override
    public void setRequestedLine(int line) throws CoreException {
        this.setAttribute("requestedLine", line);
    }

    @Override
    public int getRequestedCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("requestedCharStart", -1);
    }

    @Override
    public void setRequestedCharStart(int charStart) throws CoreException {
        this.setAttribute("requestedCharStart", charStart);
    }

    @Override
    public int getRequestedCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("requestedCharEnd", -1);
    }

    @Override
    public void setRequestedCharEnd(int charEnd) throws CoreException {
        this.setAttribute("requestedCharEnd", charEnd);
    }

    @Override
    public String getRequestedSourceHandle() throws CoreException {
        return this.ensureMarker().getAttribute("requestedSourceHandle", "");
    }

    @Override
    public void setRequestedSourceHandle(String fileName) throws CoreException {
        this.setAttribute("requestedSourceHandle", fileName);
        this.setAttribute("resetInstalledLocation", Boolean.TRUE);
    }

    @Override
    public synchronized int decrementInstallCount() throws CoreException {
        int count = super.decrementInstallCount();
        if (count == 0 && Boolean.TRUE.equals(this.getMarker().getAttribute("resetInstalledLocation"))) {
            this.resetInstalledLocation();
            this.setAttribute("resetInstalledLocation", Boolean.FALSE);
        }
        return count;
    }

    @Override
    public void setInstalledLineNumber(int line) throws CoreException {
        int existingValue = this.ensureMarker().getAttribute("lineNumber", -1);
        if (line != existingValue) {
            this.setAttribute("lineNumber", line);
            this.setAttribute("resetInstalledLocation", Boolean.TRUE);
            this.setAttribute("message", this.getMarkerMessage());
        }
    }

    @Override
    public void setInstalledCharStart(int charStart) throws CoreException {
        int existingValue = this.ensureMarker().getAttribute("charStart", -1);
        if (charStart != existingValue) {
            this.setAttribute("charStart", charStart);
            this.setAttribute("resetInstalledLocation", Boolean.TRUE);
            this.setAttribute("message", this.getMarkerMessage());
        }
    }

    @Override
    public void setInstalledCharEnd(int charEnd) throws CoreException {
        int existingValue = this.ensureMarker().getAttribute("charEnd", -1);
        if (charEnd != existingValue) {
            this.setAttribute("charEnd", charEnd);
            this.setAttribute("resetInstalledLocation", Boolean.TRUE);
            this.setAttribute("message", this.getMarkerMessage());
        }
    }

    @Override
    public void resetInstalledLocation() throws CoreException {
        boolean locationReset = false;
        if (this.getMarker().getAttribute("requestedLine") != null) {
            int line = this.getMarker().getAttribute("requestedLine", -1);
            this.setAttribute("lineNumber", line);
            locationReset = true;
        }
        if (this.getMarker().getAttribute("requestedCharStart") != null) {
            int charStart = this.getMarker().getAttribute("requestedCharStart", -1);
            this.setAttribute("charStart", charStart);
            locationReset = true;
        }
        if (this.getMarker().getAttribute("requestedCharEnd") != null) {
            int charEnd = this.getMarker().getAttribute("requestedCharEnd", -1);
            this.setAttribute("charEnd", charEnd);
            locationReset = true;
        }
        if (this.getMarker().getAttribute("requestedSourceHandle") != null) {
            String file = this.getMarker().getAttribute("requestedSourceHandle", "");
            this.setAttribute("org.eclipse.cdt.debug.core.sourceHandle", file);
            locationReset = true;
        }
        if (locationReset) {
            this.setAttribute("message", this.getMarkerMessage());
        }
    }

    @Override
    public void refreshMessage() throws CoreException {
        IMarker marker = this.ensureMarker();
        marker.setAttribute("message", (Object)this.getMarkerMessage());
    }
}

